/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.mvcc.MvccEmptyLongList;
import org.apache.ignite.internal.processors.cache.mvcc.MvccLongList;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class MvccSnapshotWithoutTxs
implements MvccSnapshot {
    private static final long serialVersionUID = 0L;
    private long crdVer;
    private long cntr;
    private long cleanupVer;
    private int opCntr;

    public MvccSnapshotWithoutTxs() {
    }

    public MvccSnapshotWithoutTxs(long crdVer, long cntr, int opCntr, long cleanupVer) {
        this.crdVer = crdVer;
        this.cntr = cntr;
        this.cleanupVer = cleanupVer;
        this.opCntr = opCntr;
    }

    @Override
    public MvccLongList activeTransactions() {
        return MvccEmptyLongList.INSTANCE;
    }

    @Override
    public long coordinatorVersion() {
        return this.crdVer;
    }

    @Override
    public long cleanupVersion() {
        return this.cleanupVer;
    }

    @Override
    public long counter() {
        return this.cntr;
    }

    @Override
    public int operationCounter() {
        return this.opCntr;
    }

    @Override
    public void incrementOperationCounter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MvccSnapshot withoutActiveTransactions() {
        return this;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("cleanupVer", this.cleanupVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("cntr", this.cntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("crdVer", this.crdVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeInt("opCntr", this.opCntr)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cleanupVer = reader.readLong("cleanupVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.cntr = reader.readLong("cntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.crdVer = reader.readLong("crdVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.opCntr = reader.readInt("opCntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(MvccSnapshotWithoutTxs.class);
    }

    @Override
    public short directType() {
        return 150;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(MvccSnapshotWithoutTxs.class, this);
    }
}

