/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsSingleMessage
extends GridDhtPartitionsAbstractMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, GridDhtPartitionMap> parts;
    @GridDirectMap(keyType=Integer.class, valueType=Integer.class)
    private Map<Integer, Integer> dupPartsData;
    private byte[] partsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, Object> partCntrs;
    private byte[] partCntrsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, Map<Integer, Long>> partsSizes;
    private byte[] partsSizesBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, Map<Integer, Long>> partHistCntrs;
    private byte[] partHistCntrsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private Exception err;
    private byte[] errBytes;
    private boolean client;
    @GridDirectCollection(value=Integer.class)
    private Collection<Integer> grpsAffRequest;
    private long exchangeStartTime;
    private GridDhtPartitionsFullMessage finishMsg;

    public GridDhtPartitionsSingleMessage() {
    }

    public GridDhtPartitionsSingleMessage(GridDhtPartitionExchangeId exchId, boolean client, @Nullable GridCacheVersion lastVer, boolean compress) {
        super(exchId, lastVer);
        this.compressed(compress);
        this.client = client;
    }

    void finishMessage(GridDhtPartitionsFullMessage finishMsg) {
        this.finishMsg = finishMsg;
    }

    GridDhtPartitionsFullMessage finishMessage() {
        return this.finishMsg;
    }

    void cacheGroupsAffinityRequest(Collection<Integer> grpsAffRequest) {
        this.grpsAffRequest = grpsAffRequest;
    }

    @Nullable
    public Collection<Integer> cacheGroupsAffinityRequest() {
        return this.grpsAffRequest;
    }

    @Override
    public int handlerId() {
        return 0;
    }

    public boolean client() {
        return this.client;
    }

    public void addLocalPartitionMap(int cacheId, GridDhtPartitionMap locMap, @Nullable Integer dupDataCache) {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionMap>();
        }
        this.parts.put(cacheId, locMap);
        if (dupDataCache != null) {
            assert (this.compressed());
            assert (F.isEmpty(locMap.map()));
            assert (this.parts.containsKey(dupDataCache));
            if (this.dupPartsData == null) {
                this.dupPartsData = new HashMap<Integer, Integer>();
            }
            this.dupPartsData.put(cacheId, dupDataCache);
        }
    }

    public void addPartitionUpdateCounters(int grpId, Object cntrMap) {
        if (this.partCntrs == null) {
            this.partCntrs = new HashMap<Integer, Object>();
        }
        this.partCntrs.put(grpId, cntrMap);
    }

    public CachePartitionPartialCountersMap partitionUpdateCounters(int grpId, int partsCnt) {
        Object res;
        Object object = res = this.partCntrs == null ? null : this.partCntrs.get(grpId);
        if (res == null) {
            return CachePartitionPartialCountersMap.EMPTY;
        }
        if (res instanceof CachePartitionPartialCountersMap) {
            return (CachePartitionPartialCountersMap)res;
        }
        assert (res instanceof Map) : res;
        Map map = (Map)res;
        return CachePartitionPartialCountersMap.fromCountersMap(map, partsCnt);
    }

    public void addPartitionSizes(int grpId, Map<Integer, Long> partSizesMap) {
        if (partSizesMap.isEmpty()) {
            return;
        }
        if (this.partsSizes == null) {
            this.partsSizes = new HashMap<Integer, Map<Integer, Long>>();
        }
        this.partsSizes.put(grpId, partSizesMap);
    }

    public Map<Integer, Long> partitionSizes(int grpId) {
        if (this.partsSizes == null) {
            return Collections.emptyMap();
        }
        return this.partsSizes.getOrDefault(grpId, Collections.emptyMap());
    }

    public void partitionHistoryCounters(int grpId, Map<Integer, Long> cntrMap) {
        if (cntrMap.isEmpty()) {
            return;
        }
        if (this.partHistCntrs == null) {
            this.partHistCntrs = new HashMap<Integer, Map<Integer, Long>>();
        }
        this.partHistCntrs.put(grpId, cntrMap);
    }

    void partitionHistoryCounters(Map<Integer, Map<Integer, Long>> cntrMap) {
        for (Map.Entry<Integer, Map<Integer, Long>> e : cntrMap.entrySet()) {
            this.partitionHistoryCounters(e.getKey(), e.getValue());
        }
    }

    Map<Integer, Long> partitionHistoryCounters(int grpId) {
        if (this.partHistCntrs != null) {
            Map<Integer, Long> res = this.partHistCntrs.get(grpId);
            return res != null ? res : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public Map<Integer, GridDhtPartitionMap> partitions() {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionMap>();
        }
        return this.parts;
    }

    public void setError(Exception ex) {
        this.err = ex;
    }

    @Nullable
    public Exception getError() {
        return this.err;
    }

    public long exchangeStartTime() {
        return this.exchangeStartTime;
    }

    public void exchangeStartTime(long exchangeStartTime) {
        this.exchangeStartTime = exchangeStartTime;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        boolean marshal;
        super.prepareMarshal(ctx);
        boolean bl = marshal = this.parts != null && this.partsBytes == null || this.partCntrs != null && this.partCntrsBytes == null || this.partHistCntrs != null && this.partHistCntrsBytes == null || this.partsSizes != null && this.partsSizesBytes == null || this.err != null && this.errBytes == null;
        if (marshal) {
            byte[] partsBytes0 = null;
            byte[] partCntrsBytes0 = null;
            byte[] partHistCntrsBytes0 = null;
            byte[] partsSizesBytes0 = null;
            byte[] errBytes0 = null;
            if (this.parts != null && this.partsBytes == null) {
                partsBytes0 = U.marshal(ctx, this.parts);
            }
            if (this.partCntrs != null && this.partCntrsBytes == null) {
                partCntrsBytes0 = U.marshal(ctx, this.partCntrs);
            }
            if (this.partHistCntrs != null && this.partHistCntrsBytes == null) {
                partHistCntrsBytes0 = U.marshal(ctx, this.partHistCntrs);
            }
            if (this.partsSizes != null && this.partsSizesBytes == null) {
                partsSizesBytes0 = U.marshal(ctx, this.partsSizes);
            }
            if (this.err != null && this.errBytes == null) {
                errBytes0 = U.marshal(ctx, (Object)this.err);
            }
            if (this.compressed()) {
                try {
                    byte[] partsBytesZip = U.zip(partsBytes0);
                    byte[] partCntrsBytesZip = U.zip(partCntrsBytes0);
                    byte[] partHistCntrsBytesZip = U.zip(partHistCntrsBytes0);
                    byte[] partsSizesBytesZip = U.zip(partsSizesBytes0);
                    byte[] exBytesZip = U.zip(errBytes0);
                    partsBytes0 = partsBytesZip;
                    partCntrsBytes0 = partCntrsBytesZip;
                    partHistCntrsBytes0 = partHistCntrsBytesZip;
                    partsSizesBytes0 = partsSizesBytesZip;
                    errBytes0 = exBytesZip;
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx.logger(this.getClass()), "Failed to compress partitions data: " + e, e);
                }
            }
            this.partsBytes = partsBytes0;
            this.partCntrsBytes = partCntrsBytes0;
            this.partHistCntrsBytes = partHistCntrsBytes0;
            this.partsSizesBytes = partsSizesBytes0;
            this.errBytes = errBytes0;
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.partsBytes != null && this.parts == null) {
            this.parts = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            this.partCntrs = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partHistCntrsBytes != null && this.partHistCntrs == null) {
            this.partHistCntrs = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partHistCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partHistCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partsSizesBytes != null && this.partsSizes == null) {
            this.partsSizes = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsSizesBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partsSizesBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.errBytes != null && this.err == null) {
            this.err = this.compressed() ? (Exception)U.unmarshalZip(ctx.marshaller(), this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Exception)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.dupPartsData != null) {
            assert (this.parts != null);
            for (Map.Entry<Integer, Integer> e : this.dupPartsData.entrySet()) {
                GridDhtPartitionMap map1 = this.parts.get(e.getKey());
                assert (map1 != null) : e.getKey();
                assert (F.isEmpty(map1.map()));
                assert (!map1.hasMovingPartitions());
                GridDhtPartitionMap map2 = this.parts.get(e.getValue());
                assert (map2 != null) : e.getValue();
                assert (map2.map() != null);
                for (Map.Entry<Integer, GridDhtPartitionState> e0 : map2.map().entrySet()) {
                    map1.put(e0.getKey(), e0.getValue());
                }
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 6: {
                if (!writer.writeBoolean("client", this.client)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMap("dupPartsData", this.dupPartsData, MessageCollectionItemType.INT, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeLong("exchangeStartTime", this.exchangeStartTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("finishMsg", this.finishMsg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeCollection("grpsAffRequest", this.grpsAffRequest, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByteArray("partCntrsBytes", this.partCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByteArray("partHistCntrsBytes", this.partHistCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeByteArray("partsSizesBytes", this.partsSizesBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 6: {
                this.client = reader.readBoolean("client");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.dupPartsData = reader.readMap("dupPartsData", MessageCollectionItemType.INT, MessageCollectionItemType.INT, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.exchangeStartTime = reader.readLong("exchangeStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.finishMsg = (GridDhtPartitionsFullMessage)reader.readMessage("finishMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.grpsAffRequest = reader.readCollection("grpsAffRequest", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.partCntrsBytes = reader.readByteArray("partCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.partHistCntrsBytes = reader.readByteArray("partHistCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.partsSizesBytes = reader.readByteArray("partsSizesBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsSingleMessage.class);
    }

    @Override
    public short directType() {
        return 47;
    }

    @Override
    public byte fieldsCount() {
        return 16;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsSingleMessage.class, this, super.toString());
    }
}

