/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTaskSessionScope;
import org.apache.ignite.events.CheckpointEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.GridTaskSessionInternal;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.checkpoint.GridCheckpointRequest;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

@SkipDaemon
public class GridCheckpointManager
extends GridManagerAdapter<CheckpointSpi> {
    public static final int MAX_CLOSED_SESS = 10240;
    private final GridMessageListener lsnr = new CheckpointRequestListener();
    private final ConcurrentMap<IgniteUuid, CheckpointSet> keyMap;
    private final Collection<IgniteUuid> closedSess;
    private final Marshaller marsh;

    public GridCheckpointManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getCheckpointSpi());
        this.marsh = ctx.config().getMarshaller();
        if (this.enabled()) {
            this.keyMap = new ConcurrentHashMap<IgniteUuid, CheckpointSet>();
            this.closedSess = new GridBoundedConcurrentLinkedHashSet<IgniteUuid>(10240, 10240, 0.75f, 256, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);
        } else {
            this.keyMap = null;
            this.closedSess = null;
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (CheckpointSpi spi : (CheckpointSpi[])this.getSpis()) {
            spi.setCheckpointListener(new CheckpointListener(){

                @Override
                public void onCheckpointRemoved(String key) {
                    GridCheckpointManager.this.record(3, key);
                }
            });
        }
        this.startSpi();
        this.ctx.io().addMessageListener(GridTopic.TOPIC_CHECKPOINT, this.lsnr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        GridIoManager comm = this.ctx.io();
        if (comm != null) {
            comm.removeMessageListener(GridTopic.TOPIC_CHECKPOINT, this.lsnr);
        }
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public Collection<IgniteUuid> sessionIds() {
        return this.enabled() ? new ArrayList(this.keyMap.keySet()) : Collections.emptyList();
    }

    public boolean storeCheckpoint(GridTaskSessionInternal ses, String key, Object state, ComputeTaskSessionScope scope, long timeout, boolean override) throws IgniteCheckedException {
        if (!this.enabled()) {
            return false;
        }
        assert (ses != null);
        assert (key != null);
        long now = U.currentTimeMillis();
        boolean saved = false;
        try {
            switch (scope) {
                case GLOBAL_SCOPE: {
                    byte[] data = state == null ? null : U.marshal(this.marsh, state);
                    saved = ((CheckpointSpi)this.getSpi(ses.getCheckpointSpi())).saveCheckpoint(key, data, timeout, override);
                    if (saved) {
                        this.record(1, key);
                    }
                    break;
                }
                case SESSION_SCOPE: {
                    if (this.closedSess.contains(ses.getId())) {
                        U.warn(this.log, S.toString("Checkpoint will not be saved due to session invalidation", "key", (Object)key, true, "val", state, true, "ses", (Object)ses, false));
                        break;
                    }
                    if (now > ses.getEndTime()) {
                        U.warn(this.log, S.toString("Checkpoint will not be saved due to session timeout", "key", (Object)key, true, "val", state, true, "ses", (Object)ses, false));
                        break;
                    }
                    if (now + timeout > ses.getEndTime() || now + timeout < 0L) {
                        timeout = ses.getEndTime() - now;
                    }
                    byte[] data = state == null ? null : U.marshal(this.marsh, state);
                    Set keys = (Set)this.keyMap.get(ses.getId());
                    if (keys == null) {
                        keys = new CheckpointSet(ses.session());
                        Set old = this.keyMap.putIfAbsent(ses.getId(), (CheckpointSet)keys);
                        if (old != null) {
                            keys = old;
                        }
                        if (this.closedSess.contains(ses.getId())) {
                            U.warn(this.log, S.toString("Checkpoint will not be saved due to session invalidation", "key", (Object)key, true, "val", state, true, "ses", (Object)ses, false));
                            this.keyMap.remove(ses.getId(), keys);
                            break;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(S.toString("Resolved keys for session", "keys", (Object)keys, true, "ses", (Object)ses, false, "keyMap", this.keyMap, false));
                    }
                    if (keys != null) {
                        ClusterNode node;
                        if (ses.getJobId() != null && (node = this.ctx.discovery().node(ses.getTaskNodeId())) != null) {
                            this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_CHECKPOINT, (Message)new GridCheckpointRequest(ses.getId(), key, ses.getCheckpointSpi()), (byte)0);
                        }
                        if (saved = ((CheckpointSpi)this.getSpi(ses.getCheckpointSpi())).saveCheckpoint(key, data, timeout, override)) {
                            keys.add(key);
                            this.record(1, key);
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : "Unknown checkpoint scope: " + (Object)((Object)scope);
                    break;
                }
            }
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException(S.toString("Failed to save checkpoint", "key", (Object)key, true, "val", state, true, "scope", (Object)scope, false, "timeout", (Object)timeout, false), e);
        }
        return saved;
    }

    public boolean removeCheckpoint(String key) {
        if (!this.enabled()) {
            return false;
        }
        assert (key != null);
        boolean rmv = false;
        for (CheckpointSpi spi : (CheckpointSpi[])this.getSpis()) {
            if (!spi.removeCheckpoint(key)) continue;
            rmv = true;
        }
        return rmv;
    }

    public boolean removeCheckpoint(GridTaskSessionInternal ses, String key) {
        if (!this.enabled()) {
            return false;
        }
        assert (ses != null);
        assert (key != null);
        Set keys = (Set)this.keyMap.get(ses.getId());
        boolean rmv = false;
        if (keys != null) {
            keys.remove(key);
            rmv = ((CheckpointSpi)this.getSpi(ses.getCheckpointSpi())).removeCheckpoint(key);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Checkpoint will not be removed (key map not found)", "key", (Object)key, true, "ses", (Object)ses, false));
        }
        return rmv;
    }

    @Nullable
    public Serializable loadCheckpoint(GridTaskSessionInternal ses, String key) throws IgniteCheckedException {
        if (!this.enabled()) {
            return null;
        }
        assert (ses != null);
        assert (key != null);
        try {
            byte[] data = ((CheckpointSpi)this.getSpi(ses.getCheckpointSpi())).loadCheckpoint(key);
            Serializable state = null;
            if (data != null) {
                state = (Serializable)U.unmarshal(this.marsh, data, U.resolveClassLoader(ses.getClassLoader(), this.ctx.config()));
            }
            this.record(2, key);
            return state;
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException(S.includeSensitive() ? "Failed to load checkpoint: " + key : "Failed to load checkpoint", e);
        }
    }

    public void onSessionEnd(GridTaskSessionInternal ses, boolean cleanup) {
        CheckpointSet keys;
        if (!this.enabled()) {
            return;
        }
        this.closedSess.add(ses.getId());
        if (ses.getJobId() == null) {
            Set keys2 = (Set)this.keyMap.remove(ses.getId());
            if (keys2 != null) {
                for (String key : keys2) {
                    ((CheckpointSpi)this.getSpi(ses.getCheckpointSpi())).removeCheckpoint(key);
                }
            }
        } else if (cleanup && (keys = (CheckpointSet)this.keyMap.get(ses.getId())) != null && keys.session() == ses.session()) {
            this.keyMap.remove(ses.getId(), keys);
        }
    }

    private void record(int type, String key) {
        if (this.ctx.event().isRecordable(type)) {
            String msg;
            if (type == 1) {
                msg = "Checkpoint saved";
            } else if (type == 2) {
                msg = "Checkpoint loaded";
            } else {
                assert (type == 3) : "Invalid event type: " + type;
                msg = "Checkpoint removed";
            }
            if (S.includeSensitive()) {
                msg = msg + ": " + key;
            }
            this.ctx.event().record(new CheckpointEvent(this.ctx.discovery().localNode(), msg, type, key));
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Checkpoint manager memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>  keyMap: " + (this.keyMap != null ? this.keyMap.size() : 0), new Object[0]);
    }

    private class CheckpointRequestListener
    implements GridMessageListener {
        private CheckpointRequestListener() {
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            GridCheckpointRequest req = (GridCheckpointRequest)msg;
            if (GridCheckpointManager.this.log.isDebugEnabled()) {
                GridCheckpointManager.this.log.debug("Received checkpoint request: " + req);
            }
            if (!GridCheckpointManager.this.enabled()) {
                return;
            }
            IgniteUuid sesId = req.getSessionId();
            if (GridCheckpointManager.this.closedSess.contains(sesId)) {
                ((CheckpointSpi)GridCheckpointManager.this.getSpi(req.getCheckpointSpi())).removeCheckpoint(req.getKey());
                return;
            }
            Set keys = (Set)GridCheckpointManager.this.keyMap.get(sesId);
            if (keys == null) {
                GridTaskSessionImpl ses = GridCheckpointManager.this.ctx.session().getSession(sesId);
                if (ses == null) {
                    ((CheckpointSpi)GridCheckpointManager.this.getSpi(req.getCheckpointSpi())).removeCheckpoint(req.getKey());
                    return;
                }
                keys = new CheckpointSet(ses);
                Set old = GridCheckpointManager.this.keyMap.putIfAbsent(sesId, keys);
                if (old != null) {
                    keys = old;
                }
            }
            keys.add(req.getKey());
            if (GridCheckpointManager.this.closedSess.contains(sesId)) {
                GridCheckpointManager.this.keyMap.remove(sesId, keys);
                ((CheckpointSpi)GridCheckpointManager.this.getSpi(req.getCheckpointSpi())).removeCheckpoint(req.getKey());
            }
        }
    }

    private static class CheckpointSet
    extends GridConcurrentHashSet<String> {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        private final GridTaskSessionInternal ses;

        private CheckpointSet(GridTaskSessionInternal ses) {
            this.ses = ses;
        }

        GridTaskSessionInternal session() {
            return this.ses;
        }

        @Override
        public String toString() {
            return S.toString(CheckpointSet.class, this);
        }
    }
}

