/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.property;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesImpl;

class BuilderImpl
implements SqlProperties.Builder {
    private final Map<Property<?>, Object> properties = new HashMap();

    BuilderImpl() {
    }

    @Override
    public <T> SqlProperties.Builder set(Property<T> property, T value) {
        Objects.requireNonNull(value, "value");
        if (!property.cls.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Unable to assign value of type \"{}\" to property {}", (Object[])new Object[]{value.getClass().getName(), property}));
        }
        this.properties.put(property, value);
        return this;
    }

    @Override
    public SqlProperties build() {
        return new SqlPropertiesImpl(Map.copyOf(this.properties));
    }
}

