/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.datapage;

import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.io.DataPageIo;
import org.apache.ignite.internal.pagememory.io.DataPagePayload;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.jetbrains.annotations.Nullable;

public abstract class NonFragmentableDataPageReader<T> {
    private final PageMemory pageMemory;
    private final int groupId;
    private final IoStatisticsHolder statisticsHolder;

    public NonFragmentableDataPageReader(PageMemory pageMemory, int groupId, IoStatisticsHolder statisticsHolder) {
        this.pageMemory = pageMemory;
        this.groupId = groupId;
        this.statisticsHolder = statisticsHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getRowByLink(long link) throws IgniteInternalCheckedException {
        assert (link != 0L);
        int pageSize = this.pageMemory.realPageSize(this.groupId);
        long pageId = PageIdUtils.pageId(link);
        long page = this.pageMemory.acquirePage(this.groupId, pageId, this.statisticsHolder);
        try {
            int itemId;
            DataPageIo dataIo;
            long pageAddr;
            block11: {
                T t;
                pageAddr = this.pageMemory.readLock(this.groupId, pageId, page);
                assert (pageAddr != 0L) : link;
                try {
                    dataIo = (DataPageIo)this.pageMemory.ioRegistry().resolve(pageAddr);
                    itemId = PageIdUtils.itemId(link);
                    if (!this.handleNonExistentItemsGracefully() || dataIo.itemExists(pageAddr, itemId, pageSize)) break block11;
                    t = this.rowForNonExistingItem(pageId, itemId);
                }
                catch (Throwable throwable) {
                    this.pageMemory.readUnlock(this.groupId, pageId, page);
                    throw throwable;
                }
                this.pageMemory.readUnlock(this.groupId, pageId, page);
                return t;
            }
            DataPagePayload data = dataIo.readPayload(pageAddr, itemId, pageSize);
            if (data.hasMoreFragments()) {
                throw new IllegalStateException("Value for link " + link + " is fragmented, which is not supported");
            }
            T t = this.readRowFromAddress(link, pageAddr + (long)data.offset());
            this.pageMemory.readUnlock(this.groupId, pageId, page);
            return t;
        }
        finally {
            this.pageMemory.releasePage(this.groupId, pageId, page);
        }
    }

    protected abstract T readRowFromAddress(long var1, long var3);

    protected boolean handleNonExistentItemsGracefully() {
        return false;
    }

    @Nullable
    protected T rowForNonExistingItem(long pageId, long itemId) {
        throw new IllegalStateException("Item is invalid for pageId=" + pageId + ", itemId=" + itemId);
    }
}

