/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.metrics.AbstractMetric;
import org.apache.ignite.internal.metrics.LongMetric;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class HitRateMetric
extends AbstractMetric
implements LongMetric {
    public static final int DFLT_SIZE = 10;
    private static final int TAG_OFFSET = 56;
    private static final long NO_TAG_MASK = 0xFFFFFFFFFFFFFFL;
    private final long rateTimeInterval;
    private final int size;
    private final AtomicLongArray taggedCounters;
    private final AtomicLongArray lastHitTimes;

    public HitRateMetric(String name, @Nullable String desc, long rateTimeInterval) {
        this(name, desc, rateTimeInterval, 10);
    }

    public HitRateMetric(String name, @Nullable String desc, long rateTimeInterval, int size) {
        super(name, desc);
        assert (rateTimeInterval > 0L) : "rateTimeInterval should be positive";
        assert (size > 1) : "Minimum value for size is 2";
        this.rateTimeInterval = rateTimeInterval;
        this.size = size;
        this.taggedCounters = new AtomicLongArray(size);
        this.lastHitTimes = new AtomicLongArray(size);
    }

    public void add(long hits) {
        long curTs = System.currentTimeMillis();
        int curPos = this.position(curTs);
        this.clearIfObsolete(curTs, curPos);
        this.lastHitTimes.set(curPos, curTs);
        this.taggedCounters.addAndGet(curPos, hits);
    }

    public void increment() {
        this.add(1L);
    }

    @Override
    public long value() {
        long curTs = System.currentTimeMillis();
        long sum = 0L;
        for (int i = 0; i < this.size; ++i) {
            this.clearIfObsolete(curTs, i);
            sum += HitRateMetric.untag(this.taggedCounters.get(i));
        }
        return sum;
    }

    private void clearIfObsolete(long curTs, int i) {
        long cur = this.taggedCounters.get(i);
        byte curTag = HitRateMetric.getTag(cur);
        long lastTs = this.lastHitTimes.get(i);
        if (this.isObsolete(curTs, lastTs) && this.taggedCounters.compareAndSet(i, cur, HitRateMetric.taggedLongZero(curTag = (byte)(curTag + 1)))) {
            this.lastHitTimes.set(i, curTs);
        }
    }

    private boolean isObsolete(long curTs, long lastHitTime) {
        return curTs - lastHitTime > this.rateTimeInterval * (long)(this.size - 1) / (long)this.size;
    }

    private int position(long time) {
        return (int)(time % this.rateTimeInterval * (long)this.size / this.rateTimeInterval);
    }

    private static long taggedLongZero(byte tag) {
        return (long)tag << 56;
    }

    private static long untag(long l) {
        return l & 0xFFFFFFFFFFFFFFL;
    }

    private static byte getTag(long taggedLong) {
        return (byte)(taggedLong >> 56);
    }
}

