/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.exporters.BasicMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.JmxExporterView;
import org.apache.ignite.internal.metrics.exporters.jmx.MetricSetMbean;
import org.apache.ignite.internal.util.IgniteUtils;

public class JmxExporter
extends BasicMetricExporter<JmxExporterView> {
    public static final String JMX_EXPORTER_NAME = "jmx";
    private static final String JMX_METRIC_GROUP = "metrics";
    private static IgniteLogger LOG = Loggers.forClass(JmxExporter.class);
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();

    @Override
    public synchronized void start(MetricProvider metricsProvider, JmxExporterView configuration) {
        super.start(metricsProvider, configuration);
        for (MetricSet metricSet : ((Map)metricsProvider.metrics().get1()).values()) {
            this.register(metricSet);
        }
    }

    @Override
    public synchronized void stop() {
        this.mbeans.forEach(this::unregBean);
        this.mbeans.clear();
    }

    @Override
    public String name() {
        return JMX_EXPORTER_NAME;
    }

    @Override
    public synchronized void addMetricSet(MetricSet metricSet) {
        this.register(metricSet);
    }

    @Override
    public synchronized void removeMetricSet(String metricSet) {
        this.unregister(metricSet);
    }

    private void register(MetricSet metricSet) {
        try {
            MetricSetMbean metricSetMbean = new MetricSetMbean(metricSet);
            ObjectName mbean = ManagementFactory.getPlatformMBeanServer().registerMBean(metricSetMbean, IgniteUtils.makeMbeanName((String)JMX_METRIC_GROUP, (String)metricSet.name())).getObjectName();
            this.mbeans.add(mbean);
        }
        catch (JMException e) {
            LOG.error("MBean for metric set " + metricSet.name() + " can't be created.", (Throwable)e);
        }
    }

    private void unregister(String metricSetName) {
        try {
            ObjectName mbeanName = IgniteUtils.makeMbeanName((String)JMX_METRIC_GROUP, (String)metricSetName);
            boolean rmv = this.mbeans.remove(mbeanName);
            if (rmv) {
                this.unregBean(mbeanName);
            } else {
                LOG.warn("Tried to unregister the MBean for non-registered metric set " + metricSetName, new Object[0]);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error("MBean for metric set " + metricSetName + " can't be unregistered.", (Throwable)e);
        }
    }

    private void unregBean(ObjectName bean) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(bean);
        }
        catch (JMException e) {
            LOG.error("Failed to unregister MBean: " + bean, (Throwable)e);
        }
    }
}

