/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import java.util.Arrays;
import org.apache.ignite.internal.metastorage.client.Operation;
import org.apache.ignite.internal.metastorage.client.StatementResult;
import org.apache.ignite.internal.metastorage.client.Update;
import org.apache.ignite.lang.ByteArray;

public final class Operations {
    private static final Operation.NoOp NO_OP = new Operation.NoOp();
    private final Operation[] operations;

    private Operations(Operation ... operations) {
        this.operations = operations;
    }

    public Update yield(boolean result) {
        return new Update(Arrays.asList(this.operations), new StatementResult(result));
    }

    public Update yield(int result) {
        return new Update(Arrays.asList(this.operations), new StatementResult(result));
    }

    public Update yield() {
        return new Update(Arrays.asList(this.operations), new StatementResult(new byte[0]));
    }

    public static Operations ops(Operation ... operations) {
        return new Operations(operations);
    }

    public static Operation remove(ByteArray key) {
        return new Operation(new Operation.RemoveOp(key.bytes()));
    }

    public static Operation put(ByteArray key, byte[] value) {
        return new Operation(new Operation.PutOp(key.bytes(), value));
    }

    public static Operation noop() {
        return new Operation(NO_OP);
    }
}

