/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.compute.message.ExecuteRequest;
import org.apache.ignite.internal.compute.message.ExecuteRequestBuilder;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ExecuteRequestImpl
implements ExecuteRequest {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private Object[] args;
    private byte[] argsByteArray;
    @IgniteToStringInclude
    private final String jobClassName;

    private ExecuteRequestImpl(Object[] args, byte[] argsByteArray, String jobClassName) {
        this.args = args;
        this.argsByteArray = argsByteArray;
        this.jobClassName = jobClassName;
    }

    byte[] argsByteArray() {
        return this.argsByteArray;
    }

    @Override
    public Object[] args() {
        return this.args;
    }

    @Override
    public String jobClassName() {
        return this.jobClassName;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(ExecuteRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExecuteRequestImpl otherMessage = (ExecuteRequestImpl)other;
        return Objects.equals(this.jobClassName, otherMessage.jobClassName) && Arrays.equals(this.args, otherMessage.args);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobClassName);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public static ExecuteRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject argsByteArraymo = marshaller.marshal((Object)this.args);
        usedDescriptors.addAll((IntCollection)argsByteArraymo.usedDescriptorIds());
        this.argsByteArray = argsByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.args = (Object[])marshaller.unmarshal(this.argsByteArray, descriptorsObj);
        this.argsByteArray = null;
    }

    private static class Builder
    implements ExecuteRequestBuilder {
        private Object[] args;
        private byte[] argsByteArray;
        private String jobClassName;

        private Builder() {
        }

        @Override
        public ExecuteRequestBuilder args(Object[] args) {
            this.args = args;
            return this;
        }

        @Override
        public ExecuteRequestBuilder argsByteArray(byte[] argsByteArray) {
            this.argsByteArray = argsByteArray;
            return this;
        }

        @Override
        public ExecuteRequestBuilder jobClassName(String jobClassName) {
            this.jobClassName = jobClassName;
            return this;
        }

        @Override
        public Object[] args() {
            return this.args;
        }

        @Override
        public byte[] argsByteArray() {
            return this.argsByteArray;
        }

        @Override
        public String jobClassName() {
            return this.jobClassName;
        }

        @Override
        public ExecuteRequest build() {
            return new ExecuteRequestImpl(this.args, this.argsByteArray, this.jobClassName);
        }
    }
}

