/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.configuration.util.ConfigurationSerializationUtil;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.lang.ByteArray;

public class LocalConfigurationStorage
implements ConfigurationStorage {
    private static final String LOC_PREFIX = "loc-cfg.";
    private static final ByteArray VERSION_KEY = new ByteArray("loc-cfg.$version");
    private static final IgniteLogger LOG = Loggers.forClass(LocalConfigurationStorage.class);
    private final VaultManager vaultMgr;
    private final AtomicReference<ConfigurationStorageListener> lsnrRef = new AtomicReference();
    private static final ByteArray LOC_KEYS_START_RANGE = ByteArray.fromString((String)"loc-cfg.");
    private static final ByteArray LOC_KEYS_END_RANGE = ByteArray.fromString((String)LocalConfigurationStorage.incrementLastChar("loc-cfg."));
    private final ExecutorService threadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("loc-cfg", LOG));
    private final InFlightFutures futureTracker = new InFlightFutures();
    private CompletableFuture<Void> writeSerializationFuture = CompletableFuture.completedFuture(null);
    private final Object writeSerializationLock = new Object();

    public LocalConfigurationStorage(VaultManager vaultMgr) {
        this.vaultMgr = vaultMgr;
    }

    public void close() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.futureTracker.cancelInFlightFutures();
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        ByteArray rangeStart = new ByteArray(LOC_PREFIX + prefix);
        ByteArray rangeEnd = new ByteArray(LocalConfigurationStorage.incrementLastChar(LOC_PREFIX + prefix));
        return this.readAll(rangeStart, rangeEnd).thenApply(Data::values);
    }

    public CompletableFuture<Serializable> readLatest(String key) {
        return ((CompletableFuture)this.vaultMgr.get(new ByteArray(LOC_PREFIX + key)).thenApply(entry -> entry == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])entry.value()))).exceptionally(e -> {
            throw new StorageException("Exception while reading vault entry", e);
        });
    }

    public CompletableFuture<Data> readDataOnRecovery() {
        return this.readAll(LOC_KEYS_START_RANGE, LOC_KEYS_END_RANGE);
    }

    private CompletableFuture<Data> readAll(ByteArray rangeStart, ByteArray rangeEnd) {
        return this.registerFuture(CompletableFuture.supplyAsync(() -> {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            long version = 0L;
            try (Cursor cursor = this.vaultMgr.range(rangeStart, rangeEnd);){
                for (VaultEntry entry : cursor) {
                    ByteArray key = entry.key();
                    Serializable value = ConfigurationSerializationUtil.fromBytes((byte[])entry.value());
                    if (key.equals((Object)VERSION_KEY)) {
                        version = (Long)value;
                        continue;
                    }
                    data.put(LocalConfigurationStorage.removePrefix(key), value);
                }
            }
            catch (Exception e) {
                throw new StorageException("Exception when closing a Vault cursor", (Throwable)e);
            }
            return new Data(data, version);
        }, this.threadPool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long sentVersion) {
        Object object = this.writeSerializationLock;
        synchronized (object) {
            CompletableFuture<Boolean> writeFuture = this.registerFuture((CompletableFuture)((CompletableFuture)this.writeSerializationFuture.thenCompose(v -> this.lastRevision())).thenComposeAsync(version -> {
                if (version != sentVersion) {
                    return CompletableFuture.completedFuture(false);
                }
                ConfigurationStorageListener lsnr = this.lsnrRef.get();
                assert (lsnr != null) : "Configuration listener must be initialized before write.";
                HashMap data = IgniteUtils.newHashMap((int)(newValues.size() + 1));
                for (Map.Entry e : newValues.entrySet()) {
                    ByteArray key = ByteArray.fromString((String)(LOC_PREFIX + (String)e.getKey()));
                    data.put(key, e.getValue() == null ? null : ConfigurationSerializationUtil.toBytes(e.getValue()));
                }
                byte[] previousVersion = data.put(VERSION_KEY, ConfigurationSerializationUtil.toBytes((Object)(version + 1L)));
                if (previousVersion != null) {
                    throw new IllegalStateException(String.format("\"%s\" is a reserved key and must not be changed externally", LocalConfigurationStorage.removePrefix(VERSION_KEY)));
                }
                Data entries = new Data(newValues, version + 1L);
                return ((CompletableFuture)this.vaultMgr.putAll((Map)data).thenCompose(v -> lsnr.onEntriesChanged(entries))).thenApply(v -> true);
            }, (Executor)this.threadPool));
            this.writeSerializationFuture = writeFuture.handle((v, e) -> null);
            return writeFuture;
        }
    }

    private static String removePrefix(ByteArray key) {
        return key.toString().substring(LOC_PREFIX.length());
    }

    public void registerConfigurationListener(ConfigurationStorageListener lsnr) {
        if (!this.lsnrRef.compareAndSet(null, lsnr)) {
            LOG.debug("Configuration listener has already been set", new Object[0]);
        }
    }

    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public CompletableFuture<Long> lastRevision() {
        return this.vaultMgr.get(VERSION_KEY).thenApply(entry -> entry == null ? 0L : (Long)ConfigurationSerializationUtil.fromBytes((byte[])entry.value()));
    }

    public CompletableFuture<Void> writeConfigurationRevision(long prevRevision, long currentRevision) {
        return CompletableFuture.completedFuture(null);
    }

    private static String incrementLastChar(String str) {
        char lastChar = str.charAt(str.length() - 1);
        return str.substring(0, str.length() - 1) + (char)(lastChar + '\u0001');
    }

    private <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        this.futureTracker.registerFuture(future);
        return future;
    }
}

