/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.ErrorResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class ErrorResponseImpl
implements RpcRequests.ErrorResponse {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3001;
    @IgniteToStringInclude
    private final int errorCode;
    @IgniteToStringInclude
    private final String errorMsg;
    @IgniteToStringInclude
    private final String leaderId;

    private ErrorResponseImpl(int errorCode, String errorMsg, String leaderId) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.leaderId = leaderId;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public String errorMsg() {
        return this.errorMsg;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ErrorResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3001;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorResponseImpl otherMessage = (ErrorResponseImpl)other;
        return Objects.equals(this.errorMsg, otherMessage.errorMsg) && Objects.equals(this.leaderId, otherMessage.leaderId) && this.errorCode == otherMessage.errorCode;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.errorCode, this.errorMsg, this.leaderId);
        return result;
    }

    public static ErrorResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ErrorResponseBuilder {
        private int errorCode;
        private String errorMsg;
        private String leaderId;

        private Builder() {
        }

        @Override
        public ErrorResponseBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public ErrorResponseBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        @Override
        public ErrorResponseBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public int errorCode() {
            return this.errorCode;
        }

        @Override
        public String errorMsg() {
            return this.errorMsg;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public RpcRequests.ErrorResponse build() {
            return new ErrorResponseImpl(this.errorCode, this.errorMsg, this.leaderId);
        }
    }
}

