/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.raft.CmgRaftGroupListener;
import org.apache.ignite.internal.cluster.management.raft.RaftStorageManager;
import org.apache.ignite.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class ValidationManager
implements AutoCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(CmgRaftGroupListener.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("node-validator", LOG));
    private final RaftStorageManager storage;
    private final Map<String, Future<?>> cleanupFutures = new ConcurrentHashMap();

    ValidationManager(RaftStorageManager storage) {
        this.storage = storage;
        storage.getValidatedNodeIds().forEach(this::scheduleValidatedNodeRemoval);
    }

    static ValidationResult validateState(@Nullable ClusterState state, ClusterNode node, ClusterState nodeState) {
        if (state == null) {
            return ValidationResult.errorResult("Cluster has not been initialized yet");
        }
        if (!state.cmgNodes().equals(nodeState.cmgNodes())) {
            return ValidationResult.errorResult(String.format("CMG node names do not match. CMG nodes: %s, nodes stored in CMG: %s", nodeState.cmgNodes(), state.cmgNodes()));
        }
        if (!state.metaStorageNodes().equals(nodeState.metaStorageNodes())) {
            return ValidationResult.errorResult(String.format("MetaStorage node names do not match. MetaStorage nodes: %s, nodes stored in CMG: %s", nodeState.metaStorageNodes(), state.metaStorageNodes()));
        }
        if (!state.igniteVersion().equals((Object)nodeState.igniteVersion())) {
            return ValidationResult.errorResult(String.format("Ignite versions do not match. Version: %s, version stored in CMG: %s", nodeState.igniteVersion(), state.igniteVersion()));
        }
        if (!state.clusterTag().clusterName().equals(nodeState.clusterTag().clusterName())) {
            return ValidationResult.errorResult(String.format("Cluster names do not match. Cluster name: %s, cluster name stored in CMG: %s", nodeState.clusterTag().clusterName(), state.clusterTag().clusterName()));
        }
        return ValidationResult.successfulResult();
    }

    ValidationResult validateNode(@Nullable ClusterState state, ClusterNode node, IgniteProductVersion version, ClusterTag clusterTag) {
        if (this.isNodeValidated(node)) {
            return ValidationResult.successfulResult();
        }
        if (state == null) {
            return ValidationResult.errorResult("Cluster has not been initialized yet");
        }
        if (!state.igniteVersion().equals((Object)version)) {
            return ValidationResult.errorResult(String.format("Ignite versions do not match. Version: %s, version stored in CMG: %s", version, state.igniteVersion()));
        }
        if (!state.clusterTag().equals(clusterTag)) {
            return ValidationResult.errorResult(String.format("Cluster tags do not match. Cluster tag: %s, cluster tag stored in CMG: %s", clusterTag, state.clusterTag()));
        }
        this.putValidatedNode(node);
        return ValidationResult.successfulResult();
    }

    boolean isNodeValidated(ClusterNode node) {
        return this.storage.isNodeValidated(node.id()) || this.storage.isNodeInLogicalTopology(node);
    }

    void completeValidation(ClusterNode node) {
        Future<?> cleanupFuture = this.cleanupFutures.remove(node.id());
        if (cleanupFuture != null) {
            cleanupFuture.cancel(false);
        }
        this.storage.removeValidatedNode(node.id());
    }

    private void putValidatedNode(ClusterNode node) {
        this.storage.putValidatedNode(node.id());
        this.scheduleValidatedNodeRemoval(node.id());
    }

    private void scheduleValidatedNodeRemoval(String nodeId) {
        ScheduledFuture<?> future = this.executor.schedule(() -> {
            LOG.info("Removing node from the list of validated nodes since no JoinReady requests have been received [node={}]", new Object[]{nodeId});
            this.cleanupFutures.remove(nodeId);
            this.storage.removeValidatedNode(nodeId);
        }, 1L, TimeUnit.HOURS);
        this.cleanupFutures.put(nodeId, future);
    }

    @Override
    public void close() {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.cleanupFutures.clear();
    }
}

