/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class IgniteTypeSystem
extends RelDataTypeSystemImpl
implements Serializable {
    public static final RelDataTypeSystem INSTANCE = new IgniteTypeSystem();

    public int getMaxNumericScale() {
        return Short.MAX_VALUE;
    }

    public int getMaxNumericPrecision() {
        return Short.MAX_VALUE;
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 9;
            }
        }
        return super.getMaxPrecision(typeName);
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 6;
            }
        }
        return super.getDefaultPrecision(typeName);
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        RelDataType sumType;
        block11: {
            block10: {
                if (!(argumentType instanceof BasicSqlType)) break block10;
                switch (argumentType.getSqlTypeName()) {
                    case INTEGER: 
                    case TINYINT: 
                    case SMALLINT: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
                        break block11;
                    }
                    case BIGINT: 
                    case DECIMAL: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL), argumentType.getScale()), argumentType.isNullable());
                        break block11;
                    }
                    case REAL: 
                    case FLOAT: 
                    case DOUBLE: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
                        break block11;
                    }
                    default: {
                        return super.deriveSumType(typeFactory, argumentType);
                    }
                }
            }
            switch (argumentType.getSqlTypeName()) {
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: {
                    sumType = typeFactory.createJavaType(Long.class);
                    break;
                }
                case BIGINT: 
                case DECIMAL: {
                    sumType = typeFactory.createJavaType(BigDecimal.class);
                    break;
                }
                case REAL: 
                case FLOAT: 
                case DOUBLE: {
                    sumType = typeFactory.createJavaType(Double.class);
                    break;
                }
                default: {
                    return super.deriveSumType(typeFactory, argumentType);
                }
            }
        }
        return typeFactory.createTypeWithNullability(sumType, argumentType.isNullable());
    }
}

