/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.RexImpTable;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.schema.ModifyRow;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.jetbrains.annotations.Nullable;

public class IgniteTableImpl
extends AbstractTable
implements InternalIgniteTable {
    private final TableDescriptor desc;
    private final int ver;
    private final InternalTable table;
    private final SchemaRegistry schemaRegistry;
    public final SchemaDescriptor schemaDescriptor;
    private final Statistic statistic;
    private Map<String, IgniteIndex> indexes = new HashMap<String, IgniteIndex>();
    private final List<ColumnDescriptor> columnsOrderedByPhysSchema;

    public IgniteTableImpl(TableDescriptor desc, InternalTable table, SchemaRegistry schemaRegistry) {
        this.ver = schemaRegistry.lastSchemaVersion();
        this.desc = desc;
        this.table = table;
        this.schemaRegistry = schemaRegistry;
        this.schemaDescriptor = schemaRegistry.schema();
        assert (this.schemaDescriptor != null);
        ArrayList<ColumnDescriptor> tmp = new ArrayList<ColumnDescriptor>(desc.columnsCount());
        for (int i = 0; i < desc.columnsCount(); ++i) {
            tmp.add(desc.columnDescriptor(i));
        }
        tmp.sort(Comparator.comparingInt(ColumnDescriptor::physicalIndex));
        this.columnsOrderedByPhysSchema = tmp;
        this.statistic = new StatisticsImpl();
    }

    private IgniteTableImpl(IgniteTableImpl t) {
        this.desc = t.desc;
        this.ver = t.ver;
        this.table = t.table;
        this.schemaRegistry = t.schemaRegistry;
        this.schemaDescriptor = t.schemaDescriptor;
        this.statistic = t.statistic;
        this.columnsOrderedByPhysSchema = t.columnsOrderedByPhysSchema;
        this.indexes.putAll(t.indexes);
    }

    public static IgniteTableImpl copyOf(IgniteTableImpl v) {
        return new IgniteTableImpl(v);
    }

    @Override
    public UUID id() {
        return this.table.tableId();
    }

    @Override
    public int version() {
        return this.ver;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, ImmutableBitSet requiredColumns) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, requiredColumns);
    }

    @Override
    public Statistic getStatistic() {
        return this.statistic;
    }

    @Override
    public TableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public InternalTable table() {
        return this.table;
    }

    @Override
    public IgniteLogicalTableScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, List<RelHint> hints, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)this.distribution()).replace((RelTrait)RewindabilityTrait.REWINDABLE);
        return IgniteLogicalTableScan.create(cluster, traitSet, hints, relOptTbl, proj, cond, requiredColumns);
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTable, String idxName, List<RexNode> proj, RexNode condition, ImmutableBitSet requiredCols) {
        IgniteIndex index = this.getIndex(idxName);
        RelCollation collation = TraitUtils.createCollation(index.columns(), index.collations(), this.descriptor());
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.Impl.NONE).replace((RelTrait)this.distribution()).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)(index.type() == IgniteIndex.Type.HASH ? RelCollations.EMPTY : collation));
        return IgniteLogicalIndexScan.create(cluster, traitSet, relOptTable, idxName, proj, condition, requiredCols);
    }

    @Override
    public IgniteDistribution distribution() {
        return this.desc.distribution();
    }

    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        return this.partitionedGroup();
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public void addIndex(IgniteIndex idxTbl) {
        this.indexes.put(idxTbl.name(), idxTbl);
    }

    @Override
    public IgniteIndex getIndex(String idxName) {
        return this.indexes.get(idxName);
    }

    @Override
    public void removeIndex(String idxName) {
        this.indexes.remove(idxName);
    }

    @Override
    public <C> C unwrap(Class<C> cls) {
        if (cls.isInstance(this.desc)) {
            return cls.cast(this.desc);
        }
        return (C)super.unwrap(cls);
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, BinaryRow binaryRow, RowHandler.RowFactory<RowT> factory, @Nullable BitSet requiredColumns) {
        RowHandler<RowT> handler = factory.handler();
        assert (handler == ectx.rowHandler());
        RowT res = factory.create();
        assert (handler.columnCount(res) == (requiredColumns == null ? this.desc.columnsCount() : requiredColumns.cardinality()));
        Row row = this.schemaRegistry.resolve(binaryRow, this.schemaDescriptor);
        if (requiredColumns == null) {
            for (int i = 0; i < this.desc.columnsCount(); ++i) {
                ColumnDescriptor colDesc = this.desc.columnDescriptor(i);
                handler.set(i, res, TypeUtils.toInternal(ectx, row.value(colDesc.physicalIndex())));
            }
        } else {
            int i = 0;
            int j = requiredColumns.nextSetBit(0);
            while (j != -1) {
                ColumnDescriptor colDesc = this.desc.columnDescriptor(j);
                handler.set(i, res, TypeUtils.toInternal(ectx, row.value(colDesc.physicalIndex())));
                j = requiredColumns.nextSetBit(j + 1);
                ++i;
            }
        }
        return res;
    }

    @Override
    public <RowT> ModifyRow toModifyRow(ExecutionContext<RowT> ectx, RowT row, TableModify.Operation op, List<String> arg) {
        switch (op) {
            case INSERT: {
                return this.insertTuple(row, ectx);
            }
            case DELETE: {
                return this.deleteTuple(row, ectx);
            }
            case UPDATE: {
                return this.updateTuple(row, arg, 0, ectx);
            }
            case MERGE: {
                return this.mergeTuple(row, arg, ectx);
            }
        }
        throw new AssertionError();
    }

    private <RowT> ModifyRow insertTuple(RowT row, ExecutionContext<RowT> ectx) {
        int nonNullVarlenKeyCols = 0;
        int nonNullVarlenValCols = 0;
        RowHandler<RowT> hnd = ectx.rowHandler();
        for (ColumnDescriptor colDesc : this.columnsOrderedByPhysSchema) {
            Object val;
            if (colDesc.physicalType().spec().fixedLength() || (val = hnd.get(colDesc.logicalIndex(), row)) == null) continue;
            if (colDesc.key()) {
                ++nonNullVarlenKeyCols;
                continue;
            }
            ++nonNullVarlenValCols;
        }
        RowAssembler rowAssembler = new RowAssembler(this.schemaDescriptor, nonNullVarlenKeyCols, nonNullVarlenValCols);
        for (ColumnDescriptor colDesc : this.columnsOrderedByPhysSchema) {
            Object val = colDesc.key() && Commons.implicitPkEnabled() && "__p_key".equals(colDesc.name()) ? colDesc.defaultValue() : this.replaceDefault(hnd.get(colDesc.logicalIndex(), row), colDesc);
            val = TypeUtils.fromInternal(ectx, val, NativeTypeSpec.toClass((NativeTypeSpec)colDesc.physicalType().spec(), (boolean)colDesc.nullable()));
            RowAssembler.writeValue((RowAssembler)rowAssembler, (NativeType)colDesc.physicalType(), (Object)val);
        }
        return new ModifyRow((BinaryRowEx)new Row(this.schemaDescriptor, rowAssembler.build()), ModifyRow.Operation.INSERT_ROW);
    }

    private <RowT> ModifyRow mergeTuple(RowT row, List<String> updateColList, ExecutionContext<RowT> ectx) {
        RowHandler<RowT> hnd = ectx.rowHandler();
        int rowColumnsCnt = hnd.columnCount(row);
        if (this.desc.columnsCount() == rowColumnsCnt) {
            return this.insertTuple(row, ectx);
        }
        if (this.desc.columnsCount() + updateColList.size() == rowColumnsCnt) {
            return this.updateTuple(row, updateColList, 0, ectx);
        }
        int off = this.columnsOrderedByPhysSchema.size();
        if (hnd.get(off, row) == null) {
            return this.insertTuple(row, ectx);
        }
        return this.updateTuple(row, updateColList, off, ectx);
    }

    private <RowT> ModifyRow updateTuple(RowT row, List<String> updateColList, int offset, ExecutionContext<RowT> ectx) {
        int valOffset;
        RowHandler<RowT> hnd = ectx.rowHandler();
        Object2IntOpenHashMap columnToIndex = new Object2IntOpenHashMap(updateColList.size());
        for (int i = 0; i < updateColList.size(); ++i) {
            columnToIndex.put((Object)updateColList.get(i), i + this.desc.columnsCount() + offset);
        }
        int nonNullVarlenKeyCols = 0;
        int nonNullVarlenValCols = 0;
        int keyOffset = this.schemaDescriptor.keyColumns().firstVarlengthColumn();
        if (keyOffset > -1) {
            nonNullVarlenKeyCols = this.countNotNullColumns(keyOffset, this.schemaDescriptor.keyColumns().length(), (Object2IntMap<String>)columnToIndex, offset, hnd, row);
        }
        if ((valOffset = this.schemaDescriptor.valueColumns().firstVarlengthColumn()) > -1) {
            nonNullVarlenValCols = this.countNotNullColumns(this.schemaDescriptor.keyColumns().length() + valOffset, this.schemaDescriptor.length(), (Object2IntMap<String>)columnToIndex, offset, hnd, row);
        }
        RowAssembler rowAssembler = new RowAssembler(this.schemaDescriptor, nonNullVarlenKeyCols, nonNullVarlenValCols);
        for (ColumnDescriptor colDesc : this.columnsOrderedByPhysSchema) {
            int colIdx = columnToIndex.getOrDefault((Object)colDesc.name(), colDesc.logicalIndex() + offset);
            Object val = TypeUtils.fromInternal(ectx, hnd.get(colIdx, row), NativeTypeSpec.toClass((NativeTypeSpec)colDesc.physicalType().spec(), (boolean)colDesc.nullable()));
            RowAssembler.writeValue((RowAssembler)rowAssembler, (NativeType)colDesc.physicalType(), (Object)val);
        }
        return new ModifyRow((BinaryRowEx)new Row(this.schemaDescriptor, rowAssembler.build()), ModifyRow.Operation.UPDATE_ROW);
    }

    private <RowT> int countNotNullColumns(int start, int end, Object2IntMap<String> columnToIndex, int offset, RowHandler<RowT> hnd, RowT row) {
        int nonNullCols = 0;
        for (int i = start; i < end; ++i) {
            ColumnDescriptor colDesc = Objects.requireNonNull(this.columnsOrderedByPhysSchema.get(i));
            assert (!colDesc.physicalType().spec().fixedLength());
            int colIdInRow = columnToIndex.getOrDefault((Object)colDesc.name(), colDesc.logicalIndex() + offset);
            if (hnd.get(colIdInRow, row) == null) continue;
            ++nonNullCols;
        }
        return nonNullCols;
    }

    private <RowT> ModifyRow deleteTuple(RowT row, ExecutionContext<RowT> ectx) {
        int nonNullVarlenKeyCols = 0;
        RowHandler<RowT> hnd = ectx.rowHandler();
        for (ColumnDescriptor colDesc : this.columnsOrderedByPhysSchema) {
            Object val;
            if (!colDesc.key()) break;
            if (colDesc.physicalType().spec().fixedLength() || (val = hnd.get(colDesc.logicalIndex(), row)) == null) continue;
            ++nonNullVarlenKeyCols;
        }
        RowAssembler rowAssembler = new RowAssembler(this.schemaDescriptor, nonNullVarlenKeyCols, 0);
        for (ColumnDescriptor colDesc : this.columnsOrderedByPhysSchema) {
            if (!colDesc.key()) break;
            Object val = TypeUtils.fromInternal(ectx, hnd.get(colDesc.logicalIndex(), row), NativeTypeSpec.toClass((NativeTypeSpec)colDesc.physicalType().spec(), (boolean)colDesc.nullable()));
            RowAssembler.writeValue((RowAssembler)rowAssembler, (NativeType)colDesc.physicalType(), (Object)val);
        }
        return new ModifyRow((BinaryRowEx)new Row(this.schemaDescriptor, rowAssembler.build()), ModifyRow.Operation.DELETE_ROW);
    }

    private ColocationGroup partitionedGroup() {
        List<List<String>> assignments = this.table.assignments().stream().map(Collections::singletonList).collect(Collectors.toList());
        return ColocationGroup.forAssignments(assignments);
    }

    private Object replaceDefault(Object val, ColumnDescriptor desc) {
        return val == RexImpTable.DEFAULT_VALUE_PLACEHOLDER ? desc.defaultValue() : val;
    }

    private class StatisticsImpl
    implements Statistic {
        private static final int STATS_CLI_UPDATE_THRESHOLD = 200;
        AtomicInteger statReqCnt = new AtomicInteger();
        private volatile long localRowCnt;

        private StatisticsImpl() {
        }

        public Double getRowCount() {
            if (this.statReqCnt.getAndIncrement() % 200 == 0) {
                int parts = (Integer)IgniteTableImpl.this.table.storage().configuration().partitions().value();
                long size = 0L;
                for (int p = 0; p < parts; ++p) {
                    @Nullable MvPartitionStorage part = IgniteTableImpl.this.table.storage().getMvPartition(p);
                    if (part == null) continue;
                    size += part.rowsCount();
                }
                this.localRowCnt = size;
            }
            return Math.max(10000.0, (double)this.localRowCnt);
        }

        public boolean isKey(ImmutableBitSet cols) {
            return false;
        }

        public List<ImmutableBitSet> getKeys() {
            return null;
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return List.of();
        }

        public List<RelCollation> getCollations() {
            return List.of();
        }

        public IgniteDistribution getDistribution() {
            return IgniteTableImpl.this.distribution();
        }
    }
}

