/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.lang.reflect.Method;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;

public class IgniteMdPercentageOriginalRows
implements MetadataHandler<BuiltInMetadata.PercentageOriginalRows> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.PERCENTAGE_ORIGINAL_ROWS.method, (MetadataHandler)new IgniteMdPercentageOriginalRows());

    public MetadataDef<BuiltInMetadata.PercentageOriginalRows> getDef() {
        return BuiltInMetadata.PercentageOriginalRows.DEF;
    }

    public Double getPercentageOriginalRows(Aggregate rel, RelMetadataQuery mq) {
        return mq.getPercentageOriginalRows(rel.getInput());
    }

    public Double getPercentageOriginalRows(Union rel, RelMetadataQuery mq) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double percentage;
            Double rowCount = mq.getRowCount(input);
            if (rowCount == null || (percentage = mq.getPercentageOriginalRows(input)) == null || percentage == 0.0) continue;
            denominator += rowCount / percentage;
            numerator += rowCount.doubleValue();
        }
        return IgniteMdPercentageOriginalRows.quotientForPercentage(numerator, denominator);
    }

    public Double getPercentageOriginalRows(Join rel, RelMetadataQuery mq) {
        Double left = mq.getPercentageOriginalRows(rel.getLeft());
        if (left == null) {
            return null;
        }
        Double right = mq.getPercentageOriginalRows(rel.getRight());
        if (right == null) {
            return null;
        }
        return left * right;
    }

    public Double getPercentageOriginalRows(RelNode rel, RelMetadataQuery mq) {
        if (rel.getInputs().size() > 1) {
            return null;
        }
        if (rel.getInputs().isEmpty()) {
            return 1.0;
        }
        RelNode child = (RelNode)rel.getInputs().get(0);
        Double childPercentage = mq.getPercentageOriginalRows(child);
        if (childPercentage == null) {
            return null;
        }
        Double relPercentage = IgniteMdPercentageOriginalRows.quotientForPercentage(mq.getRowCount(rel), mq.getRowCount(child));
        if (relPercentage == null) {
            return null;
        }
        double percent = relPercentage * childPercentage;
        if (percent < 0.0 || percent > 1.0) {
            return null;
        }
        return relPercentage * childPercentage;
    }

    private static Double quotientForPercentage(Double numerator, Double denominator) {
        if (numerator == null || denominator == null) {
            return null;
        }
        if (denominator == 0.0) {
            return 1.0;
        }
        return numerator / denominator;
    }
}

