/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverter;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;

public class IgniteMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new IgniteMdCollation(), BuiltInMetadata.Collation.Handler.class);

    private IgniteMdCollation() {
    }

    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public ImmutableList<RelCollation> collations(RelNode rel, RelMetadataQuery mq) {
        return ImmutableList.of();
    }

    public ImmutableList<RelCollation> collations(IgniteRel rel, RelMetadataQuery mq) {
        RelCollation collation = rel.collation();
        if (collation == null || CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)collation);
    }

    public ImmutableList<RelCollation> collations(Window rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.window(mq, rel.getInput(), (List<Window.Group>)rel.groups));
    }

    public ImmutableList<RelCollation> collations(Match rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.match(mq, rel.getInput(), rel.getRowType(), rel.getPattern(), rel.isStrictStart(), rel.isStrictEnd(), (Map<String, RexNode>)rel.getPatternDefinitions(), (Map<String, RexNode>)rel.getMeasures(), rel.getAfter(), (Map<String, ? extends SortedSet<String>>)rel.getSubsets(), rel.isAllRows(), rel.getPartitionKeys(), rel.getOrderKeys(), rel.getInterval()));
    }

    public ImmutableList<RelCollation> collations(Filter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableModify rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableScan scan, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.table(scan.getTable()));
    }

    public ImmutableList<RelCollation> collations(Sort sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)RelMdCollation.sort((RelCollation)sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(SortExchange sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)RelMdCollation.sort((RelCollation)sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Project project, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.project(mq, project.getInput(), project.getProjects()));
    }

    public ImmutableList<RelCollation> collations(Calc calc, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.calc(mq, calc.getInput(), calc.getProgram()));
    }

    public ImmutableList<RelCollation> collations(Values values, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.values(mq, values.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)values.getTuples()));
    }

    public ImmutableList<RelCollation> collations(JdbcToEnumerableConverter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.collations(rel.getCurrentRel());
    }

    public ImmutableList<RelCollation> collations(RelSubset rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)Objects.requireNonNull(rel.getTraitSet().getTraits((RelTraitDef)RelCollationTraitDef.INSTANCE)));
    }

    public static List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static List<RelCollation> snapshot(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> sort(RelCollation collation) {
        return ImmutableList.of((Object)collation);
    }

    public static List<RelCollation> filter(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> limit(RelMetadataQuery mq, RelNode input) {
        return mq.collations(input);
    }

    public static List<RelCollation> calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        List projects = program.getProjectList().stream().map(arg_0 -> ((RexProgram)program).expandLocalRef(arg_0)).collect(Collectors.toList());
        return IgniteMdCollation.project(mq, input, projects);
    }

    public static List<RelCollation> project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = new TreeSet<RelCollation>();
        ImmutableList inputCollations = mq.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return List.of();
        }
        Int2ObjectOpenHashMap targets = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap targetsWithMonotonicity = new Int2ObjectOpenHashMap();
        for (Object project : Ord.zip(projects)) {
            if (((Ord)project).e instanceof RexInputRef) {
                targets.compute(((RexSlot)((Ord)project).e).getIndex(), (arg_0, arg_1) -> IgniteMdCollation.lambda$project$0((Ord)project, arg_0, arg_1));
                continue;
            }
            if (!(((Ord)project).e instanceof RexCall)) continue;
            RexCall call = (RexCall)((Ord)project).e;
            RexCallBinding binding = RexCallBinding.create((RelDataTypeFactory)Commons.typeFactory(input), (RexCall)call, (List)inputCollations);
            targetsWithMonotonicity.put(((Ord)project).i, (Object)call.getOperator().getMonotonicity((SqlOperatorBinding)binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            boolean skip = false;
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                IntList integers = (IntList)targets.getOrDefault(ifc.getFieldIndex(), (Object)IntLists.emptyList());
                if (integers.isEmpty()) {
                    skip = true;
                    break;
                }
                fieldCollations.add(ifc.withFieldIndex(integers.intIterator().nextInt()));
            }
            if (skip) continue;
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> fieldCollationsForRexCalls = new ArrayList<RelFieldCollation>();
        block6: for (Int2ObjectMap.Entry entry : targetsWithMonotonicity.int2ObjectEntrySet()) {
            SqlMonotonicity value = (SqlMonotonicity)entry.getValue();
            switch (value) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            fieldCollationsForRexCalls.add(new RelFieldCollation(entry.getIntKey(), RelFieldCollation.Direction.of((SqlMonotonicity)value)));
        }
        if (!fieldCollationsForRexCalls.isEmpty()) {
            collations.add(RelCollations.of(fieldCollationsForRexCalls));
        }
        return List.copyOf(collations);
    }

    public static List<RelCollation> window(RelMetadataQuery mq, RelNode input, List<Window.Group> groups) {
        return mq.collations(input);
    }

    public static List<RelCollation> match(RelMetadataQuery mq, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        return mq.collations(input);
    }

    public static List<RelCollation> values(RelMetadataQuery mq, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        Util.discard((Object)mq);
        ArrayList<RelCollation> list = new ArrayList<RelCollation>();
        int n = rowType.getFieldCount();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean skip = false;
        for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Comparator<List<RexLiteral>> comparator = IgniteMdCollation.comparator(fieldCollation);
                Comparator<List<Object>> ordering = pairs.isEmpty() ? comparator : Commons.compoundComparator(Arrays.asList((Comparator)((Pair)Util.last(pairs)).right, comparator));
                pairs.add(Pair.of((Object)fieldCollation, ordering));
                if (IgniteMdCollation.isOrdered(tuples, ordering)) continue;
                if (j == i) {
                    skip = true;
                    break;
                }
                pairs.remove(pairs.size() - 1);
            }
            if (skip || pairs.isEmpty()) continue;
            list.add(RelCollations.of((List)Pair.left(pairs)));
        }
        return list;
    }

    private static Comparator<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        int nullComparison = fieldCollation.nullDirection.nullComparison;
        int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return (o1, o2) -> {
                    Comparable c1 = (Comparable)((RexLiteral)o1.get(x)).getValueAs(Comparable.class);
                    Comparable c2 = (Comparable)((RexLiteral)o2.get(x)).getValueAs(Comparable.class);
                    return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
                };
            }
        }
        return (o1, o2) -> {
            Comparable c1 = (Comparable)((RexLiteral)o1.get(x)).getValueAs(Comparable.class);
            Comparable c2 = (Comparable)((RexLiteral)o2.get(x)).getValueAs(Comparable.class);
            return RelFieldCollation.compare((Comparable)c2, (Comparable)c1, (int)nullComparison);
        };
    }

    public static <T> boolean isOrdered(Iterable<? extends T> iterable, Comparator<T> cmp) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (cmp.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @Deprecated
    public static List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        return IgniteMdCollation.mergeJoin(mq, left, right, leftKeys, rightKeys, JoinRelType.INNER);
    }

    public static List<RelCollation> mergeJoin(RelMetadataQuery mq, RelNode left, RelNode right, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType) {
        assert (EnumerableMergeJoin.isMergeJoinSupported((JoinRelType)joinType)) : "EnumerableMergeJoin unsupported for join type " + joinType;
        ImmutableList leftCollations = mq.collations(left);
        assert (RelCollations.contains((List)leftCollations, (ImmutableIntList)leftKeys)) : "cannot merge join: left input is not sorted on left keys";
        if (!joinType.projectsRight()) {
            return leftCollations;
        }
        ArrayList<RelCollation> collations = new ArrayList<RelCollation>();
        collations.addAll((Collection<RelCollation>)leftCollations);
        ImmutableList rightCollations = mq.collations(right);
        assert (RelCollations.contains((List)rightCollations, (ImmutableIntList)rightKeys)) : "cannot merge join: right input is not sorted on right keys";
        int leftFieldCount = left.getRowType().getFieldCount();
        for (RelCollation collation : rightCollations) {
            collations.add(RelCollations.shift((RelCollation)collation, (int)leftFieldCount));
        }
        return List.copyOf(collations);
    }

    public static List<RelCollation> enumerableHashJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        if (joinType == JoinRelType.SEMI) {
            return IgniteMdCollation.enumerableSemiJoin(mq, left, right);
        }
        return IgniteMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static List<RelCollation> enumerableNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return IgniteMdCollation.enumerableJoin0(mq, left, right, joinType);
    }

    public static List<RelCollation> enumerableCorrelate(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    public static List<RelCollation> enumerableSemiJoin(RelMetadataQuery mq, RelNode left, RelNode right) {
        return mq.collations(left);
    }

    public static List<RelCollation> enumerableBatchNestedLoopJoin(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        return mq.collations(left);
    }

    private static List<RelCollation> enumerableJoin0(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType) {
        ImmutableList leftCollations = mq.collations(left);
        switch (joinType) {
            case SEMI: 
            case ANTI: 
            case INNER: 
            case LEFT: {
                return leftCollations;
            }
            case RIGHT: 
            case FULL: {
                for (RelCollation collation : leftCollations) {
                    for (RelFieldCollation field : collation.getFieldCollations()) {
                        if (RelFieldCollation.NullDirection.LAST == field.nullDirection) continue;
                        return List.of();
                    }
                }
                return leftCollations;
            }
        }
        return List.of();
    }

    private static /* synthetic */ IntList lambda$project$0(Ord project, Integer k, IntList v) {
        if (v == null) {
            return IntArrayList.of((int[])new int[]{project.i});
        }
        v.add(project.i);
        return v;
    }
}

