/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network.scalecube;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.network.AbstractTopologyService;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.TopologyEventHandler;

final class ScaleCubeTopologyService
extends AbstractTopologyService {
    private static final IgniteLogger LOG = Loggers.forClass(ScaleCubeTopologyService.class);
    private volatile Cluster cluster;
    private final ConcurrentMap<NetworkAddress, ClusterNode> members = new ConcurrentHashMap<NetworkAddress, ClusterNode>();
    private final ConcurrentMap<String, ClusterNode> consistentIdToMemberMap = new ConcurrentHashMap<String, ClusterNode>();

    ScaleCubeTopologyService() {
    }

    void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    void onMembershipEvent(MembershipEvent event) {
        ClusterNode member = ScaleCubeTopologyService.fromMember(event.member());
        if (event.isAdded()) {
            this.members.put(member.address(), member);
            this.consistentIdToMemberMap.put(member.name(), member);
            LOG.info("Node joined [node={}]", new Object[]{member});
            this.fireAppearedEvent(member);
        } else if (event.isRemoved()) {
            this.members.compute(member.address(), (addr, node) -> {
                if (node == null || node.id().equals(member.id())) {
                    return null;
                }
                return node;
            });
            this.consistentIdToMemberMap.compute(member.name(), (consId, node) -> {
                if (node == null || node.id().equals(member.id())) {
                    return null;
                }
                return node;
            });
            LOG.info("Node left [member={}]", new Object[]{member});
            this.fireDisappearedEvent(member);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Topology snapshot [nodes={}]", new Object[]{this.members.values().stream().map(ClusterNode::name).collect(Collectors.toList())});
        }
    }

    private void fireAppearedEvent(ClusterNode member) {
        for (TopologyEventHandler handler : this.getEventHandlers()) {
            handler.onAppeared(member);
        }
    }

    private void fireDisappearedEvent(ClusterNode member) {
        for (TopologyEventHandler handler : this.getEventHandlers()) {
            handler.onDisappeared(member);
        }
    }

    public ClusterNode localMember() {
        Member localMember = this.cluster.member();
        assert (localMember != null) : "Cluster has not been started";
        return ScaleCubeTopologyService.fromMember(localMember);
    }

    public Collection<ClusterNode> allMembers() {
        return Collections.unmodifiableCollection(this.members.values());
    }

    public ClusterNode getByAddress(NetworkAddress addr) {
        return (ClusterNode)this.members.get(addr);
    }

    public ClusterNode getByConsistentId(String consistentId) {
        return (ClusterNode)this.consistentIdToMemberMap.get(consistentId);
    }

    private static ClusterNode fromMember(Member member) {
        NetworkAddress addr = new NetworkAddress(member.address().host(), member.address().port());
        return new ClusterNode(member.id(), member.alias(), addr);
    }
}

