/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.OutNetworkObject;

public class RecoveryDescriptor {
    private final Queue<OutNetworkObject> unacknowledgedMessages;
    private long sentCount;
    private long acknowledgedCount;
    private long receivedCount;

    public RecoveryDescriptor(int queueLimit) {
        this.unacknowledgedMessages = new ArrayDeque<OutNetworkObject>(queueLimit);
    }

    public long receivedCount() {
        return this.receivedCount;
    }

    public void acknowledge(long messagesReceivedByRemote) {
        while (this.acknowledgedCount < messagesReceivedByRemote) {
            OutNetworkObject req = this.unacknowledgedMessages.poll();
            assert (req != null);
            ++this.acknowledgedCount;
        }
    }

    public int unacknowledgedCount() {
        long res = this.sentCount - this.acknowledgedCount;
        int size = this.unacknowledgedMessages.size();
        assert (res >= 0L);
        assert (res == (long)size);
        return size;
    }

    public List<OutNetworkObject> unacknowledgedMessages() {
        return new ArrayList<OutNetworkObject>(this.unacknowledgedMessages);
    }

    public void add(OutNetworkObject msg) {
        msg.shouldBeSavedForRecovery(false);
        ++this.sentCount;
        this.unacknowledgedMessages.add(msg);
    }

    public long onReceive() {
        ++this.receivedCount;
        return this.receivedCount;
    }

    public String toString() {
        return S.toString(RecoveryDescriptor.class, (Object)this);
    }
}

