/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.message.InvokeResponse;
import org.apache.ignite.internal.network.message.InvokeResponseBuilder;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.NetworkMessage;

public class InvokeResponseImpl
implements InvokeResponse {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final long correlationId;
    @IgniteToStringInclude
    private final NetworkMessage message;

    private InvokeResponseImpl(long correlationId, NetworkMessage message) {
        this.correlationId = correlationId;
        this.message = message;
    }

    @Override
    public long correlationId() {
        return this.correlationId;
    }

    @Override
    public NetworkMessage message() {
        return this.message;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(InvokeResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvokeResponseImpl otherMessage = (InvokeResponseImpl)other;
        return Objects.equals(this.message, otherMessage.message) && this.correlationId == otherMessage.correlationId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.correlationId, this.message);
        return result;
    }

    public static InvokeResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.message != null) {
            this.message.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.message != null) {
            this.message.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements InvokeResponseBuilder {
        private long correlationId;
        private NetworkMessage message;

        private Builder() {
        }

        @Override
        public InvokeResponseBuilder correlationId(long correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        @Override
        public InvokeResponseBuilder message(NetworkMessage message) {
            this.message = message;
            return this;
        }

        @Override
        public long correlationId() {
            return this.correlationId;
        }

        @Override
        public NetworkMessage message() {
            return this.message;
        }

        @Override
        public InvokeResponse build() {
            return new InvokeResponseImpl(this.correlationId, this.message);
        }
    }
}

