/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.storage.DataStorageChange;
import org.apache.ignite.internal.schema.configuration.storage.DataStorageConfiguration;
import org.apache.ignite.internal.schema.configuration.storage.DataStorageView;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class DataStorageManager
implements IgniteComponent {
    private final ConfigurationValue<String> defaultDataStorageConfig;
    private final Map<String, StorageEngine> engines;

    public DataStorageManager(TablesConfiguration tablesConfig, Map<String, StorageEngine> engines) {
        assert (!engines.isEmpty());
        this.engines = engines;
        this.defaultDataStorageConfig = tablesConfig.defaultDataStorage();
    }

    public void start() throws StorageException {
        this.engines.values().forEach(StorageEngine::start);
    }

    public void stop() throws Exception {
        IgniteUtils.closeAll(this.engines.values().stream().map(engine -> engine::stop));
    }

    @Nullable
    public StorageEngine engine(DataStorageConfiguration config) {
        return this.engines.get(((DataStorageView)config.value()).name());
    }

    public Consumer<DataStorageChange> defaultTableDataStorageConsumer(String defaultDataStorageView) {
        return tableDataStorageChange -> {
            if (!defaultDataStorageView.equals("unknown")) {
                assert (this.engines.containsKey(defaultDataStorageView)) : defaultDataStorageView;
                tableDataStorageChange.convert(defaultDataStorageView);
            } else if (this.engines.size() == 1) {
                tableDataStorageChange.convert((String)CollectionUtils.first(this.engines.keySet()));
            }
        };
    }

    public String defaultDataStorage() {
        String defaultDataStorage = (String)this.defaultDataStorageConfig.value();
        return !defaultDataStorage.equals("unknown") || this.engines.size() > 1 ? defaultDataStorage : (String)CollectionUtils.first(this.engines.keySet());
    }

    public Consumer<DataStorageChange> tableDataStorageConsumer(String dataStorage, final Map<String, Object> values) {
        assert (!dataStorage.equals("unknown"));
        ConfigurationSource configurationSource = new ConfigurationSource(){

            public String polymorphicTypeId(String fieldName) {
                throw new UnsupportedOperationException("polymorphicTypeId");
            }

            public void descend(ConstructableTreeNode node) {
                for (final Map.Entry e : values.entrySet()) {
                    assert (e.getKey() != null);
                    assert (e.getValue() != null) : (String)e.getKey();
                    ConfigurationSource leafSource = new ConfigurationSource(){

                        public <T> T unwrap(Class<T> clazz) {
                            return clazz.cast(e.getValue());
                        }

                        public void descend(ConstructableTreeNode node) {
                            throw new UnsupportedOperationException("descend");
                        }

                        public String polymorphicTypeId(String fieldName) {
                            throw new UnsupportedOperationException("polymorphicTypeId");
                        }
                    };
                    node.construct((String)e.getKey(), leafSource, true);
                }
            }
        };
        return tableDataStorageChange -> {
            tableDataStorageChange.convert(dataStorage);
            configurationSource.descend((ConstructableTreeNode)tableDataStorageChange);
        };
    }

    public String toString() {
        return S.toString(DataStorageManager.class, (Object)this);
    }
}

