/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite.internal.replicator.message.ErrorReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkMessage;

public class ReplicaService {
    private static final int RPC_TIMEOUT = 3000;
    private final MessagingService messagingService;
    private final HybridClock clock;

    public ReplicaService(MessagingService messagingService, HybridClock clock) {
        this.messagingService = messagingService;
        this.clock = clock;
    }

    private <R> CompletableFuture<R> sendToReplica(ClusterNode node, ReplicaRequest req) {
        CompletableFuture res = new CompletableFuture();
        this.messagingService.invoke(node.address(), (NetworkMessage)req, 3000L).whenCompleteAsync((response, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof TimeoutException) {
                    res.completeExceptionally((Throwable)((Object)new ReplicationTimeoutException(req.groupId())));
                }
                res.completeExceptionally(ExceptionUtils.withCause(ReplicationException::new, (int)ErrorGroups.Replicator.REPLICA_COMMON_ERR, (String)("Failed to process replica request [replicaGroupId=" + req.groupId() + "]"), (Throwable)throwable));
            } else {
                assert (response instanceof ReplicaResponse) : "Unexpected message response [resp=" + response + "]";
                if (response instanceof TimestampAware) {
                    this.clock.update(((TimestampAware)response).timestamp());
                }
                if (response instanceof ErrorReplicaResponse) {
                    ErrorReplicaResponse errResp = (ErrorReplicaResponse)response;
                    res.completeExceptionally(errResp.throwable());
                } else {
                    res.complete(((ReplicaResponse)response).result());
                }
            }
        });
        return res;
    }

    public <R> CompletableFuture<R> invoke(ClusterNode node, ReplicaRequest request) {
        return this.sendToReplica(node, request);
    }

    public <R> CompletableFuture<R> invoke(ClusterNode node, ReplicaRequest request, String storageId) {
        return this.sendToReplica(node, request);
    }
}

