/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.lang.IgniteStringFormatter;

public class Replica {
    private final ReplicationGroupId replicaGrpId;
    private final ReplicaListener listener;

    public Replica(ReplicationGroupId replicaGrpId, ReplicaListener listener) {
        this.replicaGrpId = replicaGrpId;
        this.listener = listener;
    }

    public CompletableFuture<Object> processRequest(ReplicaRequest request) {
        assert (this.replicaGrpId.equals(request.groupId())) : IgniteStringFormatter.format((String)"Partition mismatch: request does not match the replica [reqReplicaGrpId={}, replicaGrpId={}]", (Object[])new Object[]{request.groupId(), this.replicaGrpId});
        return this.listener.invoke(request);
    }

    public ReplicationGroupId groupId() {
        return this.replicaGrpId;
    }
}

