/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite.internal.storage.rocksdb.index.RocksDbHashIndexStorage;

class HashIndex {
    private final ColumnFamily indexCf;
    private final HashIndexDescriptor descriptor;
    private final ConcurrentMap<Integer, HashIndexStorage> storages = new ConcurrentHashMap<Integer, HashIndexStorage>();

    HashIndex(ColumnFamily indexCf, HashIndexDescriptor descriptor) {
        this.indexCf = indexCf;
        this.descriptor = descriptor;
    }

    HashIndexStorage getOrCreateStorage(RocksDbMvPartitionStorage partitionStorage) {
        return this.storages.computeIfAbsent(partitionStorage.partitionId(), partId -> new RocksDbHashIndexStorage(this.descriptor, this.indexCf, partitionStorage));
    }

    void destroy() {
        this.storages.forEach((partitionId, storage) -> storage.destroy());
    }
}

