/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.reflection.Marshaller;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KvMarshallerImpl<K, V>
implements KvMarshaller<K, V> {
    private final SchemaDescriptor schema;
    private final Marshaller keyMarsh;
    private final Marshaller valMarsh;
    private final Class<K> keyClass;
    private final Class<V> valClass;

    public KvMarshallerImpl(SchemaDescriptor schema, @NotNull Mapper<K> keyMapper, @NotNull Mapper<V> valueMapper) {
        this.schema = schema;
        this.keyClass = keyMapper.targetType();
        this.valClass = valueMapper.targetType();
        this.keyMarsh = Marshaller.createMarshaller(schema.keyColumns().columns(), keyMapper, true);
        this.valMarsh = Marshaller.createMarshaller(schema.valueColumns().columns(), valueMapper, false);
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    @Override
    public Row marshal(@NotNull K key) throws MarshallerException {
        assert (this.keyClass.isInstance(key));
        RowAssembler asm = this.createAssembler(key, null);
        this.keyMarsh.writeObject(key, asm);
        return new Row(this.schema, new ByteBufferRow(asm.toBytes()));
    }

    @Override
    public Row marshal(@NotNull K key, V val) throws MarshallerException {
        assert (this.keyClass.isInstance(key));
        assert (val == null || this.valClass.isInstance(val));
        RowAssembler asm = this.createAssembler(key, val);
        this.keyMarsh.writeObject(key, asm);
        this.valMarsh.writeObject(val, asm);
        return new Row(this.schema, new ByteBufferRow(asm.toBytes()));
    }

    @Override
    @NotNull
    public K unmarshalKey(@NotNull Row row) throws MarshallerException {
        Object o = this.keyMarsh.readObject(row);
        assert (this.keyClass.isInstance(o));
        return (K)o;
    }

    @Override
    @Nullable
    public V unmarshalValue(@NotNull Row row) throws MarshallerException {
        if (!row.hasValue()) {
            return null;
        }
        Object o = this.valMarsh.readObject(row);
        assert (o == null || this.valClass.isInstance(o));
        return (V)o;
    }

    private RowAssembler createAssembler(Object key, Object val) throws MarshallerException {
        ObjectStatistic keyStat = this.collectObjectStats(this.schema.keyColumns(), this.keyMarsh, key);
        ObjectStatistic valStat = this.collectObjectStats(this.schema.valueColumns(), this.valMarsh, val);
        return new RowAssembler(this.schema, keyStat.nonNullColsSize, keyStat.nonNullCols, valStat.nonNullColsSize, valStat.nonNullCols);
    }

    private ObjectStatistic collectObjectStats(Columns cols, Marshaller marsh, Object obj) throws MarshallerException {
        if (obj == null || !cols.hasVarlengthColumns()) {
            return ObjectStatistic.ZERO_VARLEN_STATISTICS;
        }
        int cnt = 0;
        int size = 0;
        for (int i = cols.firstVarlengthColumn(); i < cols.length(); ++i) {
            Object val = marsh.value(obj, i);
            NativeType colType = cols.column(i).type();
            if (val == null || colType.spec().fixedLength()) continue;
            size += MarshallerUtil.getValueSize(val, colType);
            ++cnt;
        }
        return new ObjectStatistic(cnt, size);
    }

    private static class ObjectStatistic {
        static final ObjectStatistic ZERO_VARLEN_STATISTICS = new ObjectStatistic(0, 0);
        int nonNullCols;
        int nonNullColsSize;

        ObjectStatistic(int nonNullCols, int nonNullColsSize) {
            this.nonNullCols = nonNullCols;
            this.nonNullColsSize = nonNullColsSize;
        }
    }
}

