/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesView;
import org.apache.ignite.internal.schema.configuration.index.HashIndexView;
import org.apache.ignite.internal.schema.configuration.index.IndexValidator;
import org.apache.ignite.internal.schema.configuration.index.SortedIndexView;
import org.apache.ignite.internal.schema.configuration.index.TableIndexView;

public class IndexValidatorImpl
implements Validator<IndexValidator, NamedListView<TableIndexView>> {
    public static final IndexValidatorImpl INSTANCE = new IndexValidatorImpl();

    public void validate(IndexValidator annotation, ValidationContext<NamedListView<TableIndexView>> ctx) {
        TablesView tablesConfig = (TablesView)ctx.getNewRoot(TablesConfiguration.KEY);
        assert (tablesConfig != null);
        NamedListView<? extends TableIndexView> indexView = tablesConfig.indexes();
        NamedListView<? extends TableView> tablesView = tablesConfig.tables();
        for (String key : this.newKeys((NamedListView)ctx.getOldValue(), (NamedListView)ctx.getNewValue())) {
            TableIndexView idxView = (TableIndexView)indexView.get(key);
            UUID tableId = idxView.tableId();
            TableView tableView = (TableView)ConfigurationUtil.getByInternalId(tablesView, (UUID)tableId);
            if (tableView == null) {
                ctx.addIssue(new ValidationIssue(key, "Unable to create index [name=" + key + "]. Table not found."));
                continue;
            }
            List<String> colocationColumns = tableView.primaryKey() != null ? List.of(tableView.primaryKey().colocationColumns()) : List.of();
            this.validate(ctx, idxView, tableView.columns().namedListKeys(), colocationColumns);
        }
    }

    private void validate(ValidationContext<?> ctx, TableIndexView indexView, Collection<String> tableColumns, Collection<String> collocationColumns) {
        ArrayList<String> indexedColumns;
        if (indexView instanceof HashIndexView) {
            HashIndexView index0 = (HashIndexView)indexView;
            indexedColumns = new ArrayList<String>(Arrays.asList(index0.columnNames()));
        } else if (indexView instanceof SortedIndexView) {
            SortedIndexView index0 = (SortedIndexView)indexView;
            indexedColumns = new ArrayList(index0.columns().namedListKeys());
        } else {
            ctx.addIssue(new ValidationIssue(indexView.name(), "Index type is not supported [type=" + indexView.type() + "]"));
            return;
        }
        if (indexedColumns.isEmpty()) {
            ctx.addIssue(new ValidationIssue(indexView.name(), "Index must include at least one column"));
            return;
        }
        if (indexView.uniq()) {
            if (collocationColumns.isEmpty()) {
                ctx.addIssue(new ValidationIssue(indexView.name(), "Unique index is not supported for tables without primary key"));
            } else if (!indexedColumns.containsAll(collocationColumns)) {
                ctx.addIssue(new ValidationIssue(indexView.name(), "Unique index must include all colocation columns"));
            }
        }
        indexedColumns.removeAll(tableColumns);
        if (!indexedColumns.isEmpty()) {
            ctx.addIssue(new ValidationIssue(indexView.name(), "Columns don't exist [columns=" + indexedColumns + "]"));
        }
    }

    private List<String> newKeys(NamedListView<?> before, NamedListView<?> after) {
        ArrayList<String> result = new ArrayList<String>(after.namedListKeys());
        if (before != null) {
            result.removeAll(before.namedListKeys());
        }
        return result;
    }

    private IndexValidatorImpl() {
    }
}

