/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.affinity.AffinityUtils;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.client.CompoundCondition;
import org.apache.ignite.internal.metastorage.client.Condition;
import org.apache.ignite.internal.metastorage.client.Conditions;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.internal.metastorage.client.If;
import org.apache.ignite.internal.metastorage.client.Operation;
import org.apache.ignite.internal.metastorage.client.Operations;
import org.apache.ignite.internal.metastorage.client.Update;
import org.apache.ignite.internal.metastorage.client.WatchEvent;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.jetbrains.annotations.NotNull;

public class RebalanceUtil {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceUtil.class);
    private static final int PENDING_KEY_UPDATED = 0;
    private static final int PLANNED_KEY_UPDATED = 1;
    private static final int PLANNED_KEY_REMOVED = 2;
    private static final int OUTDATED_UPDATE_RECEIVED = 3;
    public static final String PENDING_ASSIGNMENTS_PREFIX = "assignments.pending.";
    public static final String STABLE_ASSIGNMENTS_PREFIX = "assignments.stable.";
    public static final String ASSIGNMENTS_SWITCH_REDUCE_PREFIX = "assignments.switch.reduce.";
    public static final String ASSIGNMENTS_SWITCH_APPEND_PREFIX = "assignments.switch.append.";

    @NotNull
    public static CompletableFuture<Void> updatePendingAssignmentsKeys(String tableName, TablePartitionId partId, Collection<ClusterNode> baselineNodes, int replicas, long revision, MetaStorageManager metaStorageMgr, int partNum) {
        ByteArray partChangeTriggerKey = RebalanceUtil.partChangeTriggerKey(partId);
        ByteArray partAssignmentsPendingKey = RebalanceUtil.pendingPartAssignmentsKey(partId);
        ByteArray partAssignmentsPlannedKey = RebalanceUtil.plannedPartAssignmentsKey(partId);
        ByteArray partAssignmentsStableKey = RebalanceUtil.stablePartAssignmentsKey(partId);
        Set partAssignments = AffinityUtils.calculateAssignmentForPartition(baselineNodes, (int)partNum, (int)replicas);
        byte[] partAssignmentsBytes = ByteUtils.toBytes((Object)partAssignments);
        If iif = If.iif((Condition)CompoundCondition.or((Condition)Conditions.notExists((ByteArray)partChangeTriggerKey), (Condition)Conditions.value((ByteArray)partChangeTriggerKey).lt(ByteUtils.longToBytes((long)revision))), (If)If.iif((Condition)CompoundCondition.and((Condition)Conditions.notExists((ByteArray)partAssignmentsPendingKey), (Condition)Conditions.value((ByteArray)partAssignmentsStableKey).ne(partAssignmentsBytes)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)partAssignmentsPendingKey, (byte[])partAssignmentsBytes), Operations.put((ByteArray)partChangeTriggerKey, (byte[])ByteUtils.longToBytes((long)revision))}).yield(0), (If)If.iif((Condition)Conditions.value((ByteArray)partAssignmentsPendingKey).ne(partAssignmentsBytes), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)partAssignmentsPlannedKey, (byte[])partAssignmentsBytes), Operations.put((ByteArray)partChangeTriggerKey, (byte[])ByteUtils.longToBytes((long)revision))}).yield(1), (Update)Operations.ops((Operation[])new Operation[]{Operations.remove((ByteArray)partAssignmentsPlannedKey)}).yield(2))), (Update)Operations.ops((Operation[])new Operation[0]).yield(3));
        return metaStorageMgr.invoke(iif).thenAccept(sr -> {
            switch (sr.getAsInt()) {
                case 0: {
                    LOG.info("Update metastore pending partitions key [key={}, partition={}, table={}, newVal={}]", new Object[]{partAssignmentsPendingKey.toString(), partNum, tableName, ByteUtils.fromBytes((byte[])partAssignmentsBytes)});
                    break;
                }
                case 1: {
                    LOG.info("Update metastore planned partitions key [key={}, partition={}, table={}, newVal={}]", new Object[]{partAssignmentsPlannedKey, partNum, tableName, ByteUtils.fromBytes((byte[])partAssignmentsBytes)});
                    break;
                }
                case 2: {
                    LOG.info("Remove planned key because current pending key has the same value [key={}, partition={}, table={}, val={}]", new Object[]{partAssignmentsPlannedKey.toString(), partNum, tableName, ByteUtils.fromBytes((byte[])partAssignmentsBytes)});
                    break;
                }
                case 3: {
                    LOG.debug("Received outdated rebalance trigger event [revision={}, partition={}, table={}]", new Object[]{revision, partNum, tableName});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                }
            }
        });
    }

    public static ByteArray partChangeTriggerKey(TablePartitionId partId) {
        return new ByteArray(partId + ".change.trigger");
    }

    public static ByteArray pendingPartAssignmentsKey(TablePartitionId partId) {
        return new ByteArray(PENDING_ASSIGNMENTS_PREFIX + partId);
    }

    public static ByteArray plannedPartAssignmentsKey(TablePartitionId partId) {
        return new ByteArray("assignments.planned." + partId);
    }

    public static ByteArray stablePartAssignmentsKey(TablePartitionId partId) {
        return new ByteArray(STABLE_ASSIGNMENTS_PREFIX + partId);
    }

    public static ByteArray switchReduceKey(TablePartitionId partId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_REDUCE_PREFIX + partId);
    }

    public static ByteArray switchAppendKey(TablePartitionId partId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_APPEND_PREFIX + partId);
    }

    public static UUID extractTableId(ByteArray key) {
        return RebalanceUtil.extractTableId(key, "");
    }

    public static UUID extractTableId(ByteArray key, String prefix) {
        String strKey = key.toString();
        return UUID.fromString(strKey.substring(prefix.length(), strKey.indexOf("_part_")));
    }

    public static int extractPartitionNumber(ByteArray key) {
        String strKey = key.toString();
        return Integer.parseInt(strKey.substring(strKey.indexOf("_part_") + "_part_".length()));
    }

    public static boolean recoverable(Throwable t) {
        return true;
    }

    public static CompletableFuture<Void> startPeerRemoval(TablePartitionId partId, ClusterNode clusterNode, MetaStorageManager metaStorageMgr) {
        ByteArray key = RebalanceUtil.switchReduceKey(partId);
        return ((CompletableFuture)metaStorageMgr.get(key).thenCompose(retrievedAssignmentsSwitchReduce -> {
            byte[] prevValue = retrievedAssignmentsSwitchReduce.value();
            if (prevValue != null) {
                Set prev = (Set)ByteUtils.fromBytes((byte[])prevValue);
                prev.add(clusterNode);
                return metaStorageMgr.invoke((Condition)Conditions.revision((ByteArray)key).eq(retrievedAssignmentsSwitchReduce.revision()), Operations.put((ByteArray)key, (byte[])ByteUtils.toBytes((Object)prev)), Operations.noop());
            }
            HashSet<ClusterNode> newValue = new HashSet<ClusterNode>();
            newValue.add(clusterNode);
            return metaStorageMgr.invoke((Condition)Conditions.notExists((ByteArray)key), Operations.put((ByteArray)key, (byte[])ByteUtils.toBytes(newValue)), Operations.noop());
        })).thenCompose(res -> {
            if (!res.booleanValue()) {
                return RebalanceUtil.startPeerRemoval(partId, clusterNode, metaStorageMgr);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public static CompletableFuture<Void> handleReduceChanged(MetaStorageManager metaStorageMgr, Collection<ClusterNode> baselineNodes, int replicas, int partNum, TablePartitionId partId, WatchEvent event) {
        Entry entry = event.entryEvent().newEntry();
        byte[] eventData = entry.value();
        Set assignments = AffinityUtils.calculateAssignmentForPartition(baselineNodes, (int)partNum, (int)replicas);
        Set switchReduce = (Set)ByteUtils.fromBytes((byte[])eventData);
        ByteArray pendingKey = RebalanceUtil.pendingPartAssignmentsKey(partId);
        Set<ClusterNode> pendingAssignments = RebalanceUtil.subtract(assignments, switchReduce);
        byte[] pendingByteArray = ByteUtils.toBytes(pendingAssignments);
        byte[] assignmentsByteArray = ByteUtils.toBytes((Object)assignments);
        if (switchReduce.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ByteArray changeTriggerKey = RebalanceUtil.partChangeTriggerKey(partId);
        byte[] rev = ByteUtils.longToBytes((long)event.entryEvent().newEntry().revision());
        If resultingOperation = If.iif((Condition)CompoundCondition.and((Condition)CompoundCondition.or((Condition)Conditions.notExists((ByteArray)changeTriggerKey), (Condition)Conditions.value((ByteArray)changeTriggerKey).lt(rev)), (Condition)CompoundCondition.and((Condition)Conditions.notExists((ByteArray)pendingKey), (Condition)Conditions.notExists((ByteArray)RebalanceUtil.stablePartAssignmentsKey(partId)))), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingKey, (byte[])pendingByteArray), Operations.put((ByteArray)RebalanceUtil.stablePartAssignmentsKey(partId), (byte[])assignmentsByteArray), Operations.put((ByteArray)changeTriggerKey, (byte[])rev)}).yield(), (If)If.iif((Condition)CompoundCondition.and((Condition)CompoundCondition.or((Condition)Conditions.notExists((ByteArray)changeTriggerKey), (Condition)Conditions.value((ByteArray)changeTriggerKey).lt(rev)), (Condition)Conditions.notExists((ByteArray)pendingKey)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingKey, (byte[])pendingByteArray), Operations.put((ByteArray)changeTriggerKey, (byte[])rev)}).yield(), (Update)Operations.ops((Operation[])new Operation[0]).yield()));
        return metaStorageMgr.invoke(resultingOperation).thenApply(unused -> null);
    }

    public static Set<ClusterNode> resolveClusterNodes(List<PeerId> peers, byte[] pendingAssignments, byte[] stableAssignments) {
        HashMap resolveRegistry = new HashMap();
        if (pendingAssignments != null) {
            Set pending = (Set)ByteUtils.fromBytes((byte[])pendingAssignments);
            pending.forEach(n -> resolveRegistry.put(n.address(), n));
        }
        if (stableAssignments != null) {
            Set stable = (Set)ByteUtils.fromBytes((byte[])stableAssignments);
            stable.forEach(n -> resolveRegistry.put(n.address(), n));
        }
        HashSet<ClusterNode> resolvedNodes = new HashSet<ClusterNode>(peers.size());
        for (PeerId p : peers) {
            NetworkAddress addr = NetworkAddress.from((String)(p.getEndpoint().getIp() + ":" + p.getEndpoint().getPort()));
            if (resolveRegistry.containsKey(addr)) {
                resolvedNodes.add((ClusterNode)resolveRegistry.get(addr));
                continue;
            }
            throw new IgniteInternalException("Can't find appropriate cluster node for raft group peer: " + p);
        }
        return resolvedNodes;
    }

    public static Set<ClusterNode> readClusterNodes(Entry entry) {
        if (entry.empty()) {
            return Collections.emptySet();
        }
        return (Set)ByteUtils.fromBytes((byte[])entry.value());
    }

    public static Set<ClusterNode> subtract(Set<ClusterNode> minuend, Set<ClusterNode> subtrahend) {
        return minuend.stream().filter(v -> !subtrahend.contains(v)).collect(Collectors.toSet());
    }

    public static Set<ClusterNode> union(Set<ClusterNode> op1, Set<ClusterNode> op2) {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>(op1);
        res.addAll(op2);
        return res;
    }

    public static Set<ClusterNode> intersect(Set<ClusterNode> op1, Set<ClusterNode> op2) {
        return op1.stream().filter(op2::contains).collect(Collectors.toSet());
    }
}

