/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite.internal.replicator.exception.UnsupportedReplicaRequestException;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.table.distributed.SortedIndexLocker;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.table.distributed.command.FinishTxCommand;
import org.apache.ignite.internal.table.distributed.command.TxCleanupCommand;
import org.apache.ignite.internal.table.distributed.command.UpdateAllCommand;
import org.apache.ignite.internal.table.distributed.command.UpdateCommand;
import org.apache.ignite.internal.table.distributed.replication.request.ReadOnlyMultiRowReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadOnlyReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadOnlySingleRowReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteMultiRowReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanCloseReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteSingleRowReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteSwapRowReplicaRequest;
import org.apache.ignite.internal.table.distributed.replicator.PlacementDriver;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.replicator.action.RequestType;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxCleanupReplicaRequest;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateReplicaRequest;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionReplicaListener
implements ReplicaListener {
    private static final TxMessagesFactory FACTORY = new TxMessagesFactory();
    private final TablePartitionId replicationGroupId;
    private final int partId;
    public final Lazy<TableSchemaAwareIndexStorage> pkIndexStorage;
    private final Supplier<Map<UUID, TableSchemaAwareIndexStorage>> secondaryIndexStorages;
    private final UUID tableId;
    private final MvPartitionStorage mvDataStorage;
    private final RaftGroupService raftClient;
    private final TxManager txManager;
    private final LockManager lockManager;
    private final ConcurrentNavigableMap<IgniteUuid, Cursor<?>> cursors;
    private final TxStateStorage txStateStorage;
    private final TopologyService topologyService;
    private final HybridClock hybridClock;
    private final PendingComparableValuesTracker<HybridTimestamp> safeTime;
    private final PlacementDriver placementDriver;
    private final Executor scanRequestExecutor;
    private final ConcurrentHashMap<UUID, CompletableFuture<TxMeta>> txTimestampUpdateMap = new ConcurrentHashMap();
    private final Supplier<Map<UUID, IndexLocker>> indexesLockers;
    private final Function<Peer, Boolean> isLocalPeerChecker;

    public PartitionReplicaListener(MvPartitionStorage mvDataStorage, RaftGroupService raftClient, TxManager txManager, LockManager lockManager, Executor scanRequestExecutor, int partId, UUID tableId, Supplier<Map<UUID, IndexLocker>> indexesLockers, Lazy<TableSchemaAwareIndexStorage> pkIndexStorage, Supplier<Map<UUID, TableSchemaAwareIndexStorage>> secondaryIndexStorages, HybridClock hybridClock, PendingComparableValuesTracker<HybridTimestamp> safeTime, TxStateStorage txStateStorage, TopologyService topologyService, PlacementDriver placementDriver, Function<Peer, Boolean> isLocalPeerChecker) {
        this.mvDataStorage = mvDataStorage;
        this.raftClient = raftClient;
        this.txManager = txManager;
        this.lockManager = lockManager;
        this.scanRequestExecutor = scanRequestExecutor;
        this.partId = partId;
        this.tableId = tableId;
        this.indexesLockers = indexesLockers;
        this.pkIndexStorage = pkIndexStorage;
        this.secondaryIndexStorages = secondaryIndexStorages;
        this.hybridClock = hybridClock;
        this.safeTime = safeTime;
        this.txStateStorage = txStateStorage;
        this.topologyService = topologyService;
        this.placementDriver = placementDriver;
        this.isLocalPeerChecker = isLocalPeerChecker;
        this.replicationGroupId = new TablePartitionId(tableId, partId);
        this.cursors = new ConcurrentSkipListMap(IgniteUuid.globalOrderComparator());
    }

    public CompletableFuture<Object> invoke(ReplicaRequest request) {
        if (request instanceof TxStateReplicaRequest) {
            return this.processTxStateReplicaRequest((TxStateReplicaRequest)request);
        }
        return this.ensureReplicaIsPrimary(request).thenCompose(isPrimary -> {
            if (request instanceof ReadWriteSingleRowReplicaRequest) {
                return this.processSingleEntryAction((ReadWriteSingleRowReplicaRequest)request);
            }
            if (request instanceof ReadWriteMultiRowReplicaRequest) {
                return this.processMultiEntryAction((ReadWriteMultiRowReplicaRequest)request);
            }
            if (request instanceof ReadWriteSwapRowReplicaRequest) {
                return this.processTwoEntriesAction((ReadWriteSwapRowReplicaRequest)request).thenApply(Function.identity());
            }
            if (request instanceof ReadWriteScanRetrieveBatchReplicaRequest) {
                return this.processScanRetrieveBatchAction((ReadWriteScanRetrieveBatchReplicaRequest)request).thenApply(Function.identity());
            }
            if (request instanceof ReadWriteScanCloseReplicaRequest) {
                this.processScanCloseAction((ReadWriteScanCloseReplicaRequest)request);
                return CompletableFuture.completedFuture(null);
            }
            if (request instanceof TxFinishReplicaRequest) {
                return this.processTxFinishAction((TxFinishReplicaRequest)request).thenApply(Function.identity());
            }
            if (request instanceof TxCleanupReplicaRequest) {
                return this.processTxCleanupAction((TxCleanupReplicaRequest)request).thenApply(Function.identity());
            }
            if (request instanceof ReadOnlySingleRowReplicaRequest) {
                return this.processReadOnlySingleEntryAction((ReadOnlySingleRowReplicaRequest)request, (Boolean)isPrimary).thenApply(Function.identity());
            }
            if (request instanceof ReadOnlyMultiRowReplicaRequest) {
                return this.processReadOnlyMultiEntryAction((ReadOnlyMultiRowReplicaRequest)request, (Boolean)isPrimary).thenApply(Function.identity());
            }
            if (request instanceof ReadOnlyScanRetrieveBatchReplicaRequest) {
                return this.processReadOnlyScanRetrieveBatchAction((ReadOnlyScanRetrieveBatchReplicaRequest)request, (Boolean)isPrimary).thenApply(Function.identity());
            }
            if (request instanceof ReplicaSafeTimeSyncRequest) {
                return this.processReplicaSafeTimeSyncRequest((ReplicaSafeTimeSyncRequest)request).thenApply(Function.identity());
            }
            throw new UnsupportedReplicaRequestException(request.getClass());
        });
    }

    private CompletableFuture<Object> processTxStateReplicaRequest(TxStateReplicaRequest request) {
        return this.raftClient.refreshAndGetLeaderWithTerm().thenCompose(replicaAndTerm -> {
            NetworkAddress leaderAddress = ((Peer)replicaAndTerm.get1()).address();
            if (this.topologyService.localMember().address().equals((Object)leaderAddress)) {
                CompletableFuture<TxMeta> txStateFut = this.getTxStateConcurrently(request);
                return txStateFut.thenApply(txMeta -> new IgniteBiTuple(txMeta, null));
            }
            return CompletableFuture.completedFuture(new IgniteBiTuple(null, (Object)this.topologyService.getByAddress(leaderAddress)));
        });
    }

    private CompletableFuture<TxMeta> getTxStateConcurrently(TxStateReplicaRequest txStateReq) {
        CompletableFuture<TxMeta> txStateFut = new CompletableFuture<TxMeta>();
        this.txTimestampUpdateMap.compute(txStateReq.txId(), (uuid, fut) -> {
            if (fut != null) {
                fut.thenAccept(txMeta -> txStateFut.complete((TxMeta)txMeta));
            } else {
                TxMeta txMeta2 = this.txStateStorage.get(txStateReq.txId());
                if (txMeta2 == null) {
                    this.hybridClock.update(txStateReq.commitTimestamp());
                }
                txStateFut.complete(txMeta2);
            }
            return null;
        });
        return txStateFut;
    }

    private CompletableFuture<List<BinaryRow>> processReadOnlyScanRetrieveBatchAction(ReadOnlyScanRetrieveBatchReplicaRequest request, Boolean isPrimary) {
        CompletableFuture safeReadFuture;
        Objects.requireNonNull(isPrimary);
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        HybridTimestamp readTimestamp = request.readTimestamp();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        CompletableFuture completableFuture = safeReadFuture = isPrimary != false ? CompletableFuture.completedFuture(null) : this.safeTime.waitFor((Comparable)readTimestamp);
        if (request.indexToUse() != null) {
            TableSchemaAwareIndexStorage indexStorage = this.secondaryIndexStorages.get().get(request.indexToUse());
            if (indexStorage == null) {
                throw new AssertionError((Object)("Index not found: uuid=" + request.indexToUse()));
            }
            if (request.exactKey() != null) {
                assert (request.lowerBound() == null && request.upperBound() == null) : "Index lookup doesn't allow bounds.";
                return safeReadFuture.thenCompose(unused -> this.lookupIndex(request, indexStorage.storage()));
            }
            assert (indexStorage.storage() instanceof SortedIndexStorage);
            return safeReadFuture.thenCompose(unused -> this.scanSortedIndex(request, (SortedIndexStorage)indexStorage.storage()));
        }
        return safeReadFuture.thenCompose(unused -> this.retrieveExactEntriesUntilCursorEmpty(readTimestamp, cursorId, batchCount));
    }

    private CompletableFuture<List<BinaryRow>> retrieveExactEntriesUntilCursorEmpty(HybridTimestamp readTimestamp, IgniteUuid cursorId, int count) {
        PartitionTimestampCursor cursor = (PartitionTimestampCursor)this.cursors.computeIfAbsent(cursorId, id -> this.mvDataStorage.scan(HybridTimestamp.MAX_VALUE));
        ArrayList<CompletableFuture<BinaryRow>> resolutionFuts = new ArrayList<CompletableFuture<BinaryRow>>(count);
        while (resolutionFuts.size() < count && cursor.hasNext()) {
            ReadResult readResult = (ReadResult)cursor.next();
            HybridTimestamp newestCommitTimestamp = readResult.newestCommitTimestamp();
            BinaryRow candidate = newestCommitTimestamp == null || !readResult.isWriteIntent() ? null : cursor.committed(newestCommitTimestamp);
            resolutionFuts.add(this.resolveReadResult(readResult, readTimestamp, () -> candidate));
        }
        return CompletableFuture.allOf(resolutionFuts.toArray(new CompletableFuture[0])).thenCompose(unused -> {
            ArrayList<BinaryRow> rows = new ArrayList<BinaryRow>(count);
            for (CompletableFuture resolutionFut : resolutionFuts) {
                BinaryRow resolvedReadResult = (BinaryRow)resolutionFut.join();
                if (resolvedReadResult == null) continue;
                rows.add(resolvedReadResult);
            }
            if (rows.size() < count && cursor.hasNext()) {
                return this.retrieveExactEntriesUntilCursorEmpty(readTimestamp, cursorId, count - rows.size()).thenApply(binaryRows -> {
                    rows.addAll((Collection<BinaryRow>)binaryRows);
                    return rows;
                });
            }
            return CompletableFuture.completedFuture(rows);
        });
    }

    private CompletableFuture<BinaryRow> processReadOnlySingleEntryAction(ReadOnlySingleRowReplicaRequest request, Boolean isPrimary) {
        BinaryRow searchRow = request.binaryRow();
        HybridTimestamp readTimestamp = request.readTimestamp();
        if (request.requestType() != RequestType.RO_GET) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        CompletableFuture safeReadFuture = isPrimary != false ? CompletableFuture.completedFuture(null) : this.safeTime.waitFor((Comparable)request.readTimestamp());
        return safeReadFuture.thenCompose(unused -> this.resolveRowByPk(searchRow, readTimestamp));
    }

    private CompletableFuture<ArrayList<BinaryRow>> processReadOnlyMultiEntryAction(ReadOnlyMultiRowReplicaRequest request, Boolean isPrimary) {
        Collection<BinaryRow> searchRows = request.binaryRows();
        HybridTimestamp readTimestamp = request.readTimestamp();
        if (request.requestType() != RequestType.RO_GET_ALL) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        CompletableFuture safeReadFuture = isPrimary != false ? CompletableFuture.completedFuture(null) : this.safeTime.waitFor((Comparable)request.readTimestamp());
        return safeReadFuture.thenCompose(unused -> {
            ArrayList<CompletableFuture<BinaryRow>> resolutionFuts = new ArrayList<CompletableFuture<BinaryRow>>(searchRows.size());
            for (BinaryRow searchRow : searchRows) {
                CompletableFuture<BinaryRow> fut = this.resolveRowByPk(searchRow, readTimestamp);
                resolutionFuts.add(fut);
            }
            return CompletableFuture.allOf(resolutionFuts.toArray(new CompletableFuture[0])).thenApply(unused1 -> {
                ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(resolutionFuts.size());
                for (CompletableFuture resolutionFut : resolutionFuts) {
                    BinaryRow resolvedReadResult = (BinaryRow)resolutionFut.join();
                    if (resolvedReadResult == null) continue;
                    result.add(resolvedReadResult);
                }
                return result;
            });
        });
    }

    private CompletionStage<Void> processReplicaSafeTimeSyncRequest(ReplicaSafeTimeSyncRequest request) {
        return this.raftClient.run((Command)new SafeTimeSyncCommand());
    }

    private void closeAllTransactionCursors(UUID txId) {
        IgniteUuid lowCursorId = new IgniteUuid(txId, Long.MIN_VALUE);
        IgniteUuid upperCursorId = new IgniteUuid(txId, Long.MAX_VALUE);
        NavigableMap txCursors = this.cursors.subMap((Object)lowCursorId, true, (Object)upperCursorId, true);
        ReplicationException ex = null;
        for (AutoCloseable cursor : txCursors.values()) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new ReplicationException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Close cursor exception [replicaGrpId={}, msg={}]", (Object[])new Object[]{this.replicationGroupId, e.getMessage()}), (Throwable)e);
                    continue;
                }
                ex.addSuppressed((Throwable)e);
            }
        }
        txCursors.clear();
        if (ex != null) {
            throw ex;
        }
    }

    private void processScanCloseAction(ReadWriteScanCloseReplicaRequest request) {
        UUID txId = request.transactionId();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        Cursor cursor = (Cursor)this.cursors.remove(cursorId);
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                throw new ReplicationException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Close cursor exception [replicaGrpId={}, msg={}]", (Object[])new Object[]{this.replicationGroupId, e.getMessage()}), (Throwable)e);
            }
        }
    }

    private CompletableFuture<List<BinaryRow>> processScanRetrieveBatchAction(ReadWriteScanRetrieveBatchReplicaRequest request) {
        if (request.indexToUse() != null) {
            TableSchemaAwareIndexStorage indexStorage = this.secondaryIndexStorages.get().get(request.indexToUse());
            if (indexStorage == null) {
                throw new AssertionError((Object)("Index not found: uuid=" + request.indexToUse()));
            }
            if (request.exactKey() != null) {
                assert (request.lowerBound() == null && request.upperBound() == null) : "Index lookup doesn't allow bounds.";
                return this.lookupIndex(request, indexStorage.storage());
            }
            assert (indexStorage.storage() instanceof SortedIndexStorage);
            return this.scanSortedIndex(request, (SortedIndexStorage)indexStorage.storage());
        }
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        return this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.S).thenCompose(tblLock -> {
            ArrayList<BinaryRow> batchRows = new ArrayList<BinaryRow>(batchCount);
            PartitionTimestampCursor cursor = (PartitionTimestampCursor)this.cursors.computeIfAbsent(cursorId, id -> this.mvDataStorage.scan(HybridTimestamp.MAX_VALUE));
            while (batchRows.size() < batchCount && cursor.hasNext()) {
                BinaryRow resolvedReadResult = this.resolveReadResult((ReadResult)cursor.next(), txId);
                if (resolvedReadResult == null || !resolvedReadResult.hasValue()) continue;
                batchRows.add(resolvedReadResult);
            }
            return CompletableFuture.completedFuture(batchRows);
        });
    }

    private CompletableFuture<List<BinaryRow>> lookupIndex(ReadOnlyScanRetrieveBatchReplicaRequest request, IndexStorage indexStorage) {
        int batchCount = request.batchSize();
        HybridTimestamp timestamp = request.readTimestamp();
        IgniteUuid cursorId = new IgniteUuid(request.transactionId(), request.scanId());
        BinaryTuple key = request.exactKey();
        Cursor cursor = this.cursors.computeIfAbsent(cursorId, id -> indexStorage.get(key));
        ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
        return this.continueReadOnlyIndexLookup((Cursor<RowId>)cursor, timestamp, batchCount, result).thenCompose(ignore -> CompletableFuture.completedFuture(result));
    }

    private CompletableFuture<List<BinaryRow>> lookupIndex(ReadWriteScanRetrieveBatchReplicaRequest request, IndexStorage indexStorage) {
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        UUID indexId = request.indexToUse();
        BinaryTuple exactKey = request.exactKey();
        return this.lockManager.acquire(txId, new LockKey((Object)indexId), LockMode.IS).thenCompose(idxLock -> this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IS).thenCompose(tblLock -> this.lockManager.acquire(txId, new LockKey(indexId, (Object)exactKey.byteBuffer()), LockMode.S).thenCompose(indRowLock -> {
            Cursor cursor = this.cursors.computeIfAbsent(cursorId, id -> indexStorage.get(exactKey));
            ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
            return this.continueIndexLookup(txId, indexId, (Cursor<RowId>)cursor, batchCount, result).thenApply(ignore -> result);
        })));
    }

    private CompletableFuture<List<BinaryRow>> scanSortedIndex(ReadWriteScanRetrieveBatchReplicaRequest request, SortedIndexStorage indexStorage) {
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        UUID indexId = request.indexToUse();
        BinaryTuplePrefix lowerBound = request.lowerBound();
        BinaryTuplePrefix upperBound = request.upperBound();
        int flags = request.flags();
        return this.lockManager.acquire(txId, new LockKey((Object)indexId), LockMode.IS).thenCompose(idxLock -> this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IS).thenCompose(tblLock -> {
            Cursor cursor = this.cursors.computeIfAbsent(cursorId, id -> indexStorage.scan(lowerBound, upperBound, flags));
            SortedIndexLocker indexLocker = (SortedIndexLocker)this.indexesLockers.get().get(indexId);
            ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
            return this.continueIndexScan(txId, indexId, indexLocker, (Cursor<IndexRow>)cursor, batchCount, result).thenApply(ignore -> result);
        }));
    }

    private CompletableFuture<List<BinaryRow>> scanSortedIndex(ReadOnlyScanRetrieveBatchReplicaRequest request, SortedIndexStorage indexStorage) {
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        HybridTimestamp timestamp = request.readTimestamp();
        IgniteUuid cursorId = new IgniteUuid(txId, request.scanId());
        BinaryTuplePrefix lowerBound = request.lowerBound();
        BinaryTuplePrefix upperBound = request.upperBound();
        int flags = request.flags();
        Cursor cursor = this.cursors.computeIfAbsent(cursorId, id -> indexStorage.scan(lowerBound, upperBound, flags));
        ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
        return this.continueReadOnlyIndexScan((Cursor<IndexRow>)cursor, timestamp, batchCount, result).thenCompose(ignore -> CompletableFuture.completedFuture(result));
    }

    CompletableFuture<Void> continueReadOnlyIndexScan(Cursor<IndexRow> cursor, HybridTimestamp timestamp, int batchSize, List<BinaryRow> result) {
        if (result.size() >= batchSize || !cursor.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        IndexRow indexRow = (IndexRow)cursor.next();
        RowId rowId = indexRow.rowId();
        ReadResult readResult = this.mvDataStorage.read(rowId, timestamp);
        return this.resolveReadResult(readResult, timestamp, () -> {
            if (readResult.newestCommitTimestamp() == null) {
                return null;
            }
            ReadResult committedReadResult = this.mvDataStorage.read(rowId, readResult.newestCommitTimestamp());
            assert (!committedReadResult.isWriteIntent()) : "The result is not committed [rowId=" + rowId + ", timestamp=" + readResult.newestCommitTimestamp() + "]";
            return committedReadResult.binaryRow();
        }).thenCompose(resolvedReadResult -> {
            if (resolvedReadResult != null) {
                result.add((BinaryRow)resolvedReadResult);
            }
            return CompletableFuture.supplyAsync(() -> this.continueReadOnlyIndexScan(cursor, timestamp, batchSize, result)).thenCompose(Function.identity());
        });
    }

    CompletableFuture<Void> continueIndexScan(UUID txId, UUID indexId, SortedIndexLocker indexLocker, Cursor<IndexRow> indexCursor, int batchSize, List<BinaryRow> result) {
        if (result.size() == batchSize) {
            return CompletableFuture.completedFuture(null);
        }
        return indexLocker.locksForScan(txId, indexCursor).thenCompose(currentRow -> {
            if (currentRow == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)currentRow.rowId()), LockMode.S).thenCompose(rowLock -> {
                ReadResult readResult = this.mvDataStorage.read(currentRow.rowId(), HybridTimestamp.MAX_VALUE);
                BinaryRow resolvedReadResult = this.resolveReadResult(readResult, txId);
                if (resolvedReadResult != null) {
                    result.add(resolvedReadResult);
                }
                return CompletableFuture.supplyAsync(() -> this.continueIndexScan(txId, indexId, indexLocker, indexCursor, batchSize, result), this.scanRequestExecutor).thenCompose(Function.identity());
            });
        });
    }

    CompletableFuture<Void> continueIndexLookup(UUID txId, UUID indexId, Cursor<RowId> indexCursor, int batchSize, List<BinaryRow> result) {
        if (result.size() >= batchSize || !indexCursor.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        RowId rowId = (RowId)indexCursor.next();
        return this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.S).thenCompose(rowLock -> {
            ReadResult readResult = this.mvDataStorage.read(rowId, HybridTimestamp.MAX_VALUE);
            BinaryRow resolvedReadResult = this.resolveReadResult(readResult, txId);
            if (resolvedReadResult != null) {
                result.add(resolvedReadResult);
            }
            return CompletableFuture.supplyAsync(() -> this.continueIndexLookup(txId, indexId, indexCursor, batchSize, result), this.scanRequestExecutor).thenCompose(Function.identity());
        });
    }

    CompletableFuture<Void> continueReadOnlyIndexLookup(Cursor<RowId> indexCursor, HybridTimestamp timestamp, int batchSize, List<BinaryRow> result) {
        if (result.size() >= batchSize || !indexCursor.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        RowId rowId = (RowId)indexCursor.next();
        ReadResult readResult = this.mvDataStorage.read(rowId, timestamp);
        return this.resolveReadResult(readResult, timestamp, () -> {
            if (readResult.newestCommitTimestamp() == null) {
                return null;
            }
            ReadResult committedReadResult = this.mvDataStorage.read(rowId, readResult.newestCommitTimestamp());
            assert (!committedReadResult.isWriteIntent()) : "The result is not committed [rowId=" + rowId + ", timestamp=" + readResult.newestCommitTimestamp() + "]";
            return committedReadResult.binaryRow();
        }).thenCompose(resolvedReadResult -> {
            if (resolvedReadResult != null) {
                result.add((BinaryRow)resolvedReadResult);
            }
            return CompletableFuture.supplyAsync(() -> this.continueReadOnlyIndexLookup(indexCursor, timestamp, batchSize, result)).thenCompose(Function.identity());
        });
    }

    private CompletableFuture<Void> processTxFinishAction(TxFinishReplicaRequest request) {
        List<ReplicationGroupId> aggregatedGroupIds = request.groups().values().stream().flatMap(Collection::stream).map(IgniteBiTuple::get1).collect(Collectors.toList());
        UUID txId = request.txId();
        boolean commit = request.commit();
        CompletableFuture<Object> changeStateFuture = this.finishTransaction(aggregatedGroupIds, txId, commit);
        CompletableFuture[] cleanupFutures = new CompletableFuture[request.groups().size()];
        AtomicInteger cleanupFuturesCnt = new AtomicInteger(0);
        request.groups().forEach((recipientNode, replicationGroupIds) -> {
            cleanupFutures[cleanupFuturesCnt.getAndIncrement()] = changeStateFuture.thenCompose(ignored -> this.txManager.cleanup(recipientNode, replicationGroupIds, txId, commit, request.commitTimestamp()));
        });
        return CompletableFuture.allOf(cleanupFutures);
    }

    private CompletableFuture<Object> finishTransaction(List<ReplicationGroupId> aggregatedGroupIds, UUID txId, boolean commit) {
        CompletableFuture fut = new CompletableFuture();
        this.txTimestampUpdateMap.put(txId, fut);
        HybridTimestamp commitTimestamp = this.hybridClock.now();
        CompletionStage changeStateFuture = this.raftClient.run((Command)new FinishTxCommand(txId, commit, commitTimestamp, aggregatedGroupIds)).whenComplete((o, throwable) -> {
            fut.complete(new TxMeta(commit ? TxState.COMMITED : TxState.ABORTED, aggregatedGroupIds, commitTimestamp));
            this.txTimestampUpdateMap.remove(txId);
        });
        return changeStateFuture;
    }

    private CompletableFuture<Void> processTxCleanupAction(TxCleanupReplicaRequest request) {
        try {
            this.closeAllTransactionCursors(request.txId());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return this.raftClient.run((Command)new TxCleanupCommand(request.txId(), request.commit(), request.commitTimestamp())).thenRun(() -> this.lockManager.locks(request.txId()).forEachRemaining(arg_0 -> ((LockManager)this.lockManager).release(arg_0)));
    }

    private <T> CompletableFuture<T> resolveRowByPk(BinaryRow tableRow, UUID txId, BiFunction<@Nullable RowId, @Nullable BinaryRow, CompletableFuture<T>> action) {
        IndexLocker pkLocker = this.indexesLockers.get().get(((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).id());
        assert (pkLocker != null);
        return pkLocker.locksForLookup(txId, tableRow).thenCompose(ignored -> {
            try (Cursor<RowId> cursor = ((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).get(tableRow);){
                for (RowId rowId : cursor) {
                    BinaryRow row = this.resolveReadResult(this.mvDataStorage.read(rowId, HybridTimestamp.MAX_VALUE), txId);
                    if (row == null || !row.hasValue()) continue;
                    CompletionStage completionStage = (CompletionStage)action.apply(rowId, row);
                    return completionStage;
                }
                CompletionStage completionStage = (CompletionStage)action.apply(null, null);
                return completionStage;
            }
            catch (Exception e) {
                throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unable to close cursor [tableId={}]", (Object[])new Object[]{this.tableId}), (Throwable)e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletableFuture<BinaryRow> resolveRowByPk(BinaryRow searchKey, HybridTimestamp ts) {
        try (Cursor<RowId> cursor = ((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).get(searchKey);){
            Object object = cursor.iterator();
            if (object.hasNext()) {
                RowId rowId = (RowId)object.next();
                ReadResult readResult = this.mvDataStorage.read(rowId, ts);
                CompletableFuture<BinaryRow> completableFuture = this.resolveReadResult(readResult, ts, () -> {
                    HybridTimestamp newestCommitTimestamp = readResult.newestCommitTimestamp();
                    if (newestCommitTimestamp == null) {
                        return null;
                    }
                    ReadResult committedReadResult = this.mvDataStorage.read(rowId, newestCommitTimestamp);
                    assert (!committedReadResult.isWriteIntent()) : "The result is not committed [rowId=" + rowId + ", timestamp=" + newestCommitTimestamp + "]";
                    return committedReadResult.binaryRow();
                });
                return completableFuture;
            }
            object = CompletableFuture.completedFuture(null);
            return object;
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unable to close cursor [tableId={}]", (Object[])new Object[]{this.tableId}), (Throwable)e);
        }
    }

    private boolean equalValues(@NotNull BinaryRow row, @NotNull BinaryRow row2) {
        if (row.hasValue() ^ row2.hasValue()) {
            return false;
        }
        return row.valueSlice().compareTo(row2.valueSlice()) == 0;
    }

    private CompletableFuture<Object> processMultiEntryAction(ReadWriteMultiRowReplicaRequest request) {
        UUID txId = request.transactionId();
        TablePartitionId committedPartitionId = request.commitPartitionId();
        assert (committedPartitionId != null || request.requestType() == RequestType.RW_GET_ALL) : "Commit partition partition is null [type=" + request.requestType() + "]";
        switch (request.requestType()) {
            case RW_GET_ALL: {
                CompletableFuture[] rowFuts = new CompletableFuture[request.binaryRows().size()];
                int i = 0;
                for (BinaryRow searchRow : request.binaryRows()) {
                    rowFuts[i++] = this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                        if (rowId == null) {
                            return CompletableFuture.completedFuture(null);
                        }
                        return this.takeLocksForGet((RowId)rowId, txId).thenApply(ignored -> row);
                    });
                }
                return CompletableFuture.allOf(rowFuts).thenCompose(ignored -> {
                    ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(request.binaryRows().size());
                    for (int idx = 0; idx < request.binaryRows().size(); ++idx) {
                        result.add((BinaryRow)rowFuts[idx].join());
                    }
                    return CompletableFuture.completedFuture(result);
                });
            }
            case RW_DELETE_ALL: {
                CompletableFuture[] rowIdLockFuts = new CompletableFuture[request.binaryRows().size()];
                int i = 0;
                for (BinaryRow searchRow : request.binaryRows()) {
                    rowIdLockFuts[i++] = this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                        if (rowId == null) {
                            return CompletableFuture.completedFuture(null);
                        }
                        return this.takeLocksForDelete(searchRow, (RowId)rowId, txId);
                    });
                }
                return CompletableFuture.allOf(rowIdLockFuts).thenCompose(ignore -> {
                    ArrayList<RowId> rowIdsToDelete = new ArrayList<RowId>();
                    ArrayList<BinaryRow> result = new ArrayList<BinaryRow>();
                    int futNum = 0;
                    for (BinaryRow row : request.binaryRows()) {
                        RowId lockedRowId;
                        if ((lockedRowId = (RowId)rowIdLockFuts[futNum++].join()) != null) {
                            rowIdsToDelete.add(lockedRowId);
                            continue;
                        }
                        result.add(row);
                    }
                    if (rowIdsToDelete.isEmpty()) {
                        return CompletableFuture.completedFuture(result);
                    }
                    return this.applyCmdWithExceptionHandling((Command)new UpdateAllCommand(committedPartitionId, rowIdsToDelete, txId)).thenApply(ignored -> result);
                });
            }
            case RW_DELETE_EXACT_ALL: {
                CompletableFuture[] deleteExactLockFuts = new CompletableFuture[request.binaryRows().size()];
                int i = 0;
                for (BinaryRow searchRow : request.binaryRows()) {
                    deleteExactLockFuts[i++] = this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                        if (rowId == null) {
                            return CompletableFuture.completedFuture(null);
                        }
                        return this.takeLocksForDeleteExact(searchRow, (RowId)rowId, (BinaryRow)row, txId);
                    });
                }
                return CompletableFuture.allOf(deleteExactLockFuts).thenCompose(ignore -> {
                    ArrayList<RowId> rowIdsToDelete = new ArrayList<RowId>();
                    ArrayList<BinaryRow> result = new ArrayList<BinaryRow>();
                    int futNum = 0;
                    for (BinaryRow row : request.binaryRows()) {
                        RowId lockedRowId;
                        if ((lockedRowId = (RowId)deleteExactLockFuts[futNum++].join()) != null) {
                            rowIdsToDelete.add(lockedRowId);
                            continue;
                        }
                        result.add(row);
                    }
                    CompletableFuture<Object> raftFut = rowIdsToDelete.isEmpty() ? CompletableFuture.completedFuture(null) : this.applyCmdWithExceptionHandling((Command)new UpdateAllCommand(committedPartitionId, rowIdsToDelete, txId));
                    return raftFut.thenApply(ignored -> result);
                });
            }
            case RW_INSERT_ALL: {
                CompletableFuture[] pkReadLockFuts = new CompletableFuture[request.binaryRows().size()];
                int i = 0;
                for (BinaryRow searchRow : request.binaryRows()) {
                    pkReadLockFuts[i++] = this.resolveRowByPk(searchRow, txId, (rowId, row) -> CompletableFuture.completedFuture(rowId));
                }
                return CompletableFuture.allOf(pkReadLockFuts).thenCompose(ignore -> {
                    ArrayList<BinaryRow> result = new ArrayList<BinaryRow>();
                    HashMap<RowId, BinaryRow> rowsToInsert = new HashMap<RowId, BinaryRow>();
                    int futNum = 0;
                    for (BinaryRow row : request.binaryRows()) {
                        RowId lockedRow;
                        if ((lockedRow = (RowId)pkReadLockFuts[futNum++].join()) != null) {
                            result.add(row);
                            continue;
                        }
                        if (rowsToInsert.values().stream().noneMatch(row0 -> row0.keySlice().equals(row.keySlice()))) {
                            rowsToInsert.put(new RowId(this.partId), row);
                            continue;
                        }
                        result.add(row);
                    }
                    if (rowsToInsert.isEmpty()) {
                        return CompletableFuture.completedFuture(result);
                    }
                    CompletableFuture[] insertLockFuts = new CompletableFuture[rowsToInsert.size()];
                    int idx = 0;
                    for (Map.Entry entry : rowsToInsert.entrySet()) {
                        insertLockFuts[idx++] = this.takeLocksForInsert((BinaryRow)entry.getValue(), (RowId)entry.getKey(), txId);
                    }
                    return ((CompletableFuture)CompletableFuture.allOf(insertLockFuts).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateAllCommand(committedPartitionId, rowsToInsert, txId)))).thenApply(ignored -> result);
                });
            }
            case RW_UPSERT_ALL: {
                CompletableFuture[] rowIdFuts = new CompletableFuture[request.binaryRows().size()];
                int i = 0;
                for (BinaryRow searchRow : request.binaryRows()) {
                    rowIdFuts[i++] = this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                        boolean insert = rowId == null;
                        RowId rowId0 = insert ? new RowId(this.partId) : rowId;
                        return insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    });
                }
                return CompletableFuture.allOf(rowIdFuts).thenCompose(ignore -> {
                    HashMap<RowId, BinaryRow> rowsToUpdate = new HashMap<RowId, BinaryRow>();
                    int futNum = 0;
                    for (BinaryRow row : request.binaryRows()) {
                        RowId lockedRow = (RowId)rowIdFuts[futNum++].join();
                        rowsToUpdate.put(lockedRow, row);
                    }
                    if (rowsToUpdate.isEmpty()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.applyCmdWithExceptionHandling((Command)new UpdateAllCommand(committedPartitionId, rowsToUpdate, txId)).thenApply(ignored -> null);
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown multi request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<Object> applyCmdWithExceptionHandling(Command cmd) {
        return this.raftClient.run(cmd).exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                throw new ReplicationTimeoutException((ReplicationGroupId)this.replicationGroupId);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ReplicationException((ReplicationGroupId)this.replicationGroupId, throwable);
        });
    }

    private CompletableFuture<Object> processSingleEntryAction(ReadWriteSingleRowReplicaRequest request) {
        UUID txId = request.transactionId();
        BinaryRow searchRow = request.binaryRow();
        TablePartitionId commitPartitionId = request.commitPartitionId();
        assert (commitPartitionId != null || request.requestType() == RequestType.RW_GET) : "Commit partition is null [type=" + request.requestType() + "]";
        switch (request.requestType()) {
            case RW_GET: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.takeLocksForGet((RowId)rowId, txId).thenApply(ignored -> row);
                });
            }
            case RW_DELETE: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return ((CompletableFuture)this.takeLocksForDelete(searchRow, (RowId)rowId, txId).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)rowId, txId)))).thenApply(ignored -> true);
                });
            }
            case RW_GET_AND_DELETE: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return ((CompletableFuture)this.takeLocksForDelete(searchRow, (RowId)rowId, txId).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)rowId, txId)))).thenApply(ignored -> row);
                });
            }
            case RW_DELETE_EXACT: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.takeLocksForDeleteExact(searchRow, (RowId)rowId, (BinaryRow)row, txId).thenCompose(validatedRowId -> {
                        if (validatedRowId == null) {
                            return CompletableFuture.completedFuture(false);
                        }
                        return this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)validatedRowId, txId)).thenApply(ignored -> true);
                    });
                });
            }
            case RW_INSERT: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId != null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    RowId rowId0 = new RowId(this.partId);
                    return ((CompletableFuture)this.takeLocksForInsert(searchRow, rowId0, txId).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, rowId0, searchRow, txId)))).thenApply(ignored -> true);
                });
            }
            case RW_UPSERT: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    boolean insert = rowId == null;
                    RowId rowId0 = insert ? new RowId(this.partId) : rowId;
                    CompletableFuture<RowId> lockFut = insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    return ((CompletableFuture)lockFut.thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, rowId0, searchRow, txId)))).thenApply(ignored -> null);
                });
            }
            case RW_GET_AND_UPSERT: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    boolean insert = rowId == null;
                    RowId rowId0 = insert ? new RowId(this.partId) : rowId;
                    CompletableFuture<RowId> lockFut = insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    return ((CompletableFuture)lockFut.thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, rowId0, searchRow, txId)))).thenApply(ignored -> row);
                });
            }
            case RW_GET_AND_REPLACE: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return ((CompletableFuture)this.takeLocksForUpdate(searchRow, (RowId)rowId, txId).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)rowId, searchRow, txId)))).thenApply(ignored0 -> row);
                });
            }
            case RW_REPLACE_IF_EXIST: {
                return this.resolveRowByPk(searchRow, txId, (rowId, row) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return ((CompletableFuture)this.takeLocksForUpdate(searchRow, (RowId)rowId, txId).thenCompose(ignored -> this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)rowId, searchRow, txId)))).thenApply(ignored -> true);
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<RowId> takeLocksForUpdate(BinaryRow tableRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.X))).thenCompose(ignored -> this.takePutLockOnIndexes(tableRow, rowId, txId))).thenApply(ignored -> rowId);
    }

    private CompletableFuture<RowId> takeLocksForInsert(BinaryRow tableRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IX).thenCompose(ignored -> this.takePutLockOnIndexes(tableRow, rowId, txId))).thenApply(tblLock -> rowId);
    }

    private CompletableFuture<?> takePutLockOnIndexes(BinaryRow tableRow, RowId rowId, UUID txId) {
        Collection<IndexLocker> indexes = this.indexesLockers.get().values();
        if (CollectionUtils.nullOrEmpty(indexes)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] locks = new CompletableFuture[indexes.size()];
        int idx = 0;
        for (IndexLocker locker : indexes) {
            locks[idx++] = locker.locksForInsert(txId, tableRow, rowId);
        }
        return CompletableFuture.allOf(locks);
    }

    private CompletableFuture<?> takeRemoveLockOnIndexes(BinaryRow tableRow, RowId rowId, UUID txId) {
        Collection<IndexLocker> indexes = this.indexesLockers.get().values();
        if (CollectionUtils.nullOrEmpty(indexes)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] locks = new CompletableFuture[indexes.size()];
        int idx = 0;
        for (IndexLocker locker : indexes) {
            locks[idx++] = locker.locksForRemove(txId, tableRow, rowId);
        }
        return CompletableFuture.allOf(locks);
    }

    private CompletableFuture<RowId> takeLocksForDeleteExact(BinaryRow expectedRow, RowId rowId, BinaryRow actualRow, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.S))).thenCompose(ignored -> {
            if (this.equalValues(actualRow, expectedRow)) {
                return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.X).thenCompose(ignored0 -> this.takeRemoveLockOnIndexes(actualRow, rowId, txId))).thenApply(exclusiveRowLock -> rowId);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<RowId> takeLocksForDelete(BinaryRow tableRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.X))).thenCompose(ignored -> this.takeRemoveLockOnIndexes(tableRow, rowId, txId))).thenApply(ignored -> rowId);
    }

    private CompletableFuture<RowId> takeLocksForGet(RowId rowId, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IS).thenCompose(tblLock -> this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.S))).thenApply(ignored -> rowId);
    }

    private CompletableFuture<Boolean> processTwoEntriesAction(ReadWriteSwapRowReplicaRequest request) {
        BinaryRow newRow = request.binaryRow();
        BinaryRow expectedRow = request.oldBinaryRow();
        TablePartitionId commitPartitionId = request.commitPartitionId();
        assert (commitPartitionId != null) : "Commit partition partition is null [type=" + request.requestType() + "]";
        UUID txId = request.transactionId();
        if (request.requestType() == RequestType.RW_REPLACE) {
            return this.resolveRowByPk(newRow, txId, (rowId, row) -> {
                if (rowId == null) {
                    return CompletableFuture.completedFuture(false);
                }
                return this.takeLocksForReplace(expectedRow, (BinaryRow)row, newRow, (RowId)rowId, txId).thenCompose(validatedRowId -> {
                    if (validatedRowId == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.applyCmdWithExceptionHandling((Command)new UpdateCommand(commitPartitionId, (RowId)validatedRowId, newRow, txId)).thenApply(ignored -> true);
                });
            });
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown two actions operation [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<RowId> takeLocksForReplace(BinaryRow expectedRow, BinaryRow oldRow, BinaryRow newRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.tableId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.S))).thenCompose(ignored -> {
            if (oldRow != null && this.equalValues(oldRow, expectedRow)) {
                return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey(this.tableId, (Object)rowId), LockMode.X).thenCompose(ignored1 -> this.takePutLockOnIndexes(newRow, rowId, txId))).thenApply(rowLock -> rowId);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Boolean> ensureReplicaIsPrimary(ReplicaRequest request) {
        Long expectedTerm;
        if (request instanceof ReadWriteReplicaRequest) {
            expectedTerm = ((ReadWriteReplicaRequest)request).term();
            assert (expectedTerm != null);
        } else if (request instanceof TxFinishReplicaRequest) {
            expectedTerm = ((TxFinishReplicaRequest)request).term();
            assert (expectedTerm != null);
        } else if (request instanceof TxCleanupReplicaRequest) {
            expectedTerm = ((TxCleanupReplicaRequest)request).term();
            assert (expectedTerm != null);
        } else {
            expectedTerm = null;
        }
        if (expectedTerm != null) {
            return this.raftClient.refreshAndGetLeaderWithTerm().thenCompose(replicaAndTerm -> {
                Long currentTerm = (Long)replicaAndTerm.get2();
                if (expectedTerm.equals(currentTerm)) {
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.failedFuture((Throwable)new PrimaryReplicaMissException(expectedTerm, currentTerm));
            });
        }
        if (request instanceof ReadOnlyReplicaRequest) {
            return this.raftClient.refreshAndGetLeaderWithTerm().thenApply(replicaAndTerm -> this.isLocalPeerChecker.apply((Peer)replicaAndTerm.get1()));
        }
        return CompletableFuture.completedFuture(null);
    }

    private BinaryRow resolveReadResult(ReadResult readResult, UUID txId) {
        return this.resolveReadResult(readResult, txId, null, null).join();
    }

    private CompletableFuture<BinaryRow> resolveReadResult(ReadResult readResult, HybridTimestamp timestamp, Supplier<BinaryRow> lastCommitted) {
        return this.resolveReadResult(readResult, null, timestamp, lastCommitted);
    }

    private CompletableFuture<BinaryRow> resolveReadResult(ReadResult readResult, @Nullable UUID txId, @Nullable HybridTimestamp timestamp, @Nullable Supplier<BinaryRow> lastCommitted) {
        if (readResult == null) {
            return null;
        }
        if (txId != null) {
            UUID retrievedResultTxId = readResult.transactionId();
            if (retrievedResultTxId == null || txId.equals(retrievedResultTxId)) {
                return CompletableFuture.completedFuture(readResult.binaryRow());
            }
            throw new AssertionError((Object)("Mismatched transaction id, expectedTxId={" + txId + "}, actualTxId={" + retrievedResultTxId + "}"));
        }
        if (!readResult.isWriteIntent()) {
            return CompletableFuture.completedFuture(readResult.binaryRow());
        }
        CompletableFuture<BinaryRow> writeIntentResolutionFut = this.resolveWriteIntentAsync(readResult, timestamp, lastCommitted);
        return writeIntentResolutionFut;
    }

    private CompletableFuture<BinaryRow> resolveWriteIntentAsync(ReadResult readResult, HybridTimestamp timestamp, Supplier<BinaryRow> lastCommitted) {
        TablePartitionId commitGrpId = new TablePartitionId(readResult.commitTableId(), readResult.commitPartitionId());
        return this.placementDriver.sendMetaRequest(commitGrpId, FACTORY.txStateReplicaRequest().groupId((ReplicationGroupId)commitGrpId).commitTimestamp(timestamp).txId(readResult.transactionId()).build()).thenApply(txMeta -> {
            if (txMeta == null) {
                return (BinaryRow)lastCommitted.get();
            }
            if (txMeta.txState() == TxState.COMMITED && txMeta.commitTimestamp().compareTo(timestamp) <= 0) {
                return readResult.binaryRow();
            }
            assert (txMeta.txState() == TxState.ABORTED) : "Unexpected transaction state [state=" + txMeta.txState() + "]";
            return (BinaryRow)lastCommitted.get();
        });
    }
}

