/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.Objects;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.MutableRowTupleAdapter;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;

public class TableRow
extends MutableRowTupleAdapter {
    public static Tuple keyTuple(Row row) {
        return new KeyRowChunk(row);
    }

    public static Tuple valueTuple(Row row) {
        return row.hasValue() ? new ValueRowChunk(row) : null;
    }

    public static Tuple tuple(Row row) {
        return new TableRow(row);
    }

    private TableRow(Row row) {
        super(row);
    }

    private static class ValueRowChunk
    extends MutableRowTupleAdapter {
        ValueRowChunk(@NotNull Row row) {
            super(row);
        }

        @Override
        public int columnCount() {
            return this.tuple != null ? this.tuple.columnCount() : this.schema().valueColumns().length();
        }

        @Override
        public int columnIndex(@NotNull String columnName) {
            if (this.tuple != null) {
                return this.tuple.columnIndex(columnName);
            }
            Objects.requireNonNull(columnName);
            Column col = this.schema().column(columnName);
            return col == null || this.schema().isKeyColumn(col.schemaIndex()) ? -1 : col.schemaIndex() - this.schema().keyColumns().length();
        }

        @Override
        protected Column rowColumnByName(@NotNull String columnName) {
            Column col = super.rowColumnByName(columnName);
            if (this.schema().isKeyColumn(col.schemaIndex())) {
                throw new IllegalArgumentException("Invalid column name: columnName=" + columnName);
            }
            return col;
        }

        @Override
        protected Column rowColumnByIndex(int columnIndex) {
            Objects.checkIndex(columnIndex, this.schema().valueColumns().length());
            return this.schema().column(columnIndex + this.schema().keyColumns().length());
        }
    }

    private static class KeyRowChunk
    extends MutableRowTupleAdapter {
        KeyRowChunk(@NotNull Row row) {
            super(row);
        }

        @Override
        public int columnCount() {
            return this.tuple != null ? this.tuple.columnCount() : this.schema().keyColumns().length();
        }

        @Override
        public int columnIndex(@NotNull String columnName) {
            if (this.tuple != null) {
                return this.tuple.columnIndex(columnName);
            }
            Objects.requireNonNull(columnName);
            Column col = this.schema().column(columnName);
            return col == null || !this.schema().isKeyColumn(col.schemaIndex()) ? -1 : col.schemaIndex();
        }

        @Override
        protected Column rowColumnByName(@NotNull String columnName) {
            Column col = super.rowColumnByName(columnName);
            if (!this.schema().isKeyColumn(col.schemaIndex())) {
                throw new IllegalArgumentException("Invalid column name: columnName=" + columnName);
            }
            return col;
        }

        @Override
        protected Column rowColumnByIndex(int columnIndex) {
            Objects.checkIndex(columnIndex, this.schema().keyColumns().length());
            return this.schema().column(columnIndex);
        }
    }
}

