/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InternalTable
extends AutoCloseable {
    public MvTableStorage storage();

    public UUID tableId();

    public String name();

    public CompletableFuture<BinaryRow> get(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<BinaryRow> get(BinaryRowEx var1, @NotNull HybridTimestamp var2, @NotNull ClusterNode var3);

    public CompletableFuture<Collection<BinaryRow>> getAll(Collection<BinaryRowEx> var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Collection<BinaryRow>> getAll(Collection<BinaryRowEx> var1, @NotNull HybridTimestamp var2, @NotNull ClusterNode var3);

    public CompletableFuture<Void> upsert(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Void> upsertAll(Collection<BinaryRowEx> var1, @Nullable InternalTransaction var2);

    public CompletableFuture<BinaryRow> getAndUpsert(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Boolean> insert(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Collection<BinaryRow>> insertAll(Collection<BinaryRowEx> var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Boolean> replace(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Boolean> replace(BinaryRowEx var1, BinaryRowEx var2, @Nullable InternalTransaction var3);

    public CompletableFuture<BinaryRow> getAndReplace(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Boolean> delete(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Boolean> deleteExact(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<BinaryRow> getAndDelete(BinaryRowEx var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Collection<BinaryRow>> deleteAll(Collection<BinaryRowEx> var1, @Nullable InternalTransaction var2);

    public CompletableFuture<Collection<BinaryRow>> deleteAllExact(Collection<BinaryRowEx> var1, @Nullable InternalTransaction var2);

    public int partition(BinaryRowEx var1);

    default public Flow.Publisher<BinaryRow> scan(int partId, @Nullable InternalTransaction tx) {
        return this.scan(partId, tx, null, null, null, 0, null);
    }

    default public Flow.Publisher<BinaryRow> scan(int partId, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode) {
        return this.scan(partId, readTimestamp, recipientNode, null, null, null, 0, null);
    }

    public Flow.Publisher<BinaryRow> scan(int var1, @NotNull HybridTimestamp var2, @NotNull ClusterNode var3, @NotNull UUID var4, @Nullable BinaryTuplePrefix var5, @Nullable BinaryTuplePrefix var6, int var7, @Nullable BitSet var8);

    public Flow.Publisher<BinaryRow> scan(int var1, @Nullable InternalTransaction var2, @Nullable UUID var3, @Nullable BinaryTuplePrefix var4, @Nullable BinaryTuplePrefix var5, int var6, @Nullable BitSet var7);

    public Flow.Publisher<BinaryRow> lookup(int var1, @NotNull HybridTimestamp var2, @NotNull ClusterNode var3, @NotNull UUID var4, BinaryTuple var5, @Nullable BitSet var6);

    public Flow.Publisher<BinaryRow> lookup(int var1, @Nullable InternalTransaction var2, @NotNull UUID var3, BinaryTuple var4, @Nullable BitSet var5);

    public int partitions();

    public List<String> assignments();

    public ClusterNode leaderAssignment(int var1);

    public RaftGroupService partitionRaftGroupService(int var1);

    public TxStateTableStorage txStateStorage();
}

