/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleter;

public class HoconDynamicCompleter
implements DynamicCompleter {
    private final Config config;
    private final Set<String> leafs;
    private final List<String> completions;
    private final Set<String> activationPostfixes;

    public HoconDynamicCompleter(Set<String> activationPostfixes, Config config) {
        this.activationPostfixes = activationPostfixes;
        this.config = config;
        this.leafs = config.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        this.completions = this.compile();
    }

    private List<String> compile() {
        ArrayList<String> result = new ArrayList<String>();
        String rootPrefix = "";
        this.walkAndAdd(rootPrefix, this.config.root().keySet(), result);
        return result;
    }

    @Override
    public List<String> complete(String[] words) {
        String lastWord = this.findLastNotEmptyWord(words);
        if (this.activationPostfixes.contains(lastWord) || this.activationPostfixes.contains("") && words[words.length - 1].isEmpty()) {
            return this.completions.stream().filter(s -> s.split("\\.").length == 1).collect(Collectors.toList());
        }
        int deepLevel = lastWord.endsWith(".") ? lastWord.split("\\.").length + 1 : lastWord.split("\\.").length;
        return this.completions.stream().filter(s -> s.startsWith(lastWord) && deepLevel == s.split("\\.").length).collect(Collectors.toList());
    }

    private String findLastNotEmptyWord(String[] words) {
        for (int i = words.length - 1; i >= 0; --i) {
            if (words[i].isEmpty()) continue;
            return words[i];
        }
        return "";
    }

    private void walkAndAdd(String keyPrefix, Set<String> keySet, List<String> result) {
        keySet.forEach(key -> {
            if (!this.leafs.contains(keyPrefix + key)) {
                Set nextKeySet = this.config.getConfig(keyPrefix + key).root().keySet();
                this.walkAndAdd(keyPrefix + key + ".", nextKeySet, result);
            }
            result.add(keyPrefix + key);
        });
    }
}

