/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;

public class ClientSqlRow
implements SqlRow {
    private final List<Object> row;
    private final ResultSetMetadata metadata;

    public ClientSqlRow(List<Object> row, ResultSetMetadata meta) {
        assert (row != null);
        assert (meta != null);
        this.row = row;
        this.metadata = meta;
    }

    public int columnCount() {
        return this.row.size();
    }

    public String columnName(int columnIndex) {
        return ((ColumnMetadata)this.metadata.columns().get(columnIndex)).name();
    }

    public int columnIndex(@NotNull String columnName) {
        return this.metadata.indexOf(columnName);
    }

    private int columnIndexChecked(@NotNull String columnName) {
        int idx = this.columnIndex(columnName);
        if (idx == -1) {
            throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
        }
        return idx;
    }

    public <T> T valueOrDefault(@NotNull String columnName, T defaultValue) {
        Object ret = this.row.get(this.columnIndexChecked(columnName));
        return (T)(ret != null ? ret : defaultValue);
    }

    public Tuple set(@NotNull String columnName, Object value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    public <T> T value(@NotNull String columnName) throws IllegalArgumentException {
        return (T)this.row.get(this.columnIndexChecked(columnName));
    }

    public <T> T value(int columnIndex) {
        return (T)this.row.get(columnIndex);
    }

    public BinaryObject binaryObjectValue(@NotNull String columnName) {
        return (BinaryObject)this.row.get(this.columnIndexChecked(columnName));
    }

    public BinaryObject binaryObjectValue(int columnIndex) {
        return (BinaryObject)this.row.get(columnIndex);
    }

    public byte byteValue(@NotNull String columnName) {
        return (Byte)this.row.get(this.columnIndexChecked(columnName));
    }

    public byte byteValue(int columnIndex) {
        return (Byte)this.row.get(columnIndex);
    }

    public short shortValue(@NotNull String columnName) {
        return (Short)this.row.get(this.columnIndexChecked(columnName));
    }

    public short shortValue(int columnIndex) {
        return (Short)this.row.get(columnIndex);
    }

    public int intValue(@NotNull String columnName) {
        return (Integer)this.row.get(this.columnIndexChecked(columnName));
    }

    public int intValue(int columnIndex) {
        return (Integer)this.row.get(columnIndex);
    }

    public long longValue(@NotNull String columnName) {
        return (Long)this.row.get(this.columnIndexChecked(columnName));
    }

    public long longValue(int columnIndex) {
        return (Long)this.row.get(columnIndex);
    }

    public float floatValue(@NotNull String columnName) {
        return ((Float)this.row.get(this.columnIndexChecked(columnName))).floatValue();
    }

    public float floatValue(int columnIndex) {
        return ((Float)this.row.get(columnIndex)).floatValue();
    }

    public double doubleValue(@NotNull String columnName) {
        return (Double)this.row.get(this.columnIndexChecked(columnName));
    }

    public double doubleValue(int columnIndex) {
        return (Double)this.row.get(columnIndex);
    }

    public String stringValue(@NotNull String columnName) {
        return (String)this.row.get(this.columnIndexChecked(columnName));
    }

    public String stringValue(int columnIndex) {
        return (String)this.row.get(columnIndex);
    }

    public UUID uuidValue(@NotNull String columnName) {
        return (UUID)this.row.get(this.columnIndexChecked(columnName));
    }

    public UUID uuidValue(int columnIndex) {
        return (UUID)this.row.get(columnIndex);
    }

    public BitSet bitmaskValue(@NotNull String columnName) {
        return (BitSet)this.row.get(this.columnIndexChecked(columnName));
    }

    public BitSet bitmaskValue(int columnIndex) {
        return (BitSet)this.row.get(columnIndex);
    }

    public LocalDate dateValue(String columnName) {
        return (LocalDate)this.row.get(this.columnIndexChecked(columnName));
    }

    public LocalDate dateValue(int columnIndex) {
        return (LocalDate)this.row.get(columnIndex);
    }

    public LocalTime timeValue(String columnName) {
        return (LocalTime)this.row.get(this.columnIndexChecked(columnName));
    }

    public LocalTime timeValue(int columnIndex) {
        return (LocalTime)this.row.get(columnIndex);
    }

    public LocalDateTime datetimeValue(String columnName) {
        return (LocalDateTime)this.row.get(this.columnIndexChecked(columnName));
    }

    public LocalDateTime datetimeValue(int columnIndex) {
        return (LocalDateTime)this.row.get(columnIndex);
    }

    public Instant timestampValue(String columnName) {
        return (Instant)this.row.get(this.columnIndexChecked(columnName));
    }

    public Instant timestampValue(int columnIndex) {
        return (Instant)this.row.get(columnIndex);
    }

    @NotNull
    public Iterator<Object> iterator() {
        return this.row.iterator();
    }

    public ResultSetMetadata metadata() {
        return this.metadata;
    }
}

