/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbTableStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.ReadTier;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;

public class RocksDbMvPartitionStorage
implements MvPartitionStorage {
    private static final int ROW_ID_OFFSET = 2;
    private static final int ROW_ID_SIZE = 16;
    private static final int ROW_PREFIX_SIZE = 18;
    private static final int TX_ID_SIZE = 16;
    private static final int TABLE_ID_SIZE = 16;
    private static final int PARTITION_ID_SIZE = 2;
    private static final int VALUE_HEADER_SIZE = 34;
    private static final int TX_ID_OFFSET = 0;
    private static final int TABLE_ID_OFFSET = 16;
    private static final int PARTITION_ID_OFFSET = 32;
    private static final int VALUE_OFFSET = 34;
    private static final int MAX_KEY_SIZE = 30;
    private static final ByteOrder KEY_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final ByteOrder BINARY_ROW_BYTE_ORDER = ByteBufferRow.ORDER;
    private static final ThreadLocal<ByteBuffer> MV_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(30).order(KEY_BYTE_ORDER));
    private static final ThreadLocal<WriteBatchWithIndex> WRITE_BATCH = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> HEAP_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(30).order(KEY_BYTE_ORDER));
    private final RocksDbTableStorage tableStorage;
    private final int partitionId;
    private final RocksDB db;
    private final ColumnFamilyHandle cf;
    private final ColumnFamilyHandle meta;
    private final WriteOptions writeOpts = new WriteOptions().setDisableWAL(true);
    private final ReadOptions readOpts = new ReadOptions();
    private final ReadOptions persistedTierReadOpts = new ReadOptions().setReadTier(ReadTier.PERSISTED_TIER);
    private final Slice upperBound;
    private final ReadOptions scanReadOptions;
    private final byte[] lastAppliedIndexKey;
    private volatile long lastAppliedIndex;
    private volatile long pendingAppliedIndex;
    private volatile long persistedIndex;

    public RocksDbMvPartitionStorage(RocksDbTableStorage tableStorage, int partitionId) {
        this.tableStorage = tableStorage;
        this.partitionId = partitionId;
        this.db = tableStorage.db();
        this.cf = tableStorage.partitionCfHandle();
        this.meta = tableStorage.metaCfHandle();
        this.upperBound = new Slice(this.partitionEndPrefix());
        this.scanReadOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)this.upperBound).setTotalOrderSeek(true);
        this.lastAppliedIndexKey = ("index" + partitionId).getBytes(StandardCharsets.UTF_8);
        this.persistedIndex = this.lastAppliedIndex = this.readLastAppliedIndex(this.readOpts);
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        if (WRITE_BATCH.get() != null) {
            return (V)closure.execute();
        }
        try {
            Object object;
            try (WriteBatchWithIndex writeBatch = new WriteBatchWithIndex();){
                WRITE_BATCH.set(writeBatch);
                this.pendingAppliedIndex = this.lastAppliedIndex;
                Object res = closure.execute();
                try {
                    this.db.write(this.writeOpts, writeBatch);
                }
                catch (RocksDBException e) {
                    throw new StorageException("Unable to apply a write batch to RocksDB instance.", (Throwable)e);
                }
                this.lastAppliedIndex = this.pendingAppliedIndex;
                object = res;
            }
            return (V)object;
        }
        finally {
            WRITE_BATCH.set(null);
        }
    }

    public CompletableFuture<Void> flush() {
        return this.tableStorage.awaitFlush(true);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public WriteBatchWithIndex currentWriteBatch() {
        return RocksDbMvPartitionStorage.requireWriteBatch();
    }

    public long lastAppliedIndex() {
        return WRITE_BATCH.get() == null ? this.lastAppliedIndex : this.pendingAppliedIndex;
    }

    public void lastAppliedIndex(long lastAppliedIndex) throws StorageException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        try {
            writeBatch.put(this.meta, this.lastAppliedIndexKey, ByteUtils.longToBytes((long)lastAppliedIndex));
            this.pendingAppliedIndex = lastAppliedIndex;
        }
        catch (RocksDBException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public long persistedIndex() {
        return this.persistedIndex;
    }

    public void refreshPersistedIndex() throws StorageException {
        this.persistedIndex = this.readLastAppliedIndex(this.persistedTierReadOpts);
    }

    private long readLastAppliedIndex(ReadOptions readOptions) {
        byte[] appliedIndexBytes;
        try {
            appliedIndexBytes = this.db.get(this.meta, readOptions, this.lastAppliedIndexKey);
        }
        catch (RocksDBException e) {
            throw new StorageException((Throwable)e);
        }
        return appliedIndexBytes == null ? 0L : ByteUtils.bytesToLong((byte[])appliedIndexBytes);
    }

    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, UUID commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        BinaryRow res = null;
        try {
            byte[] keyBufArray = keyBuf.array();
            byte[] keyBytes = Arrays.copyOf(keyBufArray, 18);
            byte[] previousValue = writeBatch.getFromBatchAndDB(this.db, this.cf, this.readOpts, keyBytes);
            if (previousValue != null) {
                RocksDbMvPartitionStorage.validateTxId(previousValue, txId);
                res = RocksDbMvPartitionStorage.wrapValueIntoBinaryRow(previousValue, true);
            }
            if (row == null) {
                if (previousValue != null) {
                    writeBatch.put(this.cf, keyBytes, Arrays.copyOf(previousValue, 34));
                } else {
                    byte[] valueHeaderBytes = new byte[34];
                    ByteUtils.putUuidToBytes((UUID)txId, (byte[])valueHeaderBytes, (int)0);
                    ByteUtils.putUuidToBytes((UUID)commitTableId, (byte[])valueHeaderBytes, (int)16);
                    RocksDbMvPartitionStorage.putShort(valueHeaderBytes, 32, (short)commitPartitionId);
                    writeBatch.put(this.cf, keyBytes, valueHeaderBytes);
                }
            } else {
                this.writeUnversioned(keyBufArray, row, txId, commitTableId, commitPartitionId);
            }
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to update a row in storage", (Throwable)e);
        }
        return res;
    }

    private void writeUnversioned(byte[] keyArray, BinaryRow row, UUID txId, UUID commitTableId, int commitPartitionId) throws RocksDBException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        byte[] rowBytes = RocksDbMvPartitionStorage.rowBytes(row);
        ByteBuffer value = ByteBuffer.allocate(rowBytes.length + 34);
        byte[] array = value.array();
        ByteUtils.putUuidToBytes((UUID)txId, (byte[])array, (int)0);
        ByteUtils.putUuidToBytes((UUID)commitTableId, (byte[])array, (int)16);
        RocksDbMvPartitionStorage.putShort(array, 32, (short)commitPartitionId);
        value.position(34).put(rowBytes);
        writeBatch.put(this.cf, Arrays.copyOf(keyArray, 18), value.array());
    }

    private static byte[] rowBytes(BinaryRow row) {
        return row.bytes();
    }

    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        try {
            byte[] keyBytes = Arrays.copyOf(keyBuf.array(), 18);
            byte[] previousValue = writeBatch.getFromBatchAndDB(this.db, this.cf, this.readOpts, keyBytes);
            if (previousValue == null) {
                return null;
            }
            writeBatch.delete(this.cf, keyBytes);
            return RocksDbMvPartitionStorage.wrapValueIntoBinaryRow(previousValue, true);
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to roll back insert/update", (Throwable)e);
        }
    }

    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        try {
            byte[] uncommittedKeyBytes = Arrays.copyOf(keyBuf.array(), 18);
            byte[] valueBytes = writeBatch.getFromBatchAndDB(this.db, this.cf, this.readOpts, uncommittedKeyBytes);
            if (valueBytes == null) {
                return;
            }
            writeBatch.delete(this.cf, uncommittedKeyBytes);
            RocksDbMvPartitionStorage.putTimestamp(keyBuf, timestamp);
            writeBatch.put(this.cf, Arrays.copyOf(keyBuf.array(), 30), Arrays.copyOfRange(valueBytes, 34, valueBytes.length));
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to commit row into storage", (Throwable)e);
        }
    }

    public void addWriteCommitted(RowId rowId, BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        WriteBatchWithIndex writeBatch = RocksDbMvPartitionStorage.requireWriteBatch();
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        RocksDbMvPartitionStorage.putTimestamp(keyBuf, commitTimestamp);
        byte[] rowBytes = RocksDbMvPartitionStorage.rowBytes(row);
        try {
            writeBatch.put(this.cf, Arrays.copyOf(keyBuf.array(), 30), rowBytes);
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to update a row in storage", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean lookingForLatestVersions(HybridTimestamp timestamp) {
        return timestamp == HybridTimestamp.MAX_VALUE;
    }

    private ReadResult readLatestVersion(RowId rowId, RocksIterator seekIterator) {
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        assert (keyBuf.position() == 18);
        seekIterator.seek(Arrays.copyOf(keyBuf.array(), 18));
        if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
            return ReadResult.EMPTY;
        }
        ByteBuffer readKeyBuf = MV_KEY_BUFFER.get().position(0).limit(30);
        int keyLength = seekIterator.key(readKeyBuf);
        if (!RocksDbMvPartitionStorage.matches(rowId, readKeyBuf)) {
            return ReadResult.EMPTY;
        }
        boolean isWriteIntent = keyLength == 18;
        byte[] valueBytes = seekIterator.value();
        return RocksDbMvPartitionStorage.readResultFromKeyAndValue(isWriteIntent, readKeyBuf, valueBytes);
    }

    private static ReadResult readResultFromKeyAndValue(boolean isWriteIntent, ByteBuffer keyBuf, byte[] valueBytes) {
        assert (valueBytes != null);
        if (!isWriteIntent) {
            return RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, RocksDbMvPartitionStorage.readTimestamp(keyBuf));
        }
        return RocksDbMvPartitionStorage.wrapUncommittedValue(valueBytes, null);
    }

    private ReadResult readByTimestamp(RocksIterator seekIterator, RowId rowId, HybridTimestamp timestamp) {
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        RocksDbMvPartitionStorage.putTimestamp(keyBuf, timestamp);
        seekIterator.seek(keyBuf.array());
        return RocksDbMvPartitionStorage.handleReadByTimestampIterator(seekIterator, rowId, timestamp, keyBuf);
    }

    private static ReadResult handleReadByTimestampIterator(RocksIterator seekIterator, RowId rowId, HybridTimestamp timestamp, ByteBuffer keyBuf) {
        boolean isWriteIntent;
        ByteBuffer foundKeyBuf = MV_KEY_BUFFER.get().position(0).limit(30);
        int keyLength = 0;
        if (!RocksDbMvPartitionStorage.invalid(seekIterator)) {
            keyLength = seekIterator.key(foundKeyBuf);
        }
        if (RocksDbMvPartitionStorage.invalid(seekIterator) || !RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
            boolean isWriteIntent2;
            seekIterator.seek(Arrays.copyOf(keyBuf.array(), 18));
            if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
                return ReadResult.EMPTY;
            }
            foundKeyBuf.position(0).limit(30);
            keyLength = seekIterator.key(foundKeyBuf);
            if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
                return ReadResult.EMPTY;
            }
            byte[] valueBytes = seekIterator.value();
            boolean bl = isWriteIntent2 = keyLength == 18;
            if (isWriteIntent2) {
                seekIterator.next();
                if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
                    return RocksDbMvPartitionStorage.wrapUncommittedValue(valueBytes, null);
                }
                foundKeyBuf.position(0).limit(30);
                seekIterator.key(foundKeyBuf);
                if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
                    return RocksDbMvPartitionStorage.wrapUncommittedValue(valueBytes, null);
                }
            }
            return ReadResult.EMPTY;
        }
        assert (keyLength == 30);
        HybridTimestamp rowTimestamp = RocksDbMvPartitionStorage.readTimestamp(foundKeyBuf);
        byte[] valueBytes = seekIterator.value();
        if (rowTimestamp.equals((Object)timestamp)) {
            return RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, rowTimestamp);
        }
        seekIterator.prev();
        if (RocksDbMvPartitionStorage.invalid(seekIterator)) {
            return RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, rowTimestamp);
        }
        foundKeyBuf.position(0).limit(30);
        keyLength = seekIterator.key(foundKeyBuf);
        if (!RocksDbMvPartitionStorage.matches(rowId, foundKeyBuf)) {
            return RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, rowTimestamp);
        }
        boolean bl = isWriteIntent = keyLength == 18;
        if (isWriteIntent) {
            return RocksDbMvPartitionStorage.wrapUncommittedValue(seekIterator.value(), rowTimestamp);
        }
        return RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, RocksDbMvPartitionStorage.readTimestamp(foundKeyBuf));
    }

    private static boolean matches(RowId rowId, ByteBuffer keyBuf) {
        keyBuf.position(2);
        return rowId.mostSignificantBits() == RocksDbMvPartitionStorage.normalize(keyBuf.getLong()) && rowId.leastSignificantBits() == RocksDbMvPartitionStorage.normalize(keyBuf.getLong());
    }

    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(rowId);
        byte[] lowerBound = Arrays.copyOf(keyBuf.array(), 18);
        this.incrementRowId(keyBuf);
        final Slice upperBound = new Slice(Arrays.copyOf(keyBuf.array(), 18));
        final ReadOptions options = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBound).setTotalOrderSeek(true);
        RocksIterator it = this.db.newIterator(this.cf, options);
        it.seek(lowerBound);
        return new RocksIteratorAdapter<ReadResult>(it){

            protected ReadResult decodeEntry(byte[] key, byte[] value) {
                int keyLength = key.length;
                boolean isWriteIntent = keyLength == 18;
                return RocksDbMvPartitionStorage.readResultFromKeyAndValue(isWriteIntent, ByteBuffer.wrap(key).order(KEY_BYTE_ORDER), value);
            }

            public void close() throws Exception {
                super.close();
                IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{options, upperBound});
            }
        };
    }

    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        Objects.requireNonNull(timestamp, "timestamp is null");
        if (this.lookingForLatestVersions(timestamp)) {
            return new ScanLatestVersionsCursor();
        }
        return new ScanByTimestampCursor(timestamp);
    }

    private void setKeyBuffer(ByteBuffer keyBuf, RowId rowId, @Nullable HybridTimestamp timestamp) {
        keyBuf.putLong(2, RocksDbMvPartitionStorage.normalize(rowId.mostSignificantBits()));
        keyBuf.putLong(10, RocksDbMvPartitionStorage.normalize(rowId.leastSignificantBits()));
        if (timestamp != null) {
            RocksDbMvPartitionStorage.putTimestamp(keyBuf.position(18), timestamp);
        }
        keyBuf.position(0);
    }

    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        ByteBuffer keyBuf = this.prepareHeapKeyBuf(lowerBound).position(0).limit(18);
        try {
            RowId rowId;
            block13: {
                RocksIterator it;
                block11: {
                    RowId rowId2;
                    block12: {
                        it = this.db.newIterator(this.cf, this.scanReadOptions);
                        try {
                            it.seek(keyBuf);
                            if (it.isValid()) break block11;
                            RocksUtils.checkIterator((RocksIterator)it);
                            rowId2 = null;
                            if (it == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (it != null) {
                                try {
                                    it.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        it.close();
                    }
                    return rowId2;
                }
                ByteBuffer readKeyBuf = MV_KEY_BUFFER.get().position(0).limit(18);
                it.key(readKeyBuf);
                rowId = this.getRowId(readKeyBuf);
                if (it == null) break block13;
                it.close();
            }
            return rowId;
        }
        finally {
            keyBuf.limit(30);
        }
    }

    private void incrementRowId(ByteBuffer buf) {
        long lsb = 1L + buf.getLong(10);
        buf.putLong(10, lsb);
        if (lsb != 0L) {
            return;
        }
        long msb = 1L + buf.getLong(2);
        buf.putLong(2, msb);
        if (msb != 0L) {
            return;
        }
        short partitionId = (short)(1 + buf.getShort(0));
        assert (partitionId != 0);
        buf.putShort(0, partitionId);
        buf.position(0);
    }

    private RowId getRowId(ByteBuffer buffer) {
        buffer.position(2);
        return new RowId(this.partitionId, RocksDbMvPartitionStorage.normalize(buffer.getLong()), RocksDbMvPartitionStorage.normalize(buffer.getLong()));
    }

    /*
     * Exception decompiling
     */
    public long rowsCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void forEach(BiConsumer<RowId, BinaryRow> consumer) {
        try (Slice upperBound = new Slice(this.partitionEndPrefix());
             ReadOptions options = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBound);
             RocksIterator it = this.db.newIterator(this.cf, options);){
            it.seek(this.partitionStartPrefix());
            while (it.isValid()) {
                boolean valueHasTxId;
                byte[] keyBytes = it.key();
                byte[] valueBytes = it.value();
                boolean bl = valueHasTxId = keyBytes.length == 18;
                if (!RocksDbMvPartitionStorage.isTombstone(valueBytes, valueHasTxId)) {
                    ByteBuffer keyBuf = ByteBuffer.wrap(keyBytes).order(KEY_BYTE_ORDER);
                    RowId rowId = this.getRowId(keyBuf);
                    BinaryRow binaryRow = RocksDbMvPartitionStorage.wrapValueIntoBinaryRow(valueBytes, valueHasTxId);
                    consumer.accept(rowId, binaryRow);
                }
                it.next();
            }
        }
    }

    public void destroy() {
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.delete(this.meta, this.lastAppliedIndexKey);
            writeBatch.delete(this.meta, RocksDbMetaStorage.partitionIdKey(this.partitionId));
            writeBatch.deleteRange(this.cf, this.partitionStartPrefix(), this.partitionEndPrefix());
            this.db.write(this.writeOpts, writeBatch);
        }
        catch (RocksDBException e) {
            TableConfiguration tableCfg = this.tableStorage.configuration();
            throw new StorageException("Failed to destroy partition " + this.partitionId + " of table " + tableCfg.name(), (Throwable)e);
        }
    }

    public void close() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.persistedTierReadOpts, this.readOpts, this.writeOpts, this.scanReadOptions, this.upperBound});
    }

    private static WriteBatchWithIndex requireWriteBatch() {
        WriteBatchWithIndex writeBatch = WRITE_BATCH.get();
        if (writeBatch == null) {
            throw new StorageException("Attempting to write data outside of data access closure.");
        }
        return writeBatch;
    }

    private ByteBuffer prepareHeapKeyBuf(RowId rowId) {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        ByteBuffer keyBuf = HEAP_KEY_BUFFER.get().position(0);
        keyBuf.putShort((short)rowId.partitionId());
        keyBuf.putLong(RocksDbMvPartitionStorage.normalize(rowId.mostSignificantBits()));
        keyBuf.putLong(RocksDbMvPartitionStorage.normalize(rowId.leastSignificantBits()));
        return keyBuf;
    }

    private static long normalize(long value) {
        return value ^ Long.MIN_VALUE;
    }

    private static void putTimestamp(ByteBuffer buf, HybridTimestamp ts) {
        assert (buf.order() == KEY_BYTE_ORDER);
        buf.putLong(ts.getPhysical() ^ 0xFFFFFFFFFFFFFFFFL);
        buf.putInt(~ts.getLogical());
    }

    private static HybridTimestamp readTimestamp(ByteBuffer keyBuf) {
        assert (keyBuf.order() == KEY_BYTE_ORDER);
        long physical = keyBuf.getLong(18) ^ 0xFFFFFFFFFFFFFFFFL;
        int logical = ~keyBuf.getInt(26);
        return new HybridTimestamp(physical, logical);
    }

    private static void putShort(byte[] array, int off, short value) {
        GridUnsafe.putShort((byte[])array, (long)(GridUnsafe.BYTE_ARR_OFF + (long)off), (short)value);
    }

    private static void validateTxId(byte[] valueBytes, UUID txId) {
        long msb = ByteUtils.bytesToLong((byte[])valueBytes);
        long lsb = ByteUtils.bytesToLong((byte[])valueBytes, (int)8);
        if (txId.getMostSignificantBits() != msb || txId.getLeastSignificantBits() != lsb) {
            throw new TxIdMismatchException(txId, new UUID(msb, lsb));
        }
    }

    private static boolean invalid(RocksIterator it) {
        boolean invalid;
        boolean bl = invalid = !it.isValid();
        if (invalid) {
            try {
                it.status();
            }
            catch (RocksDBException e) {
                throw new StorageException("Failed to read data from storage", (Throwable)e);
            }
        }
        return invalid;
    }

    @Nullable
    private static BinaryRow wrapValueIntoBinaryRow(byte[] valueBytes, boolean valueHasTxData) {
        if (RocksDbMvPartitionStorage.isTombstone(valueBytes, valueHasTxData)) {
            return null;
        }
        return valueHasTxData ? new ByteBufferRow(ByteBuffer.wrap(valueBytes).position(34).slice().order(BINARY_ROW_BYTE_ORDER)) : new ByteBufferRow(valueBytes);
    }

    private static ReadResult wrapUncommittedValue(byte[] valueBytes, @Nullable HybridTimestamp newestCommitTs) {
        UUID txId = ByteUtils.bytesToUuid((byte[])valueBytes, (int)0);
        UUID commitTableId = ByteUtils.bytesToUuid((byte[])valueBytes, (int)16);
        int commitPartitionId = GridUnsafe.getShort((byte[])valueBytes, (long)(GridUnsafe.BYTE_ARR_OFF + 32L)) & 0xFFFF;
        ByteBufferRow row = RocksDbMvPartitionStorage.isTombstone(valueBytes, true) ? null : new ByteBufferRow(ByteBuffer.wrap(valueBytes).position(34).slice().order(BINARY_ROW_BYTE_ORDER));
        return ReadResult.createFromWriteIntent(row, (UUID)txId, (UUID)commitTableId, (int)commitPartitionId, (HybridTimestamp)newestCommitTs);
    }

    private static ReadResult wrapCommittedValue(byte[] valueBytes, HybridTimestamp rowCommitTimestamp) {
        if (RocksDbMvPartitionStorage.isTombstone(valueBytes, false)) {
            return ReadResult.EMPTY;
        }
        return ReadResult.createFromCommitted((BinaryRow)new ByteBufferRow(valueBytes), (HybridTimestamp)rowCommitTimestamp);
    }

    public byte[] partitionStartPrefix() {
        return RocksDbMvPartitionStorage.unsignedShortAsBytes(this.partitionId);
    }

    public byte[] partitionEndPrefix() {
        return RocksDbMvPartitionStorage.unsignedShortAsBytes(this.partitionId + 1);
    }

    private static byte[] unsignedShortAsBytes(int value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    private static boolean isTombstone(byte[] valueBytes, boolean hasTxId) {
        return valueBytes.length == (hasTxId ? 34 : 0);
    }

    private final class ScanByTimestampCursor
    extends BasePartitionTimestampCursor {
        private final HybridTimestamp timestamp;

        public ScanByTimestampCursor(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
        }

        public boolean hasNext() {
            ReadResult readResult;
            RowId rowId;
            if (this.next != null) {
                return true;
            }
            if (this.currentRowId != null) {
                RocksDbMvPartitionStorage.this.setKeyBuffer(this.seekKeyBuf, this.currentRowId, this.timestamp);
                RocksDbMvPartitionStorage.this.incrementRowId(this.seekKeyBuf);
            }
            this.currentRowId = null;
            ByteBuffer directBuffer = MV_KEY_BUFFER.get().position(0);
            while (true) {
                this.it.seek(this.seekKeyBuf.array());
                if (RocksDbMvPartitionStorage.invalid(this.it)) {
                    return false;
                }
                this.it.key(directBuffer.position(0));
                rowId = RocksDbMvPartitionStorage.this.getRowId(directBuffer);
                RocksDbMvPartitionStorage.this.setKeyBuffer(this.seekKeyBuf, rowId, this.timestamp);
                this.it.seek(this.seekKeyBuf.array());
                readResult = RocksDbMvPartitionStorage.handleReadByTimestampIterator(this.it, rowId, this.timestamp, this.seekKeyBuf);
                if (!readResult.isEmpty() || readResult.isWriteIntent()) break;
                RocksDbMvPartitionStorage.this.incrementRowId(this.seekKeyBuf);
            }
            this.next = readResult;
            this.currentRowId = rowId;
            return true;
        }
    }

    private final class ScanLatestVersionsCursor
    extends BasePartitionTimestampCursor {
        private ScanLatestVersionsCursor() {
        }

        public boolean hasNext() {
            RowId rowId;
            HybridTimestamp nextCommitTimestamp;
            byte[] valueBytes;
            boolean isWriteIntent;
            ReadResult readResult;
            if (this.next != null) {
                return true;
            }
            if (this.currentRowId != null) {
                RocksDbMvPartitionStorage.this.setKeyBuffer(this.seekKeyBuf, this.currentRowId, null);
                RocksDbMvPartitionStorage.this.incrementRowId(this.seekKeyBuf);
            }
            this.currentRowId = null;
            ByteBuffer currentKeyBuffer = MV_KEY_BUFFER.get().position(0);
            do {
                currentKeyBuffer.position(0);
                this.it.seek(this.seekKeyBuf.array());
                if (RocksDbMvPartitionStorage.invalid(this.it)) {
                    return false;
                }
                int keyLength = this.it.key(currentKeyBuffer.limit(30));
                isWriteIntent = keyLength == 18;
                currentKeyBuffer.limit(18);
                rowId = RocksDbMvPartitionStorage.this.getRowId(currentKeyBuffer);
                this.seekKeyBuf.putLong(2, RocksDbMvPartitionStorage.normalize(rowId.mostSignificantBits()));
                this.seekKeyBuf.putLong(10, RocksDbMvPartitionStorage.normalize(rowId.leastSignificantBits()));
                RocksDbMvPartitionStorage.this.incrementRowId(this.seekKeyBuf);
                valueBytes = this.it.value();
                nextCommitTimestamp = null;
                if (isWriteIntent) {
                    ByteBuffer key;
                    this.it.next();
                    if (!RocksDbMvPartitionStorage.invalid(this.it) && RocksDbMvPartitionStorage.matches(rowId, key = ByteBuffer.wrap(this.it.key()).order(KEY_BYTE_ORDER))) {
                        nextCommitTimestamp = RocksDbMvPartitionStorage.readTimestamp(key);
                    }
                }
                currentKeyBuffer.limit(keyLength);
                assert (valueBytes != null);
            } while ((readResult = !isWriteIntent ? RocksDbMvPartitionStorage.wrapCommittedValue(valueBytes, RocksDbMvPartitionStorage.readTimestamp(currentKeyBuffer)) : RocksDbMvPartitionStorage.wrapUncommittedValue(valueBytes, nextCommitTimestamp)).isEmpty() && !readResult.isWriteIntent());
            this.next = readResult;
            this.currentRowId = rowId;
            return true;
        }
    }

    private abstract class BasePartitionTimestampCursor
    implements PartitionTimestampCursor {
        protected final RocksIterator it;
        protected final ByteBuffer seekKeyBuf;
        protected RowId currentRowId;
        protected ReadResult next;

        private BasePartitionTimestampCursor() {
            this.it = RocksDbMvPartitionStorage.this.db.newIterator(RocksDbMvPartitionStorage.this.cf, RocksDbMvPartitionStorage.this.scanReadOptions);
            this.seekKeyBuf = ByteBuffer.allocate(30).order(KEY_BYTE_ORDER).putShort((short)RocksDbMvPartitionStorage.this.partitionId);
        }

        @Nullable
        public BinaryRow committed(HybridTimestamp timestamp) {
            Objects.requireNonNull(timestamp, "timestamp is null");
            if (this.currentRowId == null) {
                throw new IllegalStateException("currentRowId is null");
            }
            RocksDbMvPartitionStorage.this.setKeyBuffer(this.seekKeyBuf, this.currentRowId, timestamp);
            this.it.seek(this.seekKeyBuf.array());
            ReadResult readResult = RocksDbMvPartitionStorage.handleReadByTimestampIterator(this.it, this.currentRowId, timestamp, this.seekKeyBuf);
            if (readResult.isEmpty()) {
                return null;
            }
            return readResult.binaryRow();
        }

        public final ReadResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ReadResult res = this.next;
            this.next = null;
            return res;
        }

        public final void close() throws Exception {
            this.it.close();
        }
    }
}

