/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hc.core5.http.nio.entity.PathEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TestPathEntityProducer {
    TestPathEntityProducer() {
    }

    @Test
    void testFileLengthMaxIntPlusOne(@TempDir Path tempFolder) throws IOException {
        Path path = Files.createFile(tempFolder.resolve("test.bin"), new FileAttribute[0]);
        try (RandomAccessFile raFile = new RandomAccessFile(path.toFile(), "rw");){
            long expectedLength = 0x80000000L;
            raFile.setLength(0x80000000L);
            PathEntityProducer fileEntityProducer = new PathEntityProducer(path, new OpenOption[]{StandardOpenOption.READ});
            Assertions.assertEquals((long)0x80000000L, (long)fileEntityProducer.getContentLength());
        }
    }
}

