/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionClassLoader.class);
    private static final String EXTENSION_TEMP_DIR_PREFIX = "guac-extension-lib-";
    private static final String EXTENSION_TEMP_LIB_PREFIX = "bundled-";
    private final ClassLoader parent;

    public static ExtensionClassLoader getInstance(File extension, List<File> temporaryFiles, ClassLoader parent) throws GuacamoleException {
        try {
            return (ExtensionClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException e) {
            throw (GuacamoleException)((Object)e.getException());
        }
    }

    private static URL getFileURL(File file) throws GuacamoleException {
        if (!file.isFile()) {
            throw new GuacamoleServerException("\"" + file + "\" is not a file.");
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new GuacamoleServerException((Throwable)e);
        }
    }

    private static void copyEntryToFile(JarFile jar, JarEntry source, File dest) throws IOException {
        byte[] buffer = new byte[8192];
        try (InputStream input = jar.getInputStream(source);
             FileOutputStream output = new FileOutputStream(dest);){
            int length;
            while ((length = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
        }
    }

    private static URL[] getExtensionURLs(File extension, List<File> temporaryFiles) throws GuacamoleException {
        URL[] uRLArray;
        JarFile extensionJar = new JarFile(extension);
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(ExtensionClassLoader.getFileURL((File)extension));
            Path extensionTempLibDir = null;
            Enumeration<JarEntry> entries = extensionJar.entries();
            while (entries.hasMoreElements()) {
                File tempLibrary;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".jar") || name.indexOf(47) != -1) continue;
                try {
                    if (extensionTempLibDir == null) {
                        extensionTempLibDir = Files.createTempDirectory("guac-extension-lib-", new FileAttribute[0]);
                        temporaryFiles.add(extensionTempLibDir.toFile());
                        extensionTempLibDir.toFile().deleteOnExit();
                    }
                }
                catch (IOException e) {
                    throw new GuacamoleServerException("Temporary directory for libraries bundled with extension \"" + extension + "\" could not be created.", (Throwable)e);
                }
                try {
                    tempLibrary = Files.createTempFile(extensionTempLibDir, "bundled-", ".jar", new FileAttribute[0]).toFile();
                    temporaryFiles.add(tempLibrary);
                    tempLibrary.deleteOnExit();
                }
                catch (IOException e) {
                    throw new GuacamoleServerException("Temporary file for library \"" + name + "\" bundled with extension \"" + extension + "\" could not be created.", (Throwable)e);
                }
                try {
                    ExtensionClassLoader.copyEntryToFile((JarFile)extensionJar, (JarEntry)entry, (File)tempLibrary);
                }
                catch (IOException e) {
                    throw new GuacamoleServerException("Contents of library \"" + name + "\" bundled with extension \"" + extension + "\" could not be copied to a temporary file.", (Throwable)e);
                }
                urls.add(ExtensionClassLoader.getFileURL((File)tempLibrary));
            }
            if (extensionTempLibDir != null) {
                logger.debug("Libraries bundled within extension \"{}\" have been copied to temporary directory \"{}\".", (Object)extension, extensionTempLibDir);
            }
            uRLArray = urls.toArray(new URL[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    extensionJar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GuacamoleServerException("Contents of extension \"" + extension + "\" cannot be read.", (Throwable)e);
            }
        }
        extensionJar.close();
        return uRLArray;
    }

    private ExtensionClassLoader(File extension, List<File> temporaryFiles, ClassLoader parent) throws GuacamoleException {
        super(ExtensionClassLoader.getExtensionURLs((File)extension, temporaryFiles), (ClassLoader)null);
        this.parent = parent;
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException e) {
            return this.parent.loadClass(string);
        }
    }
}

