/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.codehaus.groovy.runtime

/**
 * Test case for File class extension methods.
 */
class FileStaticGroovyMethodsTest extends GroovyTestCase {
    void testCreateTempDirectory() {
        def file = File.createTempDir()
        assert file
        try {
            assert file.isDirectory()
            assert file.parentFile.absolutePath == new File(System.getProperty('java.io.tmpdir')).absolutePath
        } finally {
            file.delete()
            assert !file.exists()
        }
    }
}
