/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.experimental;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

@Experimental
public class CollectSink<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private final InetAddress hostIp;
    private final int port;
    private final TypeSerializer<IN> serializer;
    private transient Socket client;
    private transient OutputStream outputStream;
    private transient DataOutputViewStreamWrapper streamWriter;

    public CollectSink(InetAddress hostIp, int port, TypeSerializer<IN> serializer) {
        this.hostIp = hostIp;
        this.port = port;
        this.serializer = serializer;
    }

    @Override
    public void invoke(IN value, SinkFunction.Context context) throws Exception {
        try {
            this.serializer.serialize(value, this.streamWriter);
        }
        catch (Exception e) {
            throw new IOException("Error sending data back to client (" + this.hostIp.toString() + ":" + this.port + ')', e);
        }
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        try {
            this.client = new Socket(this.hostIp, this.port);
            this.outputStream = this.client.getOutputStream();
            this.streamWriter = new DataOutputViewStreamWrapper(this.outputStream);
        }
        catch (IOException e) {
            throw new IOException("Cannot get back the stream while opening connection to client at " + this.hostIp.toString() + ":" + this.port, e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Error while closing connection that streams data back to client at " + this.hostIp.toString() + ":" + this.port, e);
        }
        finally {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

