/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class AbstractBroadcastStateTransformation<IN1, IN2, OUT>
extends PhysicalTransformation<OUT> {
    private final List<MapStateDescriptor<?, ?>> broadcastStateDescriptors;
    private final Transformation<IN1> regularInput;
    private final Transformation<IN2> broadcastInput;
    private ChainingStrategy chainingStrategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;

    protected AbstractBroadcastStateTransformation(String name, Transformation<IN1> regularInput, Transformation<IN2> broadcastInput, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors, TypeInformation<OUT> outTypeInfo, int parallelism) {
        super(name, outTypeInfo, parallelism);
        this.regularInput = Preconditions.checkNotNull(regularInput);
        this.broadcastInput = Preconditions.checkNotNull(broadcastInput);
        this.broadcastStateDescriptors = broadcastStateDescriptors;
    }

    public Transformation<IN2> getBroadcastInput() {
        return this.broadcastInput;
    }

    public Transformation<IN1> getRegularInput() {
        return this.regularInput;
    }

    public List<MapStateDescriptor<?, ?>> getBroadcastStateDescriptors() {
        return this.broadcastStateDescriptors;
    }

    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy chainingStrategy) {
        this.chainingStrategy = Preconditions.checkNotNull(chainingStrategy);
    }

    @Override
    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList predecessors = new ArrayList();
        predecessors.add(this);
        predecessors.add(this.regularInput);
        predecessors.add(this.broadcastInput);
        return predecessors;
    }

    @Override
    public List<Transformation<?>> getInputs() {
        ArrayList predecessors = new ArrayList();
        predecessors.add(this.regularInput);
        predecessors.add(this.broadcastInput);
        return predecessors;
    }
}

