/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;

public enum HighAvailabilityMode {
    NONE(false),
    ZOOKEEPER(true),
    KUBERNETES(true),
    FACTORY_CLASS(true);

    private final boolean haActive;

    private HighAvailabilityMode(boolean haActive) {
        this.haActive = haActive;
    }

    public static HighAvailabilityMode fromConfig(Configuration config) {
        String haMode = config.getValue(HighAvailabilityOptions.HA_MODE);
        if (haMode == null) {
            return NONE;
        }
        if (haMode.equalsIgnoreCase("standalone")) {
            return NONE;
        }
        try {
            return HighAvailabilityMode.valueOf(haMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return FACTORY_CLASS;
        }
    }

    public static boolean isHighAvailabilityModeActivated(Configuration configuration) {
        HighAvailabilityMode mode = HighAvailabilityMode.fromConfig(configuration);
        return mode.haActive;
    }
}

