/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SharedSlotProfileRetriever;
import org.apache.flink.runtime.scheduler.SyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

class MergingSharedSlotProfileRetrieverFactory
implements SharedSlotProfileRetriever.SharedSlotProfileRetrieverFactory {
    private final SyncPreferredLocationsRetriever preferredLocationsRetriever;
    private final Function<ExecutionVertexID, Optional<AllocationID>> priorAllocationIdRetriever;
    private final Supplier<Set<AllocationID>> reservedAllocationIdsRetriever;

    MergingSharedSlotProfileRetrieverFactory(SyncPreferredLocationsRetriever preferredLocationsRetriever, Function<ExecutionVertexID, Optional<AllocationID>> priorAllocationIdRetriever, Supplier<Set<AllocationID>> reservedAllocationIdsRetriever) {
        this.preferredLocationsRetriever = Preconditions.checkNotNull(preferredLocationsRetriever);
        this.priorAllocationIdRetriever = Preconditions.checkNotNull(priorAllocationIdRetriever);
        this.reservedAllocationIdsRetriever = Preconditions.checkNotNull(reservedAllocationIdsRetriever);
    }

    @Override
    public SharedSlotProfileRetriever createFromBulk(Set<ExecutionVertexID> bulk) {
        return new MergingSharedSlotProfileRetriever(this.reservedAllocationIdsRetriever.get(), bulk);
    }

    private class MergingSharedSlotProfileRetriever
    implements SharedSlotProfileRetriever {
        private final Set<AllocationID> reservedAllocationIds;
        private final Set<ExecutionVertexID> producersToIgnore;

        private MergingSharedSlotProfileRetriever(Set<AllocationID> reservedAllocationIds, Set<ExecutionVertexID> producersToIgnore) {
            this.reservedAllocationIds = Preconditions.checkNotNull(reservedAllocationIds);
            this.producersToIgnore = Preconditions.checkNotNull(producersToIgnore);
        }

        @Override
        public SlotProfile getSlotProfile(ExecutionSlotSharingGroup executionSlotSharingGroup, ResourceProfile physicalSlotResourceProfile) {
            HashSet<AllocationID> priorAllocations = new HashSet<AllocationID>();
            ArrayList<TaskManagerLocation> preferredLocations = new ArrayList<TaskManagerLocation>();
            for (ExecutionVertexID execution : executionSlotSharingGroup.getExecutionVertexIds()) {
                ((Optional)MergingSharedSlotProfileRetrieverFactory.this.priorAllocationIdRetriever.apply(execution)).ifPresent(priorAllocations::add);
                preferredLocations.addAll(MergingSharedSlotProfileRetrieverFactory.this.preferredLocationsRetriever.getPreferredLocations(execution, this.producersToIgnore));
            }
            return SlotProfile.priorAllocation(physicalSlotResourceProfile, physicalSlotResourceProfile, preferredLocations, priorAllocations, this.reservedAllocationIds);
        }
    }
}

