/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.operators.util.JoinHashMap;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativeTask;
import org.apache.flink.runtime.operators.ResettableDriver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.EmptyIterator;
import org.apache.flink.runtime.util.NonReusingKeyGroupedIterator;
import org.apache.flink.runtime.util.ReusingKeyGroupedIterator;
import org.apache.flink.runtime.util.SingleElementIterator;
import org.apache.flink.util.Collector;

public class CoGroupWithSolutionSetSecondDriver<IT1, IT2, OT>
implements ResettableDriver<CoGroupFunction<IT1, IT2, OT>, OT> {
    private TaskContext<CoGroupFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT2> hashTable;
    private JoinHashMap<IT2> objectMap;
    private TypeSerializer<IT1> probeSideSerializer;
    private TypeComparator<IT1> probeSideComparator;
    private TypeSerializer<IT2> solutionSetSerializer;
    private TypePairComparator<IT1, IT2> pairComparator;
    private IT2 solutionSideRecord;
    protected volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<CoGroupFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<CoGroupFunction<IT1, IT2, OT>> getStubType() {
        Class<CoGroupFunction> clazz = CoGroupFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize() throws Exception {
        void var1_6;
        if (!(this.taskContext instanceof AbstractIterativeTask)) throw new Exception("The task context of this driver is no iterative task context.");
        AbstractIterativeTask iterativeTaskContext = (AbstractIterativeTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        Object table = SolutionSetBroker.instance().get(identifier);
        if (table instanceof CompactingHashTable) {
            this.hashTable = (CompactingHashTable)table;
            this.solutionSetSerializer = this.hashTable.getBuildSideSerializer();
            TypeComparator typeComparator = this.hashTable.getBuildSideComparator().duplicate();
        } else {
            if (!(table instanceof JoinHashMap)) throw new RuntimeException("Unrecognized solution set index: " + table);
            this.objectMap = (JoinHashMap)((Object)table);
            this.solutionSetSerializer = this.objectMap.getBuildSerializer();
            TypeComparator<IT2> typeComparator = this.objectMap.getBuildComparator().duplicate();
        }
        TaskConfig config = this.taskContext.getTaskConfig();
        ClassLoader classLoader = this.taskContext.getUserCodeClassLoader();
        TypeComparatorFactory probeSideComparatorFactory = config.getDriverComparator(0, classLoader);
        this.probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.probeSideComparator = probeSideComparatorFactory.createComparator();
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (this.objectReuseEnabled) {
            this.solutionSideRecord = this.solutionSetSerializer.createInstance();
        }
        TypePairComparatorFactory factory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = factory.createComparator12(this.probeSideComparator, var1_6);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        CoGroupFunction<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        SingleElementIterator<IT2> siIter = new SingleElementIterator<IT2>();
        EmptyIterator emptySolutionSide = EmptyIterator.get();
        if (this.objectReuseEnabled) {
            ReusingKeyGroupedIterator probeSideInput = new ReusingKeyGroupedIterator(this.taskContext.getInput(0), this.probeSideSerializer, this.probeSideComparator);
            if (this.hashTable != null) {
                CompactingHashTable<IT2> join = this.hashTable;
                AbstractHashTableProber prober = join.getProber(this.probeSideComparator, this.pairComparator);
                IT2 buildSideRecord = this.solutionSideRecord;
                while (this.running && probeSideInput.nextKey()) {
                    Object current = probeSideInput.getCurrent();
                    IT2 matchedRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(current, buildSideRecord);
                    if (matchedRecord != null) {
                        siIter.set(matchedRecord);
                        coGroupStub.coGroup(probeSideInput.getValues(), siIter, collector);
                        continue;
                    }
                    coGroupStub.coGroup(probeSideInput.getValues(), emptySolutionSide, collector);
                }
            } else {
                JoinHashMap<IT2> join = this.objectMap;
                JoinHashMap.Prober<IT1> prober = join.createProber(this.probeSideComparator, this.pairComparator);
                TypeSerializer<IT2> serializer = join.getBuildSerializer();
                while (this.running && probeSideInput.nextKey()) {
                    Object current = probeSideInput.getCurrent();
                    Object buildSideRecord = prober.lookupMatch(current);
                    if (buildSideRecord != null) {
                        siIter.set(serializer.copy(buildSideRecord));
                        coGroupStub.coGroup(probeSideInput.getValues(), siIter, collector);
                        continue;
                    }
                    coGroupStub.coGroup(probeSideInput.getValues(), emptySolutionSide, collector);
                }
            }
        } else {
            NonReusingKeyGroupedIterator probeSideInput = new NonReusingKeyGroupedIterator(this.taskContext.getInput(0), this.probeSideComparator);
            if (this.hashTable != null) {
                CompactingHashTable<IT2> join = this.hashTable;
                AbstractHashTableProber prober = join.getProber(this.probeSideComparator, this.pairComparator);
                while (this.running && probeSideInput.nextKey()) {
                    Object current = probeSideInput.getCurrent();
                    Object buildSideRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(current);
                    if (buildSideRecord != null) {
                        siIter.set(this.solutionSetSerializer.copy(buildSideRecord));
                        coGroupStub.coGroup(probeSideInput.getValues(), siIter, collector);
                        continue;
                    }
                    coGroupStub.coGroup(probeSideInput.getValues(), emptySolutionSide, collector);
                }
            } else {
                JoinHashMap<IT2> join = this.objectMap;
                JoinHashMap.Prober<IT1> prober = join.createProber(this.probeSideComparator, this.pairComparator);
                TypeSerializer<IT2> serializer = join.getBuildSerializer();
                while (this.running && probeSideInput.nextKey()) {
                    Object current = probeSideInput.getCurrent();
                    Object buildSideRecord = prober.lookupMatch(current);
                    if (buildSideRecord != null) {
                        siIter.set(serializer.copy(buildSideRecord));
                        coGroupStub.coGroup(probeSideInput.getValues(), siIter, collector);
                        continue;
                    }
                    coGroupStub.coGroup(probeSideInput.getValues(), emptySolutionSide, collector);
                }
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

