/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JMXServerOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.core.security.FlinkSecurityManager;
import org.apache.flink.management.jmx.JMXService;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.ClusterEntryPointExceptionUtils;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointException;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.DeterminismEnvelope;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfiguration;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.security.token.KerberosDelegationTokenManagerFactory;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcMetricQueryServiceRetriever;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;
import org.apache.flink.util.ShutdownHookUtil;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterEntrypoint
implements AutoCloseableAsync,
FatalErrorHandler {
    public static final ConfigOption<String> INTERNAL_CLUSTER_EXECUTION_MODE = ConfigOptions.key("internal.cluster.execution-mode").stringType().defaultValue(ExecutionMode.NORMAL.toString());
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterEntrypoint.class);
    protected static final int STARTUP_FAILURE_RETURN_CODE = 1;
    protected static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private static final Time INITIALIZATION_SHUTDOWN_TIMEOUT = Time.seconds(30L);
    private final Object lock = new Object();
    private final Configuration configuration;
    private final CompletableFuture<ApplicationStatus> terminationFuture;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    @GuardedBy(value="lock")
    private DeterminismEnvelope<ResourceID> resourceId;
    @GuardedBy(value="lock")
    private DispatcherResourceManagerComponent clusterComponent;
    @GuardedBy(value="lock")
    private MetricRegistryImpl metricRegistry;
    @GuardedBy(value="lock")
    private ProcessMetricGroup processMetricGroup;
    @GuardedBy(value="lock")
    private HighAvailabilityServices haServices;
    @GuardedBy(value="lock")
    private BlobServer blobServer;
    @GuardedBy(value="lock")
    private HeartbeatServices heartbeatServices;
    @GuardedBy(value="lock")
    private DelegationTokenManager delegationTokenManager;
    @GuardedBy(value="lock")
    private RpcService commonRpcService;
    @GuardedBy(value="lock")
    private ExecutorService ioExecutor;
    @GuardedBy(value="lock")
    private DeterminismEnvelope<WorkingDirectory> workingDirectory;
    private ExecutionGraphInfoStore executionGraphInfoStore;
    private final Thread shutDownHook;
    private RpcSystem rpcSystem;

    protected ClusterEntrypoint(Configuration configuration) {
        this.configuration = this.generateClusterConfiguration(configuration);
        this.terminationFuture = new CompletableFuture();
        if (configuration.get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE && !this.supportsReactiveMode()) {
            String msg = "Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).";
            LOG.error("Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).");
            throw new IllegalConfigurationException("Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).");
        }
        this.shutDownHook = ShutdownHookUtil.addShutdownHook(() -> this.closeAsync().join(), this.getClass().getSimpleName(), LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRestPort() {
        Object object = this.lock;
        synchronized (object) {
            this.assertClusterEntrypointIsStarted();
            return this.clusterComponent.getRestPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRpcPort() {
        Object object = this.lock;
        synchronized (object) {
            this.assertClusterEntrypointIsStarted();
            return this.commonRpcService.getPort();
        }
    }

    @GuardedBy(value="lock")
    private void assertClusterEntrypointIsStarted() {
        Preconditions.checkNotNull(this.commonRpcService, String.format("%s has not been started yet.", this.getClass().getSimpleName()));
    }

    public CompletableFuture<ApplicationStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void startCluster() throws ClusterEntrypointException {
        LOG.info("Starting {}.", (Object)this.getClass().getSimpleName());
        try {
            FlinkSecurityManager.setFromConfiguration(this.configuration);
            PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder(this.configuration);
            this.configureFileSystems(this.configuration, pluginManager);
            SecurityContext securityContext = this.installSecurityContext(this.configuration);
            ClusterEntrypointUtils.configureUncaughtExceptionHandler(this.configuration);
            securityContext.runSecured(() -> {
                this.runCluster(this.configuration, pluginManager);
                return null;
            });
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException(t, UndeclaredThrowableException.class);
            try {
                this.shutDownAsync(ApplicationStatus.FAILED, ShutdownBehaviour.GRACEFUL_SHUTDOWN, ExceptionUtils.stringifyException(strippedThrowable), false).get(INITIALIZATION_SHUTDOWN_TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                strippedThrowable.addSuppressed(e);
            }
            throw new ClusterEntrypointException(String.format("Failed to initialize the cluster entrypoint %s.", this.getClass().getSimpleName()), strippedThrowable);
        }
    }

    protected boolean supportsReactiveMode() {
        return false;
    }

    private void configureFileSystems(Configuration configuration, PluginManager pluginManager) {
        LOG.info("Install default filesystem.");
        FileSystem.initialize(configuration, pluginManager);
    }

    private SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        LOG.info("Install security context.");
        SecurityUtils.install(new SecurityConfiguration(configuration));
        return SecurityUtils.getInstalledContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCluster(Configuration configuration, PluginManager pluginManager) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.initializeServices(configuration, pluginManager);
            configuration.setString(JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger(JobManagerOptions.PORT, this.commonRpcService.getPort());
            DispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory(configuration);
            this.clusterComponent = dispatcherResourceManagerComponentFactory.create(configuration, this.resourceId.unwrap(), this.ioExecutor, this.commonRpcService, this.haServices, this.blobServer, this.heartbeatServices, this.delegationTokenManager, this.metricRegistry, this.executionGraphInfoStore, new RpcMetricQueryServiceRetriever(this.metricRegistry.getMetricQueryServiceRpcService()), this);
            this.clusterComponent.getShutDownFuture().whenComplete((applicationStatus, throwable) -> {
                if (throwable != null) {
                    this.shutDownAsync(ApplicationStatus.UNKNOWN, ShutdownBehaviour.GRACEFUL_SHUTDOWN, ExceptionUtils.stringifyException(throwable), false);
                } else {
                    this.shutDownAsync((ApplicationStatus)((Object)applicationStatus), ShutdownBehaviour.GRACEFUL_SHUTDOWN, null, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeServices(Configuration configuration, PluginManager pluginManager) throws Exception {
        LOG.info("Initializing cluster services.");
        Object object = this.lock;
        synchronized (object) {
            this.resourceId = configuration.getOptional(JobManagerOptions.JOB_MANAGER_RESOURCE_ID).map(value -> DeterminismEnvelope.deterministicValue(new ResourceID((String)value))).orElseGet(() -> DeterminismEnvelope.nondeterministicValue(ResourceID.generate()));
            LOG.debug("Initialize cluster entrypoint {} with resource id {}.", (Object)this.getClass().getSimpleName(), this.resourceId);
            this.workingDirectory = ClusterEntrypointUtils.createJobManagerWorkingDirectory(configuration, this.resourceId);
            LOG.info("Using working directory: {}.", this.workingDirectory);
            this.rpcSystem = RpcSystem.load((Configuration)configuration);
            this.commonRpcService = RpcUtils.createRemoteRpcService((RpcSystem)this.rpcSystem, (Configuration)configuration, (String)configuration.getString(JobManagerOptions.ADDRESS), (String)this.getRPCPortRange(configuration), (String)configuration.getString(JobManagerOptions.BIND_HOST), configuration.getOptional(JobManagerOptions.RPC_BIND_PORT));
            JMXService.startInstance(configuration.getString(JMXServerOptions.JMX_SERVER_PORT));
            configuration.setString(JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger(JobManagerOptions.PORT, this.commonRpcService.getPort());
            this.ioExecutor = Executors.newFixedThreadPool(ClusterEntrypointUtils.getPoolSize(configuration), new ExecutorThreadFactory("cluster-io"));
            this.haServices = this.createHaServices(configuration, this.ioExecutor, (RpcSystemUtils)this.rpcSystem);
            this.blobServer = BlobUtils.createBlobServer(configuration, Reference.borrowed(this.workingDirectory.unwrap().getBlobStorageDirectory()), this.haServices.createBlobStore());
            this.blobServer.start();
            configuration.setString(BlobServerOptions.PORT, String.valueOf(this.blobServer.getPort()));
            this.heartbeatServices = this.createHeartbeatServices(configuration);
            this.delegationTokenManager = KerberosDelegationTokenManagerFactory.create(this.getClass().getClassLoader(), configuration, this.commonRpcService.getScheduledExecutor(), this.ioExecutor);
            this.metricRegistry = this.createMetricRegistry(configuration, pluginManager, (RpcSystemUtils)this.rpcSystem);
            RpcService metricQueryServiceRpcService = MetricUtils.startRemoteMetricsRpcService(configuration, this.commonRpcService.getAddress(), configuration.getString(JobManagerOptions.BIND_HOST), this.rpcSystem);
            this.metricRegistry.startQueryService(metricQueryServiceRpcService, null);
            String hostname = RpcUtils.getHostname((RpcService)this.commonRpcService);
            this.processMetricGroup = MetricUtils.instantiateProcessMetricGroup(this.metricRegistry, hostname, ConfigurationUtils.getSystemResourceMetricsProbingInterval(configuration));
            this.executionGraphInfoStore = this.createSerializableExecutionGraphStore(configuration, this.commonRpcService.getScheduledExecutor());
        }
    }

    protected String getRPCPortRange(Configuration configuration) {
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            return configuration.getString(HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE);
        }
        return String.valueOf(configuration.getInteger(JobManagerOptions.PORT));
    }

    protected HighAvailabilityServices createHaServices(Configuration configuration, Executor executor, RpcSystemUtils rpcSystemUtils) throws Exception {
        return HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, executor, AddressResolution.NO_ADDRESS_RESOLUTION, rpcSystemUtils, this);
    }

    protected HeartbeatServices createHeartbeatServices(Configuration configuration) {
        return HeartbeatServices.fromConfiguration(configuration);
    }

    protected MetricRegistryImpl createMetricRegistry(Configuration configuration, PluginManager pluginManager, RpcSystemUtils rpcSystemUtils) {
        return new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration, rpcSystemUtils.getMaximumMessageSizeInBytes(configuration)), ReporterSetup.fromConfiguration(configuration, pluginManager));
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        ShutdownHookUtil.removeShutdownHook(this.shutDownHook, this.getClass().getSimpleName(), LOG);
        return this.shutDownAsync(ApplicationStatus.UNKNOWN, ShutdownBehaviour.PROCESS_FAILURE, "Cluster entrypoint has been closed externally.", false).thenAccept(ignored -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> stopClusterServices(boolean cleanupHaData) {
        long shutdownTimeout = this.configuration.getLong(ClusterOptions.CLUSTER_SERVICES_SHUTDOWN_TIMEOUT);
        Object object = this.lock;
        synchronized (object) {
            Throwable exception = null;
            ArrayList terminationFutures = new ArrayList(3);
            if (this.blobServer != null) {
                try {
                    this.blobServer.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed(t, exception);
                }
            }
            if (this.haServices != null) {
                try {
                    if (cleanupHaData) {
                        this.haServices.closeAndCleanupAllData();
                    } else {
                        this.haServices.close();
                    }
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed(t, exception);
                }
            }
            if (this.executionGraphInfoStore != null) {
                try {
                    this.executionGraphInfoStore.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed(t, exception);
                }
            }
            if (this.processMetricGroup != null) {
                this.processMetricGroup.close();
            }
            if (this.metricRegistry != null) {
                terminationFutures.add(this.metricRegistry.shutdown());
            }
            if (this.ioExecutor != null) {
                terminationFutures.add(ExecutorUtils.nonBlockingShutdown(shutdownTimeout, TimeUnit.MILLISECONDS, this.ioExecutor));
            }
            if (this.commonRpcService != null) {
                terminationFutures.add(this.commonRpcService.stopService());
            }
            try {
                JMXService.stopInstance();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed(t, exception);
            }
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally(exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    public void onFatalError(Throwable exception) {
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError(exception);
        LOG.error("Fatal error occurred in the cluster entrypoint.", exception);
        FlinkSecurityManager.forceProcessExit(2);
    }

    private Configuration generateClusterConfiguration(Configuration configuration) {
        Configuration resultConfiguration = new Configuration(Preconditions.checkNotNull(configuration));
        String webTmpDir = configuration.getString(WebOptions.TMP_DIR);
        File uniqueWebTmpDir = new File(webTmpDir, "flink-web-" + UUID.randomUUID());
        resultConfiguration.setString(WebOptions.TMP_DIR, uniqueWebTmpDir.getAbsolutePath());
        return resultConfiguration;
    }

    private CompletableFuture<ApplicationStatus> shutDownAsync(ApplicationStatus applicationStatus, ShutdownBehaviour shutdownBehaviour, @Nullable String diagnostics, boolean cleanupHaData) {
        if (this.isShutDown.compareAndSet(false, true)) {
            LOG.info("Shutting {} down with application status {}. Diagnostics {}.", new Object[]{this.getClass().getSimpleName(), applicationStatus, diagnostics});
            CompletableFuture<Void> shutDownApplicationFuture = this.closeClusterComponent(applicationStatus, shutdownBehaviour, diagnostics);
            CompletableFuture<Void> serviceShutdownFuture = FutureUtils.composeAfterwards(shutDownApplicationFuture, () -> this.stopClusterServices(cleanupHaData));
            CompletableFuture<Void> rpcSystemClassLoaderCloseFuture = FutureUtils.runAfterwards(serviceShutdownFuture, () -> ((RpcSystem)this.rpcSystem).close());
            CompletableFuture<Void> cleanupDirectoriesFuture = FutureUtils.runAfterwards(rpcSystemClassLoaderCloseFuture, () -> this.cleanupDirectories(shutdownBehaviour));
            cleanupDirectoriesFuture.whenComplete((ignored2, serviceThrowable) -> {
                if (serviceThrowable != null) {
                    this.terminationFuture.completeExceptionally((Throwable)serviceThrowable);
                } else {
                    this.terminationFuture.complete(applicationStatus);
                }
            });
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeClusterComponent(ApplicationStatus applicationStatus, ShutdownBehaviour shutdownBehaviour, @Nullable String diagnostics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.clusterComponent != null) {
                switch (shutdownBehaviour) {
                    case GRACEFUL_SHUTDOWN: {
                        return this.clusterComponent.stopApplication(applicationStatus, diagnostics);
                    }
                }
                return this.clusterComponent.stopProcess();
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDirectories(ShutdownBehaviour shutdownBehaviour) throws IOException {
        IOException ioException = null;
        String webTmpDir = this.configuration.getString(WebOptions.TMP_DIR);
        try {
            FileUtils.deleteDirectory(new File(webTmpDir));
        }
        catch (IOException ioe) {
            ioException = ioe;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!(this.workingDirectory == null || this.workingDirectory.isDeterministic() && shutdownBehaviour != ShutdownBehaviour.GRACEFUL_SHUTDOWN)) {
                try {
                    this.workingDirectory.unwrap().delete();
                }
                catch (IOException ioe) {
                    ioException = ExceptionUtils.firstOrSuppressed(ioe, ioException);
                }
            }
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    protected abstract DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration var1) throws IOException;

    protected abstract ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration var1, ScheduledExecutor var2) throws IOException;

    public static EntrypointClusterConfiguration parseArguments(String[] args) throws FlinkParseException {
        CommandLineParser<EntrypointClusterConfiguration> clusterConfigurationParser = new CommandLineParser<EntrypointClusterConfiguration>(new EntrypointClusterConfigurationParserFactory());
        return clusterConfigurationParser.parse(args);
    }

    protected static Configuration loadConfiguration(EntrypointClusterConfiguration entrypointClusterConfiguration) {
        String hostname;
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration(entrypointClusterConfiguration.getDynamicProperties());
        Configuration configuration = GlobalConfiguration.loadConfiguration(entrypointClusterConfiguration.getConfigDir(), dynamicProperties);
        int restPort = entrypointClusterConfiguration.getRestPort();
        if (restPort >= 0) {
            LOG.warn("The 'webui-port' parameter of 'jobmanager.sh' has been deprecated. Please use '-D {}=<port> instead.", RestOptions.PORT);
            configuration.setInteger(RestOptions.PORT, restPort);
        }
        if ((hostname = entrypointClusterConfiguration.getHostname()) != null) {
            LOG.warn("The 'host' parameter of 'jobmanager.sh' has been deprecated. Please use '-D {}=<host> instead.", JobManagerOptions.ADDRESS);
            configuration.setString(JobManagerOptions.ADDRESS, hostname);
        }
        return configuration;
    }

    public static void runClusterEntrypoint(ClusterEntrypoint clusterEntrypoint) {
        int returnCode;
        String clusterEntrypointName = clusterEntrypoint.getClass().getSimpleName();
        try {
            clusterEntrypoint.startCluster();
        }
        catch (ClusterEntrypointException e) {
            LOG.error(String.format("Could not start cluster entrypoint %s.", clusterEntrypointName), (Throwable)e);
            System.exit(1);
        }
        Throwable throwable = null;
        try {
            returnCode = clusterEntrypoint.getTerminationFuture().get().processExitCode();
        }
        catch (Throwable e) {
            throwable = ExceptionUtils.stripExecutionException(e);
            returnCode = 2;
        }
        LOG.info("Terminating cluster entrypoint process {} with exit code {}.", new Object[]{clusterEntrypointName, returnCode, throwable});
        System.exit(returnCode);
    }

    protected static enum ShutdownBehaviour {
        GRACEFUL_SHUTDOWN,
        PROCESS_FAILURE;

    }

    public static enum ExecutionMode {
        NORMAL,
        DETACHED;

    }
}

