/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.types.logical.RowType;

public class RowDataType
extends DataType {
    private static final long serialVersionUID = 1L;
    private final List<DataField> fields;

    public RowDataType(List<DataField> fields) {
        this(true, fields);
    }

    public RowDataType(boolean isNullable, List<DataField> fields) {
        super(RowDataType.toRowType(isNullable, fields));
        this.fields = fields;
    }

    public static RowType toRowType(boolean isNullable, List<DataField> fields) {
        ArrayList<RowType.RowField> typeFields = new ArrayList<RowType.RowField>(fields.size());
        for (DataField field : fields) {
            typeFields.add(new RowType.RowField(field.name(), field.type().logicalType, field.description()));
        }
        return new RowType(isNullable, typeFields);
    }

    public List<DataField> fields() {
        return this.fields;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new RowDataType(isNullable, this.fields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowDataType that = (RowDataType)o;
        return Objects.equals(this.fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

