/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;
import org.apache.flink.streaming.runtime.io.checkpointing.WaitingForFirstBarrier;
import org.apache.flink.util.Preconditions;

abstract class AbstractAlignedBarrierHandlerState
implements BarrierHandlerState {
    protected final ChannelState state;

    protected AbstractAlignedBarrierHandlerState(ChannelState state) {
        this.state = state;
    }

    @Override
    public final BarrierHandlerState alignmentTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) throws IOException, CheckpointException {
        throw new IllegalStateException("Alignment should not be timed out if we are not alternating.");
    }

    @Override
    public final BarrierHandlerState announcementReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, int sequenceNumber) {
        return this;
    }

    @Override
    public final BarrierHandlerState barrierReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, CheckpointBarrier checkpointBarrier, boolean markChannelBlocked) throws IOException, CheckpointException {
        Preconditions.checkState(!checkpointBarrier.getCheckpointOptions().isUnalignedCheckpoint());
        if (markChannelBlocked) {
            this.state.blockChannel(channelInfo);
        }
        if (controller.allBarriersReceived()) {
            return this.triggerGlobalCheckpoint(controller, checkpointBarrier);
        }
        return this.convertAfterBarrierReceived(this.state);
    }

    protected WaitingForFirstBarrier triggerGlobalCheckpoint(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) throws IOException {
        controller.triggerGlobalCheckpoint(checkpointBarrier);
        this.state.unblockAllChannels();
        return new WaitingForFirstBarrier(this.state.getInputs());
    }

    protected abstract BarrierHandlerState convertAfterBarrierReceived(ChannelState var1);

    @Override
    public final BarrierHandlerState abort(long cancelledId) throws IOException {
        this.state.unblockAllChannels();
        return new WaitingForFirstBarrier(this.state.getInputs());
    }
}

