/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.MetricGroup;

public interface StateTimeMetric {
    public long getCurrentTime();

    public long getTotalTime();

    public long getBinary();

    public static void register(MetricOptions.JobStatusMetricsSettings jobStatusMetricsSettings, MetricGroup metricGroup, StateTimeMetric stateTimeMetric, String baseName) {
        if (jobStatusMetricsSettings.isStateMetricsEnabled()) {
            metricGroup.gauge(StateTimeMetric.getStateMetricName(baseName), stateTimeMetric::getBinary);
        }
        if (jobStatusMetricsSettings.isCurrentTimeMetricsEnabled()) {
            metricGroup.gauge(StateTimeMetric.getCurrentTimeMetricName(baseName), stateTimeMetric::getCurrentTime);
        }
        if (jobStatusMetricsSettings.isTotalTimeMetricsEnabled()) {
            metricGroup.gauge(StateTimeMetric.getTotalTimeMetricName(baseName), stateTimeMetric::getTotalTime);
        }
    }

    @VisibleForTesting
    public static String getStateMetricName(String baseName) {
        return baseName + "State";
    }

    @VisibleForTesting
    public static String getCurrentTimeMetricName(String baseName) {
        return baseName + "Time";
    }

    @VisibleForTesting
    public static String getTotalTimeMetricName(String baseName) {
        return baseName + "TimeTotal";
    }
}

