/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.stream.AbstractStreamingWriter;
import org.apache.flink.connector.file.table.stream.PartitionCommitInfo;
import org.apache.flink.connector.file.table.stream.PartitionCommitPredicate;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamingFileWriter<IN>
extends AbstractStreamingWriter<IN, PartitionCommitInfo> {
    private static final long serialVersionUID = 2L;
    private final List<String> partitionKeys;
    private final Configuration conf;
    private transient Set<String> currentNewPartitions;
    private transient TreeMap<Long, Set<String>> newPartitions;
    private transient Set<String> committablePartitions;
    private transient Map<String, Long> inProgressPartitions;
    private transient PartitionCommitPredicate partitionCommitPredicate;

    public StreamingFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder, List<String> partitionKeys, Configuration conf) {
        super(bucketCheckInterval, bucketsBuilder);
        this.partitionKeys = partitionKeys;
        this.conf = conf;
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        if (this.isPartitionCommitTriggerEnabled()) {
            this.partitionCommitPredicate = PartitionCommitPredicate.create(this.conf, this.getUserCodeClassloader(), this.partitionKeys);
        }
        this.currentNewPartitions = new HashSet<String>();
        this.newPartitions = new TreeMap();
        this.committablePartitions = new HashSet<String>();
        this.inProgressPartitions = new HashMap<String, Long>();
        super.initializeState(context);
    }

    @Override
    protected void partitionCreated(String partition) {
        this.currentNewPartitions.add(partition);
        this.inProgressPartitions.putIfAbsent(partition, this.getProcessingTimeService().getCurrentProcessingTime());
    }

    @Override
    protected void partitionInactive(String partition) {
        this.committablePartitions.add(partition);
        this.inProgressPartitions.remove(partition);
    }

    @Override
    protected void onPartFileOpened(String s, Path newPath) {
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        this.closePartFileForPartitions();
        super.snapshotState(context);
        this.newPartitions.put(context.getCheckpointId(), new HashSet<String>(this.currentNewPartitions));
        this.currentNewPartitions.clear();
    }

    private boolean isPartitionCommitTriggerEnabled() {
        return this.partitionKeys.size() > 0 && this.conf.contains(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND);
    }

    private void closePartFileForPartitions() throws Exception {
        if (this.partitionCommitPredicate != null) {
            Iterator<Map.Entry<String, Long>> iterator = this.inProgressPartitions.entrySet().iterator();
            while (iterator.hasNext()) {
                Long creationTime;
                Map.Entry<String, Long> entry = iterator.next();
                String partition = entry.getKey();
                PartitionCommitPredicate.PredicateContext predicateContext = PartitionCommitPredicate.createPredicateContext(partition, creationTime = entry.getValue(), this.processingTimeService.getCurrentProcessingTime(), this.currentWatermark);
                if (!this.partitionCommitPredicate.isPartitionCommittable(predicateContext)) continue;
                this.buckets.closePartFileForBucket(partition);
                iterator.remove();
            }
        }
    }

    @Override
    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        super.commitUpToCheckpoint(checkpointId);
        NavigableMap<Long, Set<String>> headPartitions = this.newPartitions.headMap(checkpointId, true);
        HashSet<String> partitions = new HashSet<String>(this.committablePartitions);
        this.committablePartitions.clear();
        headPartitions.values().forEach(partitions::addAll);
        headPartitions.clear();
        this.output.collect(new StreamRecord<PartitionCommitInfo>(new PartitionCommitInfo(checkpointId, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks(), new ArrayList<String>(partitions))));
    }
}

