/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

@Internal
public final class LogicalTypeMerging {
    private static final Map<YearMonthIntervalType.YearMonthResolution, List<YearMonthIntervalType.YearMonthResolution>> YEAR_MONTH_RES_TO_BOUNDARIES = new HashMap<YearMonthIntervalType.YearMonthResolution, List<YearMonthIntervalType.YearMonthResolution>>();
    private static final Map<List<YearMonthIntervalType.YearMonthResolution>, YearMonthIntervalType.YearMonthResolution> YEAR_MONTH_BOUNDARIES_TO_RES = new HashMap<List<YearMonthIntervalType.YearMonthResolution>, YearMonthIntervalType.YearMonthResolution>();
    private static final int MINIMUM_ADJUSTED_SCALE = 6;
    private static final Map<DayTimeIntervalType.DayTimeResolution, List<DayTimeIntervalType.DayTimeResolution>> DAY_TIME_RES_TO_BOUNDARIES;
    private static final Map<List<DayTimeIntervalType.DayTimeResolution>, DayTimeIntervalType.DayTimeResolution> DAY_TIME_BOUNDARIES_TO_RES;

    private static void addYearMonthMapping(YearMonthIntervalType.YearMonthResolution to, YearMonthIntervalType.YearMonthResolution ... boundaries) {
        List<YearMonthIntervalType.YearMonthResolution> boundariesList = Arrays.asList(boundaries);
        YEAR_MONTH_RES_TO_BOUNDARIES.put(to, boundariesList);
        YEAR_MONTH_BOUNDARIES_TO_RES.put(boundariesList, to);
    }

    private static void addDayTimeMapping(DayTimeIntervalType.DayTimeResolution to, DayTimeIntervalType.DayTimeResolution ... boundaries) {
        List<DayTimeIntervalType.DayTimeResolution> boundariesList = Arrays.asList(boundaries);
        DAY_TIME_RES_TO_BOUNDARIES.put(to, boundariesList);
        DAY_TIME_BOUNDARIES_TO_RES.put(boundariesList, to);
    }

    public static Optional<LogicalType> findCommonType(List<LogicalType> types) {
        Preconditions.checkArgument(types.size() > 0, "List of types must not be empty.");
        boolean hasRawType = false;
        boolean hasNullType = false;
        boolean hasNullableTypes = false;
        for (LogicalType type : types) {
            LogicalTypeRoot typeRoot = type.getTypeRoot();
            if (typeRoot == LogicalTypeRoot.RAW) {
                hasRawType = true;
            } else if (typeRoot == LogicalTypeRoot.NULL) {
                hasNullType = true;
            }
            if (!type.isNullable()) continue;
            hasNullableTypes = true;
        }
        List<LogicalType> normalizedTypes = types.stream().map(t -> t.copy(true)).collect(Collectors.toList());
        LogicalType foundType = LogicalTypeMerging.findCommonNullableType(normalizedTypes, hasRawType, hasNullType);
        if (foundType == null) {
            foundType = LogicalTypeMerging.findCommonCastableType(normalizedTypes);
        }
        if (foundType != null) {
            LogicalType typeWithNullability = foundType.copy(hasNullableTypes);
            if (typeWithNullability.is(LogicalTypeRoot.NULL)) {
                return Optional.empty();
            }
            return Optional.of(typeWithNullability);
        }
        return Optional.empty();
    }

    public static DecimalType findDivisionDecimalType(int precision1, int scale1, int precision2, int scale2) {
        int scale = Math.max(6, scale1 + precision2 + 1);
        int precision = precision1 - scale1 + scale2 + scale;
        return LogicalTypeMerging.adjustPrecisionScale(precision, scale);
    }

    public static DecimalType findModuloDecimalType(int precision1, int scale1, int precision2, int scale2) {
        int scale = Math.max(scale1, scale2);
        int precision = Math.min(precision1 - scale1, precision2 - scale2) + scale;
        return LogicalTypeMerging.adjustPrecisionScale(precision, scale);
    }

    public static DecimalType findMultiplicationDecimalType(int precision1, int scale1, int precision2, int scale2) {
        int scale = scale1 + scale2;
        int precision = precision1 + precision2 + 1;
        return LogicalTypeMerging.adjustPrecisionScale(precision, scale);
    }

    public static DecimalType findAdditionDecimalType(int precision1, int scale1, int precision2, int scale2) {
        int scale = Math.max(scale1, scale2);
        int precision = Math.max(precision1 - scale1, precision2 - scale2) + scale + 1;
        return LogicalTypeMerging.adjustPrecisionScale(precision, scale);
    }

    public static DecimalType findRoundDecimalType(int precision, int scale, int round) {
        if (round >= scale) {
            return new DecimalType(false, precision, scale);
        }
        if (round < 0) {
            return new DecimalType(false, Math.min(38, 1 + precision - scale), 0);
        }
        return new DecimalType(false, 1 + precision - scale + round, round);
    }

    public static LogicalType findAvgAggType(LogicalType argType) {
        LogicalType resultType;
        if (argType.is(LogicalTypeRoot.DECIMAL)) {
            if (argType instanceof LegacyTypeInformationType) {
                return argType;
            }
            resultType = LogicalTypeMerging.findDivisionDecimalType(38, LogicalTypeChecks.getScale(argType), 20, 0);
        } else {
            resultType = argType;
        }
        return resultType.copy(argType.isNullable());
    }

    public static LogicalType findSumAggType(LogicalType argType) {
        LogicalType resultType;
        if (argType.is(LogicalTypeRoot.DECIMAL)) {
            if (argType instanceof LegacyTypeInformationType) {
                return argType;
            }
            resultType = new DecimalType(false, 38, LogicalTypeChecks.getScale(argType));
        } else {
            resultType = argType;
        }
        return resultType.copy(argType.isNullable());
    }

    private static DecimalType adjustPrecisionScale(int precision, int scale) {
        if (precision <= 38) {
            return new DecimalType(false, precision, scale);
        }
        int digitPart = precision - scale;
        int minScalePart = Math.min(scale, 6);
        int adjustScale = Math.max(38 - digitPart, minScalePart);
        return new DecimalType(false, 38, adjustScale);
    }

    @Nullable
    private static LogicalType findCommonCastableType(List<LogicalType> normalizedTypes) {
        LogicalType resultType = normalizedTypes.get(0);
        for (LogicalType type : normalizedTypes) {
            LogicalTypeRoot typeRoot = type.getTypeRoot();
            if (typeRoot == LogicalTypeRoot.NULL) continue;
            if (LogicalTypeCasts.supportsImplicitCast(resultType, type)) {
                resultType = type;
                continue;
            }
            if (LogicalTypeCasts.supportsImplicitCast(type, resultType)) continue;
            return null;
        }
        return resultType;
    }

    @Nullable
    private static LogicalType findCommonNullableType(List<LogicalType> normalizedTypes, boolean hasRawType, boolean hasNullType) {
        if (hasRawType) {
            return LogicalTypeMerging.findExactlySameType(normalizedTypes);
        }
        LogicalType resultType = null;
        for (LogicalType type : normalizedTypes) {
            LogicalType patternType;
            LogicalTypeRoot typeRoot = type.getTypeRoot();
            if (typeRoot == LogicalTypeRoot.NULL) continue;
            if (resultType == null) {
                resultType = type;
            }
            if ((patternType = LogicalTypeMerging.findCommonTypePattern(resultType, type)) != null) {
                resultType = patternType;
                continue;
            }
            if (typeRoot == LogicalTypeRoot.ARRAY) {
                return LogicalTypeMerging.findCommonArrayType(normalizedTypes);
            }
            if (typeRoot == LogicalTypeRoot.MULTISET) {
                return LogicalTypeMerging.findCommonMultisetType(normalizedTypes);
            }
            if (typeRoot == LogicalTypeRoot.MAP) {
                return LogicalTypeMerging.findCommonMapType(normalizedTypes);
            }
            if (typeRoot == LogicalTypeRoot.ROW) {
                return LogicalTypeMerging.findCommonRowType(normalizedTypes);
            }
            if (!LogicalTypeMerging.areSimilarTypes(resultType, type)) {
                return null;
            }
            if (type.is(LogicalTypeFamily.CHARACTER_STRING) | type.is(LogicalTypeFamily.BINARY_STRING)) {
                int length = LogicalTypeMerging.combineLength(resultType, type);
                if (resultType.isAnyOf(LogicalTypeRoot.VARCHAR, LogicalTypeRoot.VARBINARY)) {
                    resultType = LogicalTypeMerging.createStringType(resultType.getTypeRoot(), length);
                    continue;
                }
                if (LogicalTypeChecks.getLength(resultType) != LogicalTypeChecks.getLength(type)) {
                    if (resultType.is(LogicalTypeRoot.CHAR)) {
                        resultType = LogicalTypeMerging.createStringType(LogicalTypeRoot.VARCHAR, length);
                        continue;
                    }
                    if (!resultType.is(LogicalTypeRoot.BINARY)) continue;
                    resultType = LogicalTypeMerging.createStringType(LogicalTypeRoot.VARBINARY, length);
                    continue;
                }
                resultType = LogicalTypeMerging.createStringType(typeRoot, length);
                continue;
            }
            if (type.is(LogicalTypeFamily.EXACT_NUMERIC)) {
                if (resultType.is(LogicalTypeFamily.EXACT_NUMERIC)) {
                    resultType = LogicalTypeMerging.createCommonExactNumericType(resultType, type);
                    continue;
                }
                if (resultType.is(LogicalTypeFamily.APPROXIMATE_NUMERIC)) {
                    if (typeRoot != LogicalTypeRoot.DECIMAL) continue;
                    resultType = new DoubleType();
                    continue;
                }
                return null;
            }
            if (type.is(LogicalTypeFamily.APPROXIMATE_NUMERIC)) {
                if (resultType.is(LogicalTypeFamily.APPROXIMATE_NUMERIC)) {
                    resultType = LogicalTypeMerging.createCommonApproximateNumericType(resultType, type);
                    continue;
                }
                if (resultType.is(LogicalTypeFamily.EXACT_NUMERIC)) {
                    if (typeRoot == LogicalTypeRoot.DECIMAL) {
                        resultType = new DoubleType();
                        continue;
                    }
                    resultType = type;
                    continue;
                }
                return null;
            }
            if (type.is(LogicalTypeRoot.DATE)) {
                if (resultType.is(LogicalTypeRoot.DATE)) {
                    resultType = new DateType();
                    continue;
                }
                return null;
            }
            if (type.is(LogicalTypeFamily.TIME)) {
                if (resultType.is(LogicalTypeFamily.TIME)) {
                    resultType = new TimeType(LogicalTypeMerging.combinePrecision(resultType, type));
                    continue;
                }
                return null;
            }
            if (type.is(LogicalTypeFamily.TIMESTAMP)) {
                if (resultType.is(LogicalTypeFamily.TIMESTAMP)) {
                    resultType = LogicalTypeMerging.createCommonTimestampType(resultType, type);
                    continue;
                }
                return null;
            }
            if (typeRoot == LogicalTypeRoot.INTERVAL_DAY_TIME) {
                resultType = LogicalTypeMerging.createCommonDayTimeIntervalType((DayTimeIntervalType)resultType, (DayTimeIntervalType)type);
                continue;
            }
            if (typeRoot == LogicalTypeRoot.INTERVAL_YEAR_MONTH) {
                resultType = LogicalTypeMerging.createCommonYearMonthIntervalType((YearMonthIntervalType)resultType, (YearMonthIntervalType)type);
                continue;
            }
            return null;
        }
        if (resultType == null && hasNullType) {
            return new NullType();
        }
        return resultType;
    }

    private static boolean areSimilarTypes(LogicalType left, LogicalType right) {
        if (left.is(LogicalTypeFamily.CHARACTER_STRING) && right.is(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        if (left.is(LogicalTypeFamily.BINARY_STRING) && right.is(LogicalTypeFamily.BINARY_STRING)) {
            return true;
        }
        if (left.is(LogicalTypeFamily.NUMERIC) && right.is(LogicalTypeFamily.NUMERIC)) {
            return true;
        }
        if (left.is(LogicalTypeFamily.TIME) && right.is(LogicalTypeFamily.TIME)) {
            return true;
        }
        if (left.is(LogicalTypeFamily.TIMESTAMP) && right.is(LogicalTypeFamily.TIMESTAMP)) {
            return true;
        }
        return left.getTypeRoot() == right.getTypeRoot();
    }

    @Nullable
    private static LogicalType findExactlySameType(List<LogicalType> normalizedTypes) {
        LogicalType firstType = normalizedTypes.get(0);
        for (LogicalType type : normalizedTypes) {
            if (type.equals(firstType)) continue;
            return null;
        }
        return firstType;
    }

    @Nullable
    private static LogicalType findCommonTypePattern(LogicalType resultType, LogicalType type) {
        if (resultType.is(LogicalTypeFamily.DATETIME) && type.is(LogicalTypeFamily.INTERVAL)) {
            return resultType;
        }
        if (resultType.is(LogicalTypeFamily.INTERVAL) && type.is(LogicalTypeFamily.DATETIME)) {
            return type;
        }
        if ((resultType.is(LogicalTypeFamily.TIMESTAMP) || resultType.is(LogicalTypeRoot.DATE)) && type.is(LogicalTypeFamily.EXACT_NUMERIC)) {
            return resultType;
        }
        if (resultType.is(LogicalTypeFamily.EXACT_NUMERIC) && (type.is(LogicalTypeFamily.TIMESTAMP) || type.is(LogicalTypeRoot.DATE))) {
            return type;
        }
        return null;
    }

    @Nullable
    private static LogicalType findCommonArrayType(List<LogicalType> normalizedTypes) {
        List<LogicalType> children = LogicalTypeMerging.findCommonChildrenTypes(normalizedTypes);
        if (children == null) {
            return null;
        }
        return new ArrayType(children.get(0));
    }

    @Nullable
    private static LogicalType findCommonMultisetType(List<LogicalType> normalizedTypes) {
        List<LogicalType> children = LogicalTypeMerging.findCommonChildrenTypes(normalizedTypes);
        if (children == null) {
            return null;
        }
        return new MultisetType(children.get(0));
    }

    @Nullable
    private static LogicalType findCommonMapType(List<LogicalType> normalizedTypes) {
        List<LogicalType> children = LogicalTypeMerging.findCommonChildrenTypes(normalizedTypes);
        if (children == null) {
            return null;
        }
        return new MapType(children.get(0), children.get(1));
    }

    @Nullable
    private static LogicalType findCommonRowType(List<LogicalType> normalizedTypes) {
        List<LogicalType> children = LogicalTypeMerging.findCommonChildrenTypes(normalizedTypes);
        if (children == null) {
            return null;
        }
        RowType firstType = (RowType)normalizedTypes.get(0);
        List<RowType.RowField> newFields = IntStream.range(0, children.size()).mapToObj(pos -> {
            LogicalType newType = (LogicalType)children.get(pos);
            RowType.RowField originalField = firstType.getFields().get(pos);
            if (originalField.getDescription().isPresent()) {
                return new RowType.RowField(originalField.getName(), newType, originalField.getDescription().get());
            }
            return new RowType.RowField(originalField.getName(), newType);
        }).collect(Collectors.toList());
        return new RowType(newFields);
    }

    @Nullable
    private static List<LogicalType> findCommonChildrenTypes(List<LogicalType> normalizedTypes) {
        LogicalType firstType = normalizedTypes.get(0);
        LogicalTypeRoot typeRoot = firstType.getTypeRoot();
        int numberOfChildren = firstType.getChildren().size();
        for (LogicalType type : normalizedTypes) {
            if (type.getTypeRoot() != typeRoot) {
                return null;
            }
            if (type.getChildren().size() == numberOfChildren) continue;
            return null;
        }
        ArrayList<LogicalType> resultChildren = new ArrayList<LogicalType>(numberOfChildren);
        for (int i = 0; i < numberOfChildren; ++i) {
            Optional<LogicalType> childType = LogicalTypeMerging.findCommonType(new ChildTypeView(normalizedTypes, i));
            if (!childType.isPresent()) {
                return null;
            }
            resultChildren.add(childType.get());
        }
        return resultChildren;
    }

    private static LogicalType createCommonExactNumericType(LogicalType resultType, LogicalType type) {
        if (type.equals(resultType)) {
            return resultType;
        }
        LogicalTypeRoot resultTypeRoot = resultType.getTypeRoot();
        LogicalTypeRoot typeRoot = type.getTypeRoot();
        if (resultTypeRoot != LogicalTypeRoot.DECIMAL && typeRoot != LogicalTypeRoot.DECIMAL) {
            if (LogicalTypeChecks.getPrecision(type) > LogicalTypeChecks.getPrecision(resultType)) {
                return type;
            }
            return resultType;
        }
        int p1 = LogicalTypeChecks.getPrecision(resultType);
        int p2 = LogicalTypeChecks.getPrecision(type);
        int s1 = LogicalTypeChecks.getScale(resultType);
        int s2 = LogicalTypeChecks.getScale(type);
        int maxPrecision = 38;
        int d = Math.max(p1 - s1, p2 - s2);
        d = Math.min(d, 38);
        int s = Math.max(s1, s2);
        s = Math.min(s, 38 - d);
        int p = d + s;
        return new DecimalType(p, s);
    }

    private static LogicalType createCommonApproximateNumericType(LogicalType resultType, LogicalType type) {
        if (resultType.is(LogicalTypeRoot.DOUBLE) || type.is(LogicalTypeRoot.DOUBLE)) {
            return new DoubleType();
        }
        return resultType;
    }

    private static LogicalType createCommonTimestampType(LogicalType resultType, LogicalType type) {
        if (type.equals(resultType)) {
            return resultType;
        }
        LogicalTypeRoot resultTypeRoot = resultType.getTypeRoot();
        LogicalTypeRoot typeRoot = type.getTypeRoot();
        int precision = LogicalTypeMerging.combinePrecision(resultType, type);
        if (typeRoot == resultTypeRoot) {
            return LogicalTypeMerging.createTimestampType(resultTypeRoot, precision);
        }
        if (typeRoot == LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE || resultTypeRoot == LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE) {
            return LogicalTypeMerging.createTimestampType(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, precision);
        }
        if (typeRoot == LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE || resultTypeRoot == LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return LogicalTypeMerging.createTimestampType(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, precision);
        }
        return LogicalTypeMerging.createTimestampType(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, precision);
    }

    private static LogicalType createCommonDayTimeIntervalType(DayTimeIntervalType resultType, DayTimeIntervalType type) {
        int maxDayPrecision = Math.max(resultType.getDayPrecision(), type.getDayPrecision());
        int maxFractionalPrecision = Math.max(resultType.getFractionalPrecision(), type.getFractionalPrecision());
        return new DayTimeIntervalType((DayTimeIntervalType.DayTimeResolution)LogicalTypeMerging.combineIntervalResolutions((Enum[])DayTimeIntervalType.DayTimeResolution.values(), DAY_TIME_RES_TO_BOUNDARIES, DAY_TIME_BOUNDARIES_TO_RES, (Enum)resultType.getResolution(), (Enum)type.getResolution()), maxDayPrecision, maxFractionalPrecision);
    }

    private static LogicalType createCommonYearMonthIntervalType(YearMonthIntervalType resultType, YearMonthIntervalType type) {
        int maxYearPrecision = Math.max(resultType.getYearPrecision(), type.getYearPrecision());
        return new YearMonthIntervalType((YearMonthIntervalType.YearMonthResolution)LogicalTypeMerging.combineIntervalResolutions((Enum[])YearMonthIntervalType.YearMonthResolution.values(), YEAR_MONTH_RES_TO_BOUNDARIES, YEAR_MONTH_BOUNDARIES_TO_RES, (Enum)resultType.getResolution(), (Enum)type.getResolution()), maxYearPrecision);
    }

    private static LogicalType createTimestampType(LogicalTypeRoot typeRoot, int precision) {
        switch (typeRoot) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new TimestampType(precision);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return new ZonedTimestampType(precision);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new LocalZonedTimestampType(precision);
            }
        }
        throw new IllegalArgumentException();
    }

    private static LogicalType createStringType(LogicalTypeRoot typeRoot, int length) {
        switch (typeRoot) {
            case CHAR: {
                if (length == 0) {
                    return CharType.ofEmptyLiteral();
                }
                return new CharType(length);
            }
            case VARCHAR: {
                if (length == 0) {
                    return VarCharType.ofEmptyLiteral();
                }
                return new VarCharType(length);
            }
            case BINARY: {
                if (length == 0) {
                    return BinaryType.ofEmptyLiteral();
                }
                return new BinaryType(length);
            }
            case VARBINARY: {
                if (length == 0) {
                    return VarBinaryType.ofEmptyLiteral();
                }
                return new VarBinaryType(length);
            }
        }
        throw new IllegalArgumentException();
    }

    private static <T extends Enum<T>> T combineIntervalResolutions(T[] res, Map<T, List<T>> resToBoundaries, Map<List<T>, T> boundariesToRes, T left, T right) {
        T combinedEnd;
        List<T> leftBoundaries = resToBoundaries.get(left);
        Enum leftStart = (Enum)leftBoundaries.get(0);
        Enum leftEnd = (Enum)leftBoundaries.get(leftBoundaries.size() - 1);
        List<T> rightBoundaries = resToBoundaries.get(right);
        Enum rightStart = (Enum)rightBoundaries.get(0);
        Enum rightEnd = (Enum)rightBoundaries.get(rightBoundaries.size() - 1);
        T combinedStart = res[Math.min(leftStart.ordinal(), rightStart.ordinal())];
        if (combinedStart == (combinedEnd = res[Math.max(leftEnd.ordinal(), rightEnd.ordinal())])) {
            return (T)((Enum)boundariesToRes.get(Collections.singletonList(combinedStart)));
        }
        return (T)((Enum)boundariesToRes.get(Arrays.asList(combinedStart, combinedEnd)));
    }

    private static int combinePrecision(LogicalType resultType, LogicalType type) {
        int p1 = LogicalTypeChecks.getPrecision(resultType);
        int p2 = LogicalTypeChecks.getPrecision(type);
        return Math.max(p1, p2);
    }

    private static int combineLength(LogicalType resultType, LogicalType right) {
        return Math.max(LogicalTypeChecks.getLength(resultType), LogicalTypeChecks.getLength(right));
    }

    private LogicalTypeMerging() {
    }

    static {
        LogicalTypeMerging.addYearMonthMapping(YearMonthIntervalType.YearMonthResolution.YEAR, YearMonthIntervalType.YearMonthResolution.YEAR);
        LogicalTypeMerging.addYearMonthMapping(YearMonthIntervalType.YearMonthResolution.MONTH, YearMonthIntervalType.YearMonthResolution.MONTH);
        LogicalTypeMerging.addYearMonthMapping(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, YearMonthIntervalType.YearMonthResolution.YEAR, YearMonthIntervalType.YearMonthResolution.MONTH);
        DAY_TIME_RES_TO_BOUNDARIES = new HashMap<DayTimeIntervalType.DayTimeResolution, List<DayTimeIntervalType.DayTimeResolution>>();
        DAY_TIME_BOUNDARIES_TO_RES = new HashMap<List<DayTimeIntervalType.DayTimeResolution>, DayTimeIntervalType.DayTimeResolution>();
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.DAY, DayTimeIntervalType.DayTimeResolution.DAY);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, DayTimeIntervalType.DayTimeResolution.DAY, DayTimeIntervalType.DayTimeResolution.HOUR);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE, DayTimeIntervalType.DayTimeResolution.DAY, DayTimeIntervalType.DayTimeResolution.MINUTE);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, DayTimeIntervalType.DayTimeResolution.DAY, DayTimeIntervalType.DayTimeResolution.SECOND);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.HOUR, DayTimeIntervalType.DayTimeResolution.HOUR);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.HOUR_TO_MINUTE, DayTimeIntervalType.DayTimeResolution.HOUR, DayTimeIntervalType.DayTimeResolution.MINUTE);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, DayTimeIntervalType.DayTimeResolution.HOUR, DayTimeIntervalType.DayTimeResolution.SECOND);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.MINUTE, DayTimeIntervalType.DayTimeResolution.MINUTE);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND, DayTimeIntervalType.DayTimeResolution.MINUTE, DayTimeIntervalType.DayTimeResolution.SECOND);
        LogicalTypeMerging.addDayTimeMapping(DayTimeIntervalType.DayTimeResolution.SECOND, DayTimeIntervalType.DayTimeResolution.SECOND);
    }

    private static class ChildTypeView
    extends AbstractList<LogicalType> {
        private final List<LogicalType> types;
        private final int childPos;

        ChildTypeView(List<LogicalType> types, int childPos) {
            this.types = types;
            this.childPos = childPos;
        }

        @Override
        public LogicalType get(int index) {
            return this.types.get(index).getChildren().get(this.childPos);
        }

        @Override
        public int size() {
            return this.types.size();
        }
    }
}

