/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropViewOperation
implements DropOperation {
    private final ObjectIdentifier viewIdentifier;
    private final boolean ifExists;
    private final boolean isTemporary;

    public DropViewOperation(ObjectIdentifier viewIdentifier, boolean ifExists, boolean isTemporary) {
        this.viewIdentifier = viewIdentifier;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    public ObjectIdentifier getViewIdentifier() {
        return this.viewIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.viewIdentifier);
        params.put("ifExists", this.ifExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("DROP VIEW", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

