/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.registration;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.util.Preconditions;

public class JobManagerRegistration {
    private final JobID jobID;
    private final ResourceID jobManagerResourceID;
    private final JobMasterGateway jobManagerGateway;

    public JobManagerRegistration(JobID jobID, ResourceID jobManagerResourceID, JobMasterGateway jobManagerGateway) {
        this.jobID = Preconditions.checkNotNull(jobID);
        this.jobManagerResourceID = Preconditions.checkNotNull(jobManagerResourceID);
        this.jobManagerGateway = Preconditions.checkNotNull(jobManagerGateway);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public ResourceID getJobManagerResourceID() {
        return this.jobManagerResourceID;
    }

    public JobMasterId getJobMasterId() {
        return (JobMasterId)this.jobManagerGateway.getFencingToken();
    }

    public JobMasterGateway getJobManagerGateway() {
        return this.jobManagerGateway;
    }
}

