/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector;

import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.SettableUnionObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.UnionObject;

public class StandardUnionObjectInspector
extends SettableUnionObjectInspector {
    private List<ObjectInspector> ois;

    protected StandardUnionObjectInspector() {
    }

    public StandardUnionObjectInspector(List<ObjectInspector> ois) {
        this.ois = ois;
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    @Override
    public byte getTag(Object o) {
        if (o == null) {
            return -1;
        }
        return ((UnionObject)o).getTag();
    }

    @Override
    public Object getField(Object o) {
        if (o == null) {
            return null;
        }
        return ((UnionObject)o).getObject();
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(this.getTypeName());
        return sb.toString();
    }

    @Override
    public Object create() {
        return new StandardUnion();
    }

    @Override
    public Object setFieldAndTag(Object union, Object field, byte tag) {
        StandardUnion unionObject = (StandardUnion)union;
        unionObject.setObject(field);
        if (field == null) {
            unionObject.setTag((byte)-1);
        } else {
            unionObject.setTag(tag);
        }
        return unionObject;
    }

    public static class StandardUnion
    implements UnionObject {
        protected byte tag;
        protected Object object;

        public StandardUnion() {
        }

        public StandardUnion(byte tag, Object object) {
            this.tag = tag;
            this.object = object;
        }

        public void setObject(Object o) {
            this.object = o;
        }

        public void setTag(byte tag) {
            this.tag = tag;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public byte getTag() {
            return this.tag;
        }

        public String toString() {
            return this.tag + ":" + this.object;
        }

        public int hashCode() {
            if (this.object == null) {
                return this.tag;
            }
            return this.object.hashCode() ^ this.tag;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StandardUnion)) {
                return false;
            }
            StandardUnion that = (StandardUnion)obj;
            if (this.object == null || that.object == null) {
                return this.tag == that.tag && this.object == that.object;
            }
            return this.tag == that.tag && this.object.equals(that.object);
        }
    }
}

