/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.txn;

import java.util.concurrent.TimeUnit;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidOpenTxnsCounterService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidOpenTxnsCounterService.class);
    private Configuration conf;
    private int isAliveCounter = 0;
    private long lastLogTime = 0L;
    private TxnStore txnHandler;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COUNT_OPEN_TXNS_INTERVAL, unit);
    }

    @Override
    public void run() {
        try {
            long startTime = System.currentTimeMillis();
            ++this.isAliveCounter;
            this.txnHandler.countOpenTxns();
            if (System.currentTimeMillis() - this.lastLogTime > 60000L) {
                LOG.info("AcidOpenTxnsCounterService ran for " + (System.currentTimeMillis() - startTime) / 1000L + " seconds.  isAliveCounter = " + this.isAliveCounter);
                this.lastLogTime = System.currentTimeMillis();
            }
        }
        catch (Throwable t) {
            LOG.error("Serious error in {}", new Object[]{Thread.currentThread().getName(), ": {}" + t.getMessage(), t});
        }
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

